/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import org.linkedin.util.json.jackson.LfNSpacesIndenter;

public class JacksonPrettyPrinter
implements PrettyPrinter {
    public static final DefaultPrettyPrinter.Indenter LF_2_SPACES_INDENTER = new DefaultPrettyPrinter.Lf2SpacesIndenter();
    private final DefaultPrettyPrinter.Indenter _indenter;
    private int _nesting = 0;

    public JacksonPrettyPrinter(int indent) {
        this._indenter = indent == 2 ? LF_2_SPACES_INDENTER : new LfNSpacesIndenter(indent);
    }

    public void writeRootValueSeparator(JsonGenerator jg) throws IOException {
    }

    private void writeIndentation(JsonGenerator jg) throws IOException {
        this._indenter.writeIndentation(jg, this._nesting);
    }

    public void writeStartObject(JsonGenerator jg) throws IOException {
        jg.writeRaw('{');
        ++this._nesting;
    }

    public void writeEndObject(JsonGenerator jg, int nrOfEntries) throws IOException {
        --this._nesting;
        this.writeIndentation(jg);
        jg.writeRaw('}');
    }

    public void writeObjectEntrySeparator(JsonGenerator jg) throws IOException {
        jg.writeRaw(',');
        this.writeIndentation(jg);
    }

    public void writeObjectFieldValueSeparator(JsonGenerator jg) throws IOException {
        jg.writeRaw(": ");
    }

    public void writeStartArray(JsonGenerator jg) throws IOException {
        jg.writeRaw('[');
        ++this._nesting;
    }

    public void writeEndArray(JsonGenerator jg, int nrOfValues) throws IOException {
        --this._nesting;
        this.writeIndentation(jg);
        jg.writeRaw(']');
    }

    public void writeArrayValueSeparator(JsonGenerator jg) throws IOException {
        jg.writeRaw(',');
        this.writeIndentation(jg);
    }

    public void beforeArrayValues(JsonGenerator jg) throws IOException {
        this.writeIndentation(jg);
    }

    public void beforeObjectEntries(JsonGenerator jg) throws IOException {
        this.writeIndentation(jg);
    }
}

