/*
 * Decompiled with CFR 0.152.
 */
package org.lilicurroad.jenkins.packageversion.yum;

import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.lilicurroad.jenkins.packageversion.yum.model.repo.Repomd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YumRepomdParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(YumRepomdParser.class);
    private final Unmarshaller unmarshaller;

    public YumRepomdParser() {
        try {
            this.unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Repomd.class}).createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Couldn't initialize Yum Metadata XML parser.", e);
        }
    }

    public Repomd parse(InputStream inputStream) {
        try {
            JAXBElement jaxbElement = this.unmarshaller.unmarshal((Source)new StreamSource(inputStream), Repomd.class);
            return (Repomd)jaxbElement.getValue();
        }
        catch (JAXBException e) {
            LOGGER.error("Cannot communicate with the Yum repomd repository xml", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

