/*
 * Decompiled with CFR 0.152.
 */
package org.lilicurroad.jenkins.packageversion.yum;

import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.lilicurroad.jenkins.packageversion.yum.model.common.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YumPrimaryParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(YumPrimaryParser.class);
    private final Unmarshaller unmarshaller;

    public YumPrimaryParser() {
        try {
            this.unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Metadata.class}).createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Couldn't initialize Yum Metadata XML parser.", e);
        }
    }

    public Metadata parse(InputStream inputStream) {
        try {
            JAXBElement jaxbElement = this.unmarshaller.unmarshal((Source)new StreamSource(inputStream), Metadata.class);
            return (Metadata)jaxbElement.getValue();
        }
        catch (JAXBException e) {
            LOGGER.error("Cannot communicate with the Yum primary repository xml", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

