/*
 * Decompiled with CFR 0.152.
 */
package org.lilicurroad.jenkins.packageversion.yum;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.lilicurroad.jenkins.packageversion.PackageMetadata;
import org.lilicurroad.jenkins.packageversion.PackageMetadataProvider;
import org.lilicurroad.jenkins.packageversion.yum.YumPrimaryParser;
import org.lilicurroad.jenkins.packageversion.yum.YumRepomdParser;
import org.lilicurroad.jenkins.packageversion.yum.model.repo.Data;

public class YumMetadataProvider
implements PackageMetadataProvider {
    private final YumPrimaryParser yumPrimaryParser = new YumPrimaryParser();
    private final YumRepomdParser yumRepomdParser = new YumRepomdParser();

    @Override
    public List<PackageMetadata> extract(String url) {
        return this.getPackages(this.getMetatdataFilePath(url));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<PackageMetadata> getPackages(String repoPath) {
        try (GZIPInputStream repoStream = new GZIPInputStream(new URL(repoPath).openStream());){
            List<PackageMetadata> list = this.yumPrimaryParser.parse(repoStream).getPackages().stream().collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't retrieve Yum package metadata", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<Data> getData(String repoPath) {
        try (InputStream repoStream = new URL(String.format("%s/repodata/repomd.xml", repoPath)).openStream();){
            List<Data> list = this.yumRepomdParser.parse(repoStream).getData().stream().collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't retrieve Yum repo metadata", e);
        }
    }

    private String getMetatdataFilePath(String repoPath) {
        Optional<String> location = this.getData(repoPath).stream().filter(data -> data.getType().equals("primary")).map(data -> data.getLocation().getHref()).findFirst();
        return String.format("%s/%s", repoPath, location.orElse("repodata/primary.xml.gz"));
    }
}

