/*
 * Decompiled with CFR 0.152.
 */
package org.lilicurroad.jenkins.packageversion;

import hudson.Extension;
import hudson.model.Descriptor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.lilicurroad.jenkins.packageversion.Repository;

@Extension
public class RepositoryConfiguration
extends GlobalConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Repository> repos = new HashMap<String, Repository>();

    public RepositoryConfiguration() {
        this.load();
    }

    public static RepositoryConfiguration get() {
        return (RepositoryConfiguration)GlobalConfiguration.all().get(RepositoryConfiguration.class);
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        this.repos.clear();
        Object repoJson = formData.get("repos");
        if (repoJson instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)repoJson;
            for (Object object : jsonArray) {
                this.addRepo(req, (JSONObject)object);
            }
        } else {
            this.addRepo(req, (JSONObject)repoJson);
        }
        this.save();
        return true;
    }

    private void addRepo(StaplerRequest req, JSONObject jsonObject) {
        Repository repo = (Repository)req.bindJSON(Repository.class, jsonObject);
        if (repo != null && !StringUtils.isBlank((String)repo.getUrl())) {
            this.repos.put(repo.getId(), repo);
        }
    }

    public List<Repository> getRepos() {
        return this.repos.values().stream().sorted().collect(Collectors.toList());
    }

    public Map<String, Repository> getRepositoryMap() {
        return this.repos;
    }
}

