/*
 * Decompiled with CFR 0.152.
 */
package org.lilicurroad.jenkins.packageversion;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.List;
import javax.xml.bind.JAXBException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.export.Exported;
import org.lilicurroad.jenkins.packageversion.PackageMetadataReader;
import org.lilicurroad.jenkins.packageversion.Repository;
import org.lilicurroad.jenkins.packageversion.RepositoryConfiguration;

public class PackageParameterDefinition
extends SimpleParameterDefinition {
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private final String rep;
    private final String pkg;

    @DataBoundConstructor
    public PackageParameterDefinition(String name, String description, String rep, String pkg) {
        super(name, description);
        this.rep = rep;
        this.pkg = pkg;
    }

    public ParameterValue createValue(String value) {
        return new StringParameterValue(this.getName(), value, this.getDescription());
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        StringParameterValue value = (StringParameterValue)req.bindJSON(StringParameterValue.class, jo);
        value.setDescription(this.getDescription());
        return value;
    }

    @Exported
    public List<String> getChoices() throws JAXBException, IOException {
        return PackageMetadataReader.Builder.newInstance(DESCRIPTOR.getRepo(this.rep).getUrl(), DESCRIPTOR.getRepo(this.rep).getType()).build().getPackageVersions();
    }

    public String getRep() {
        return this.rep;
    }

    public String getPkg() {
        return this.pkg;
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Package version parameter";
        }

        public String getHelpFile() {
            return "/help/parameter/choice.html";
        }

        Repository getRepo(String id) {
            Repository repo = null;
            RepositoryConfiguration repoConfig = RepositoryConfiguration.get();
            if (repoConfig != null) {
                repo = repoConfig.getRepositoryMap().get(id);
            }
            return repo;
        }

        public ListBoxModel doFillRepItems() {
            ListBoxModel items = new ListBoxModel();
            RepositoryConfiguration.get().getRepos().forEach(repository -> items.add(repository.getId(), repository.getId()));
            return items;
        }

        public ListBoxModel doFillPkgItems(@QueryParameter String rep) throws IOException {
            ListBoxModel items = new ListBoxModel();
            if (null != rep && rep.length() > 0) {
                PackageMetadataReader.Builder.newInstance(this.getRepo(rep).getUrl(), this.getRepo(rep).getType()).build().getPackageNames().forEach(s -> items.add(s, s));
            }
            return items;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            return super.configure(req, json);
        }

        @JavaScriptMethod
        public int add(int x, int y) {
            return x + y;
        }
    }
}

