/*
 * Decompiled with CFR 0.152.
 */
package org.lilicurroad.jenkins.packageversion;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.lilicurroad.jenkins.packageversion.PackageMetadata;
import org.lilicurroad.jenkins.packageversion.PackageMetadataProvider;
import org.lilicurroad.jenkins.packageversion.yum.YumMetadataProvider;

public class PackageMetadataReader {
    private final String repoPath;
    private final PackageMetadataProvider packageMetadataProvider;

    private PackageMetadataReader(Builder builder) {
        this.repoPath = builder.repoPath;
        this.packageMetadataProvider = new YumMetadataProvider();
    }

    public List<String> getPackageNames() throws IOException {
        return this.getPackages().stream().map(PackageMetadata::getPackageName).distinct().sorted().collect(Collectors.toList());
    }

    public List<String> getPackageVersions() throws IOException {
        return this.getPackages().stream().map(PackageMetadata::getPackageVersion).distinct().sorted().collect(Collectors.toList());
    }

    public List<PackageMetadata> getPackages() throws IOException {
        return this.packageMetadataProvider.extract(this.repoPath);
    }

    public static class Builder {
        private final String repoType;
        private final String repoPath;

        private Builder(String repoPath, String repoType) {
            this.repoPath = repoPath;
            this.repoType = repoType;
        }

        public static Builder newInstance(String repoPath, String repoType) {
            return new Builder(repoPath, repoType);
        }

        public PackageMetadataReader build() {
            return new PackageMetadataReader(this);
        }
    }
}

