/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.vm.schedule;

import jakarta.persistence.EntityNotFoundException;
import jakarta.transaction.Transactional;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import org.ligoj.app.model.Subscription;
import org.ligoj.app.plugin.vm.dao.VmExecutionRepository;
import org.ligoj.app.plugin.vm.dao.VmScheduleRepository;
import org.ligoj.app.plugin.vm.model.VmSchedule;
import org.ligoj.app.plugin.vm.schedule.VmJob;
import org.ligoj.app.plugin.vm.schedule.VmScheduleVo;
import org.ligoj.app.resource.ServicePluginLocator;
import org.ligoj.app.resource.node.NodeResource;
import org.ligoj.app.resource.subscription.SubscriptionResource;
import org.ligoj.bootstrap.core.DateUtils;
import org.ligoj.bootstrap.core.security.SecurityHelper;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Service;

@Service
@Path(value="/service/vm/{subscription:\\d+}/schedule")
@Produces(value={"application/json"})
public class VmScheduleResource
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(VmScheduleResource.class);
    public static final String SCHEDULE_TRIGGER_GROUP = "vm-schedule";
    @Autowired
    private JobDetailFactoryBean vmJobDetailFactoryBean;
    @Autowired
    private SchedulerFactoryBean vmSchedulerFactoryBean;
    @Autowired
    private VmScheduleRepository repository;
    @Autowired
    protected SubscriptionResource subscriptionResource;
    @Autowired
    protected NodeResource nodeResource;
    @Autowired
    protected ServicePluginLocator locator;
    @Autowired
    protected SecurityHelper securityHelper;
    @Autowired
    private VmExecutionRepository vmExecutionRepository;

    @Transactional
    public void delete(int subscription) throws SchedulerException {
        this.unscheduleAll(subscription);
        this.vmExecutionRepository.deleteAllBy("subscription.id", subscription);
    }

    @DELETE
    @Path(value="{id:\\d+}")
    @Transactional
    public void delete(@PathParam(value="subscription") int subscription, @PathParam(value="id") int schedule) throws SchedulerException {
        this.subscriptionResource.checkVisible(Integer.valueOf(subscription));
        this.checkOwnership(subscription, schedule);
        this.unschedule(schedule);
    }

    private void unschedule(int schedule) throws SchedulerException {
        this.unscheduleQuartz(schedule);
        this.repository.deleteById(schedule);
    }

    private void unscheduleQuartz(int schedule) throws SchedulerException {
        this.unscheduleAll(triggerKey -> schedule == VmJob.getSchedule(triggerKey));
    }

    protected void unscheduleAll(int subscription) throws SchedulerException {
        this.unscheduleAll(triggerKey -> subscription == VmJob.getSubscription(triggerKey));
        this.repository.deleteAllBy("subscription.id", subscription);
    }

    private void unscheduleAll(Predicate<TriggerKey> predicate) throws SchedulerException {
        Scheduler scheduler = this.vmSchedulerFactoryBean.getObject();
        for (TriggerKey triggerKey : scheduler.getTriggerKeys(GroupMatcher.groupEquals((String)SCHEDULE_TRIGGER_GROUP))) {
            if (!predicate.test(triggerKey)) continue;
            scheduler.unscheduleJob(triggerKey);
        }
    }

    private VmSchedule persistTrigger(VmSchedule schedule) throws SchedulerException {
        String id = VmJob.format(schedule);
        JobDetailImpl object = (JobDetailImpl)this.vmJobDetailFactoryBean.getObject();
        object.getJobDataMap().put("vmServicePlugin", (Object)this);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(id, SCHEDULE_TRIGGER_GROUP).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)schedule.getCron()).inTimeZone(DateUtils.getApplicationTimeZone())).forJob((JobDetail)object).usingJobData("subscription", (Integer)schedule.getSubscription().getId()).usingJobData("operation", schedule.getOperation().name()).usingJobData("schedule", (Integer)schedule.getId()).build();
        this.vmSchedulerFactoryBean.getObject().scheduleJob(trigger);
        return schedule;
    }

    @Transactional
    public void afterPropertiesSet() throws SchedulerException {
        List schedules = this.repository.findAll();
        log.info("Schedules {} jobs from database", (Object)schedules.size());
        for (VmSchedule schedule : schedules) {
            this.persistTrigger(schedule);
        }
    }

    @org.springframework.transaction.annotation.Transactional(readOnly=true)
    public List<VmScheduleVo> findAll(int subscription) throws ParseException {
        ArrayList<VmScheduleVo> schedules = new ArrayList<VmScheduleVo>();
        Date now = DateUtils.newCalendar().getTime();
        for (VmSchedule schedule : this.repository.findBySubscription(subscription)) {
            VmScheduleVo vo = new VmScheduleVo();
            vo.setCron(schedule.getCron());
            vo.setOperation(schedule.getOperation());
            vo.setId((Integer)schedule.getId());
            vo.setNext(new CronExpression(schedule.getCron()).getNextValidTimeAfter(now));
            schedules.add(vo);
        }
        return schedules;
    }

    @POST
    @Transactional
    public int create(@PathParam(value="subscription") int subscription, VmScheduleVo schedule) throws SchedulerException {
        return (Integer)this.persistTrigger(this.checkAndSave(subscription, schedule, new VmSchedule())).getId();
    }

    @PUT
    @Transactional
    public void update(@PathParam(value="subscription") int subscription, VmScheduleVo schedule) throws SchedulerException {
        VmSchedule entity = this.checkOwnership(subscription, schedule.getId());
        this.checkAndSave(subscription, schedule, entity);
        this.unscheduleQuartz(schedule.getId());
        this.persistTrigger(this.checkAndSave(subscription, schedule, entity));
    }

    private VmSchedule checkAndSave(int subscription, VmScheduleVo schedule, VmSchedule entity) {
        Subscription subscriptionEntity = this.subscriptionResource.checkVisible(Integer.valueOf(subscription));
        if (schedule.getCron().split(" ").length == 6) {
            schedule.setCron(schedule.getCron() + " *");
        }
        if (!CronExpression.isValidExpression((String)schedule.getCron())) {
            throw new ValidationJsonException("cron", (Serializable)((Object)"vm-cron"), new Serializable[0]);
        }
        if (schedule.getCron().startsWith("* ")) {
            throw new ValidationJsonException("cron", (Serializable)((Object)"vm-cron-second"), new Serializable[0]);
        }
        entity.setSubscription(subscriptionEntity);
        entity.setOperation(schedule.getOperation());
        entity.setCron(schedule.getCron());
        this.repository.saveAndFlush((Object)entity);
        return entity;
    }

    private VmSchedule checkOwnership(int subscription, int schedule) {
        VmSchedule entity = (VmSchedule)((Object)this.repository.findOneExpected(Integer.valueOf(schedule)));
        if ((Integer)entity.getSubscription().getId() != subscription) {
            throw new EntityNotFoundException(String.valueOf(schedule));
        }
        return entity;
    }
}

