/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.vm;

import jakarta.transaction.Transactional;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.text.ParseException;
import org.ligoj.app.api.ConfigurablePlugin;
import org.ligoj.app.model.Subscription;
import org.ligoj.app.plugin.vm.VmConfigurationVo;
import org.ligoj.app.plugin.vm.schedule.VmScheduleResource;
import org.ligoj.app.plugin.vm.snapshot.Snapshotting;
import org.ligoj.app.resource.ServicePluginLocator;
import org.ligoj.app.resource.plugin.AbstractServicePlugin;
import org.ligoj.app.resource.subscription.SubscriptionResource;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Path(value="/service/vm")
@Produces(value={"application/json"})
public class VmResource
extends AbstractServicePlugin
implements ConfigurablePlugin {
    public static final String SERVICE_URL = "/service/vm";
    public static final String SERVICE_KEY = "/service/vm".replace('/', ':').substring(1);
    @Autowired
    protected SubscriptionResource subscriptionResource;
    @Autowired
    protected ServicePluginLocator locator;
    @Autowired
    protected VmScheduleResource scheduleResource;

    public String getKey() {
        return SERVICE_KEY;
    }

    @Transactional
    public void delete(int subscription, boolean deleteRemoteData) throws SchedulerException {
        this.scheduleResource.delete(subscription);
    }

    @GET
    @Path(value="{subscription:\\d+}")
    @Transactional
    @org.springframework.transaction.annotation.Transactional(readOnly=true)
    public VmConfigurationVo getConfiguration(@PathParam(value="subscription") int subscription) throws ParseException {
        Subscription entity = this.subscriptionResource.checkVisible(Integer.valueOf(subscription));
        VmConfigurationVo result = new VmConfigurationVo();
        result.setSchedules(this.scheduleResource.findAll(subscription));
        result.setSupportSnapshot(this.locator.getResource(entity.getNode().getId(), Snapshotting.class) != null);
        return result;
    }
}

