/*
 * Decompiled with CFR 0.152.
 */
package org.libj.net;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.libj.lang.Strings;
import org.libj.net.DelegateURLConnection;
import org.libj.net.URLConnections;
import org.libj.net.offline.OfflineURLStreamHandler;
import org.libj.util.StringPaths;

public final class URLs {
    public static final String REGEX = "^([a-z][a-z0-9+\\-.]*):(\\/\\/([a-z0-9\\-._~%!$&amp;'()*+,;=]+@)?([a-z0-9\\-._~%]+|\\[[a-f0-9:.]+\\]|\\[v[a-f0-9][a-z0-9\\-._~%!$&amp;'()*+,;=:]+\\])(:[0-9]+)?(\\/[a-z0-9\\-._~%!$&amp;'()*+,;=:@]+)*\\/?|(\\/?[a-z0-9\\-._~%!$&amp;'()*+,;=:@]+(\\/[a-z0-9\\-._~%!$&amp;'()*+,;=:@]+)*\\/?)?)(\\?[a-z0-9\\-._~%!$&amp;'()*+,;=:@/?]*)?(#[a-z0-9\\-._~%!$&amp;'()*+,;=:@/?]*)?$";
    private static final int DEFAULT_TIMEOUT = 1000;
    private static final String PATH_RESERVED_CHARACTERS = "=@/:!$&'(),;~";

    public static URL create(String str) {
        try {
            return new URL(str);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static URL create(URL context, String spec) {
        return URLs.create(context, spec, null);
    }

    public static URL create(URL context, String spec, URLStreamHandler handler) {
        try {
            return new URL(context, spec, handler);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static URL create(String protocol, String host, String file) {
        return URLs.create(protocol, host, -1, file, null);
    }

    public static URL create(String protocol, String host, int port, String file) {
        return URLs.create(protocol, host, port, file, null);
    }

    public static URL create(String protocol, String host, int port, String file, URLStreamHandler handler) {
        try {
            return new URL(protocol, host, -1, file, handler);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static URL create(String basedir, String path) {
        return URLs.fromStringPath(StringPaths.newPath((String)basedir, (String)path));
    }

    public static URL fromStringPath(String stringPath) {
        if (stringPath == null) {
            return null;
        }
        if (stringPath.contains(":/") && stringPath.charAt(0) != '/') {
            return URLs.create(stringPath);
        }
        if (StringPaths.isAbsoluteLocalWindows((String)stringPath)) {
            stringPath = "/" + stringPath.replace('\\', '/');
        }
        return URLs.create("file", "", stringPath);
    }

    public static URL fromURI(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static URL toCanonicalURL(String stringPath) {
        if (StringPaths.isAbsoluteLocalWindows((String)stringPath)) {
            stringPath = "/" + stringPath.replace('\\', '/');
        }
        return URLs.toCanonicalURL0(stringPath);
    }

    public static URL toCanonicalURL(String basedir, String path) {
        if (StringPaths.isAbsoluteLocalWindows((String)basedir)) {
            basedir = "/" + basedir.replace('\\', '/');
        }
        return URLs.toCanonicalURL0(StringPaths.newPath((String)basedir, (String)path));
    }

    private static URL toCanonicalURL0(String stringPath) {
        String canonicalPath = StringPaths.canonicalize((String)stringPath);
        if (canonicalPath.charAt(0) == '/' || !canonicalPath.contains(":/") && !canonicalPath.startsWith("file:") && !canonicalPath.startsWith("jar:file:")) {
            return URLs.create("file", "", canonicalPath);
        }
        return URLs.create(canonicalPath);
    }

    public static URL[] toURL(File ... files) {
        try {
            URL[] urls = new URL[files.length];
            int i$ = files.length;
            for (int i = 0; i < i$; ++i) {
                urls[i] = files[i].toURI().toURL();
            }
            return urls;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static URL canonicalize(URL url) {
        return url == null ? null : URLs.create(url.getProtocol(), url.getHost(), url.getPort(), StringPaths.canonicalize((String)url.getPath().toString()));
    }

    public static boolean exists(URL url, int timeout) {
        try {
            if ("file".equals(url.getProtocol())) {
                return new File(url.toURI()).exists();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        try {
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(timeout);
            URLConnections.checkFollowRedirect(connection).getInputStream().close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean exists(URL url) {
        return URLs.exists(url, 1000);
    }

    public static boolean isLocalFile(URL url) {
        String host = url.getHost();
        return "file".equalsIgnoreCase(url.getProtocol()) && (host == null || host.length() == 0 || "localhost".equals(host));
    }

    /*
     * Exception decompiling
     */
    public static boolean isLocalJarFile(URL url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isLocal(URL url) {
        return URLs.isLocalFile(url) || URLs.isLocalJarFile(url);
    }

    public static boolean isJar(URL url) {
        try {
            return url.toURI().toString().startsWith("jar:");
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static URL getJarURL(URL url) {
        return URLs.isJar(url) ? URLs.create(url.getFile().substring(0, url.getFile().indexOf(33))) : null;
    }

    public static String getJarPath(URL url) {
        return !URLs.isJar(url) ? null : url.getFile().substring(url.getFile().indexOf(33) + 2);
    }

    public static String getName(URL url) {
        return StringPaths.getName((String)url.toString());
    }

    public static String getSimpleName(URL url) {
        return StringPaths.getSimpleName((String)url.toString());
    }

    public static URL getParent(URL url) {
        String parentPath = StringPaths.getParent((String)url.toString());
        return parentPath == null ? null : URLs.create(parentPath);
    }

    public static URL getCanonicalParent(URL url) {
        return url == null ? null : URLs.create(StringPaths.getCanonicalParent((String)url.toString()));
    }

    public static String encode(String s) {
        return URLs.encode(s, StandardCharsets.UTF_8.name());
    }

    public static String encode(String s, String enc) {
        try {
            return URLEncoder.encode(s, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static String encode(String s, Charset charset) {
        try {
            return URLEncoder.encode(s, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static String decode(String s) {
        return URLs.decode(s, StandardCharsets.UTF_8, false);
    }

    public static String decode(String s, Charset charset) {
        return URLs.decode(s, charset, false);
    }

    public static String decode(String s, String enc) {
        return URLs.decode(s, Charset.forName(enc), false);
    }

    private static String decode(String s, Charset charset, boolean isPath) {
        boolean needDecode = false;
        int escapesCount = 0;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (ch == '%') {
                ++escapesCount;
                i += 2;
                needDecode = true;
                continue;
            }
            if (isPath || ch != '+') continue;
            needDecode = true;
        }
        if (needDecode) {
            ByteBuffer in = ByteBuffer.wrap(Strings.getBytes((String)s, (String)charset.name()));
            ByteBuffer out = ByteBuffer.allocate(in.capacity() - 2 * escapesCount + 1);
            while (in.hasRemaining()) {
                byte b = in.get();
                if (!isPath && b == 43) {
                    out.put((byte)32);
                    continue;
                }
                if (b == 37) {
                    try {
                        int u = URLs.digit16(in.get());
                        int l = URLs.digit16(in.get());
                        out.put((byte)((u << 4) + l));
                        continue;
                    }
                    catch (BufferUnderflowException e) {
                        throw new IllegalArgumentException("Invalid URL encoding: Incomplete trailing escape (%) pattern", e);
                    }
                }
                out.put(b);
            }
            ((Buffer)out).flip();
            return charset.decode(out).toString();
        }
        return s;
    }

    private static int digit16(byte b) {
        int d = Character.digit((char)b, 16);
        if (d == -1) {
            throw new IllegalArgumentException("Invalid URL encoding: not a valid digit (radix 16): " + b);
        }
        return d;
    }

    private static StringBuilder componentEncode(String reservedChars, String value) {
        StringBuilder builder = new StringBuilder();
        StringBuilder builderToEncode = new StringBuilder();
        int i$ = value.length();
        for (int i = 0; i < i$; ++i) {
            char ch = value.charAt(i);
            if (reservedChars.indexOf(ch) != -1) {
                if (builderToEncode.length() > 0) {
                    builder.append(URLs.encode(builderToEncode.toString()));
                    builderToEncode.setLength(0);
                }
                builder.append(ch);
                continue;
            }
            builderToEncode.append(ch);
        }
        if (builderToEncode.length() > 0) {
            builder.append(URLs.encode(builderToEncode.toString()));
        }
        return builder;
    }

    public static String encodePath(String path) {
        StringBuilder result = URLs.componentEncode(PATH_RESERVED_CHARACTERS, path);
        Strings.replace((StringBuilder)result, (CharSequence)"+", (CharSequence)"%20");
        Strings.replace((StringBuilder)result, (CharSequence)"%2B", (CharSequence)"+");
        return result.toString();
    }

    public static String decodePath(String path) {
        return URLs.decode(path, StandardCharsets.UTF_8, true);
    }

    public static URL disableHttp(final URL url) {
        if (!url.getProtocol().startsWith("http")) {
            return url;
        }
        try {
            return new URL(url, "", new URLStreamHandler(){

                @Override
                protected InetAddress getHostAddress(URL u) {
                    return null;
                }

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    return this.openConnection(u, null);
                }

                @Override
                protected URLConnection openConnection(final URL u, Proxy proxy) throws IOException {
                    return new DelegateURLConnection(proxy != null ? url.openConnection(proxy) : url.openConnection()){

                        @Override
                        public InputStream getInputStream() {
                            return new InputStream(){

                                @Override
                                public int read() throws FileNotFoundException {
                                    throw new FileNotFoundException(u.toString());
                                }
                            };
                        }

                        @Override
                        public OutputStream getOutputStream() {
                            return new OutputStream(){

                                @Override
                                public void write(int b) throws FileNotFoundException {
                                    throw new FileNotFoundException(u.toString());
                                }
                            };
                        }
                    };
                }
            });
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void disableRemote() {
        OfflineURLStreamHandler.register();
    }

    public static URL withLiteralHost(String spec) {
        return URLs.create(null, spec, new LiteralHostStreamHandler());
    }

    public static byte[] readBytes(URL url) throws IOException {
        try (InputStream in = url.openStream();){
            int length;
            ByteArrayOutputStream buf = new ByteArrayOutputStream(1024);
            byte[] data = new byte[1024];
            while ((length = in.read(data)) != -1) {
                buf.write(data, 0, length);
            }
            byte[] byArray = buf.toByteArray();
            return byArray;
        }
    }

    private URLs() {
    }

    private static class LiteralHostStreamHandler
    extends URLStreamHandler {
        private URL url;

        private LiteralHostStreamHandler() {
        }

        private URL full(URL url) throws MalformedURLException {
            return this.url == null ? (this.url = new URL(url, "")) : this.url;
        }

        @Override
        protected InetAddress getHostAddress(URL u) {
            return null;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return this.full(u).openConnection();
        }

        @Override
        protected URLConnection openConnection(URL u, Proxy proxy) throws IOException {
            return this.full(u).openConnection(proxy);
        }
    }
}

