/*
 * Decompiled with CFR 0.152.
 */
package org.libj.net;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.libj.lang.Assertions;
import org.libj.util.function.ThrowingConsumer;

public final class URLConnections {
    public static URLConnection checkFollowRedirect(URLConnection connection) throws IOException {
        return URLConnections.checkFollowRedirect(connection, Integer.MAX_VALUE, null);
    }

    public static URLConnection checkFollowRedirect(URLConnection connection, ThrowingConsumer<HttpURLConnection, IOException> beforeConnect) throws IOException {
        return URLConnections.checkFollowRedirect(connection, Integer.MAX_VALUE, beforeConnect);
    }

    public static URLConnection checkFollowRedirect(URLConnection connection, int maxRedirects, ThrowingConsumer<HttpURLConnection, IOException> beforeConnect) throws IOException {
        int status;
        Assertions.assertNotNegative((int)maxRedirects);
        if (!(connection instanceof HttpURLConnection)) {
            return connection;
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
        if (beforeConnect != null) {
            beforeConnect.accept((Object)httpURLConnection);
        }
        if ((status = httpURLConnection.getResponseCode()) < 301 || 303 < status || 0 == maxRedirects) {
            return connection;
        }
        String location0 = httpURLConnection.getURL().toString();
        String location = httpURLConnection.getHeaderField("Location");
        if (location.equals(location0)) {
            throw new IOException("Infinite redirection loop: " + location + " -> " + location);
        }
        httpURLConnection.disconnect();
        try {
            connection = new URL(location).openConnection();
            if (!(connection instanceof HttpURLConnection)) {
                return connection;
            }
            httpURLConnection = (HttpURLConnection)connection;
            if (beforeConnect != null) {
                beforeConnect.accept((Object)httpURLConnection);
            }
            if ((status = httpURLConnection.getResponseCode()) < 301 || 303 < status || 1 == maxRedirects) {
                return connection;
            }
            LinkedHashSet<String> visited = new LinkedHashSet<String>();
            visited.add(location0);
            visited.add(location);
            int i = 1;
            do {
                if (!visited.add(location = httpURLConnection.getHeaderField("Location"))) {
                    throw new IOException("Infinite redirection loop: " + visited.stream().collect(Collectors.joining(" -> ")) + " -> " + location);
                }
                httpURLConnection.disconnect();
                connection = new URL(location).openConnection();
                if (!(connection instanceof HttpURLConnection)) {
                    return connection;
                }
                httpURLConnection = (HttpURLConnection)connection;
                if (beforeConnect == null) continue;
                beforeConnect.accept((Object)httpURLConnection);
            } while ((status = httpURLConnection.getResponseCode()) >= 301 && 303 >= status && ++i != maxRedirects);
            return connection;
        }
        catch (IOException e) {
            httpURLConnection.disconnect();
            throw e;
        }
    }

    public static void setRequestProperties(URLConnection urlConnection, Properties properties) {
        if (properties.size() > 0) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                urlConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private URLConnections() {
    }
}

