/*
 * Decompiled with CFR 0.152.
 */
package org.libj.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Objects;
import org.libj.lang.Numbers;

public class ProxyURI {
    protected final String proxyUri;
    protected final Proxy.Type type;
    protected final String host;
    protected final int port;
    protected final String username;
    protected final char[] password;
    private InetSocketAddress inetSocketAddress;
    private Proxy proxy;

    private static IllegalArgumentException malformedProxyUriException(String proxyUri) {
        return new IllegalArgumentException("Malformed Proxy URI: <http|socks>://[username:password@]<host>[:port]: " + proxyUri);
    }

    private InetSocketAddress inetSocketAddress() {
        return this.inetSocketAddress == null ? (this.inetSocketAddress = new InetSocketAddress(this.host, this.port)) : this.inetSocketAddress;
    }

    public ProxyURI(String proxyUri) {
        this.proxyUri = Objects.requireNonNull(proxyUri);
        int len = proxyUri.length();
        int i = proxyUri.indexOf(58);
        if (len < i + 3 || proxyUri.charAt(i + 1) != '/' || proxyUri.charAt(i + 2) != '/') {
            throw ProxyURI.malformedProxyUriException(proxyUri);
        }
        String scheme = proxyUri.substring(0, i);
        this.type = scheme.startsWith("socks") ? Proxy.Type.SOCKS : Proxy.Type.HTTP;
        int j = i + 3;
        if ((i = proxyUri.indexOf(64, j)) < 0) {
            this.username = null;
            this.password = null;
        } else {
            int k = i;
            if ((i = proxyUri.lastIndexOf(58, k - 1)) < j) {
                throw ProxyURI.malformedProxyUriException(proxyUri);
            }
            this.username = proxyUri.substring(j, i);
            this.password = new char[k - i - 1];
            proxyUri.getChars(i + 1, k, this.password, 0);
            j = k + 1;
        }
        i = proxyUri.indexOf(58, j);
        if (i > -1) {
            this.host = proxyUri.substring(j, i);
            this.port = Numbers.parseInt((CharSequence)proxyUri.substring(i + 1), (int)-1);
            if (this.port == -1) {
                throw ProxyURI.malformedProxyUriException(proxyUri);
            }
        } else {
            this.host = proxyUri.substring(j);
            this.port = this.type == Proxy.Type.SOCKS ? 1080 : 3128;
        }
    }

    public Proxy.Type getType() {
        return this.type;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public InetAddress getInetAddress() {
        return this.inetSocketAddress().getAddress();
    }

    public Proxy getProxy() {
        return this.proxy == null ? (this.proxy = new Proxy(this.type, this.inetSocketAddress())) : this.proxy;
    }

    public int hashCode() {
        return 31 + this.proxyUri.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ProxyURI && this.proxyUri.equals(((ProxyURI)obj).proxyUri);
    }

    public String toString() {
        return this.proxyUri;
    }
}

