/*
 * Decompiled with CFR 0.152.
 */
package org.libj.net;

import java.net.URL;
import java.net.URLStreamHandler;
import org.libj.net.URLStreamHandlers;
import org.libj.net.URLs;
import org.libj.net.classpath.Handler;

public abstract class ClasspathURLStreamHandler
extends URLStreamHandler {
    protected static final boolean loadMe = true;

    public static URL createURL(String resourcePath) {
        return URLs.create("classpath:" + resourcePath.toString());
    }

    public static URL getResource(URL url) {
        if (!"classpath".equals(url.getProtocol())) {
            throw new IllegalArgumentException("Illegal protocol: " + url.getProtocol());
        }
        if (url.getHost() != null && url.getHost().length() > 0) {
            throw new IllegalArgumentException("Illegal host: " + url.getHost());
        }
        return Thread.currentThread().getContextClassLoader().getResource(url.getPath());
    }

    static {
        URLStreamHandlers.register(Handler.class, Handler.Factory.class);
    }
}

