/*
 * Decompiled with CFR 0.152.
 */
package org.libj.net;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import org.libj.io.Streams;
import org.libj.lang.Assertions;
import org.libj.net.FilterServletInputStream;

public class BufferedServletInputStream
extends FilterServletInputStream {
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private byte[] buf;
    private int count;
    private int pos = 0;
    private int markpos = -1;
    private int readlimit;

    public BufferedServletInputStream(ServletInputStream in, int maxLength) throws IOException {
        super(in);
        this.buf = Streams.readBytes((InputStream)in, (int)maxLength);
        this.count = this.buf.length;
    }

    private ServletInputStream getInIfOpen() throws IOException {
        ServletInputStream input = this.in;
        if (input == null) {
            throw new IOException("Stream closed");
        }
        return input;
    }

    private byte[] getBufIfOpen() throws IOException {
        byte[] buf = this.buf;
        if (buf == null) {
            throw new IOException("Stream closed");
        }
        return buf;
    }

    private void fill(byte[] buf) throws IOException {
        int n;
        int dst;
        if (this.markpos <= -1) {
            dst = 0;
        } else {
            int delta = this.pos - this.markpos;
            if (delta >= this.readlimit) {
                this.markpos = -2;
                this.readlimit = 0;
                dst = 0;
            } else {
                if (this.readlimit <= buf.length) {
                    System.arraycopy(buf, this.markpos, buf, 0, delta);
                    this.markpos = 0;
                    dst = delta;
                } else {
                    byte[] ncb = new byte[this.readlimit];
                    System.arraycopy(buf, this.markpos, ncb, 0, delta);
                    buf = ncb;
                    this.buf = ncb;
                    this.markpos = 0;
                    dst = delta;
                }
                this.pos = this.count = delta;
            }
        }
        ServletInputStream in = this.getInIfOpen();
        while ((n = in.read(buf, dst, buf.length - dst)) == 0) {
        }
        if (n > 0) {
            this.count = dst + n;
            this.pos = dst;
        }
    }

    @Override
    public int read() throws IOException {
        byte[] buf = this.getBufIfOpen();
        if (this.pos >= this.count) {
            this.fill(buf);
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return buf[this.pos++];
    }

    private int read1(byte[] b, int off, int len) throws IOException {
        if (this.pos >= this.count) {
            if (len >= this.buf.length && this.markpos <= -1) {
                return this.in.read(b, off, len);
            }
            this.fill(this.buf);
        }
        if (this.pos >= this.count) {
            return -1;
        }
        int n = Math.min(len, this.count - this.pos);
        System.arraycopy(this.buf, this.pos, b, off, n);
        this.pos += n;
        return n;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n1;
        ServletInputStream in = this.getInIfOpen();
        Assertions.assertBoundsOffsetCount((String)"b.length", (int)b.length, (String)"off", (int)off, (String)"len", (int)len);
        if (len == 0) {
            return 0;
        }
        int n = this.read1(b, off, len);
        if (n <= 0) {
            return n;
        }
        while (n < len && in.isReady() && (n1 = this.read1(b, off + n, len - n)) > 0) {
            n += n1;
        }
        return n;
    }

    @Override
    public boolean isFinished() {
        return this.pos >= this.count;
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        Assertions.assertBoundsOffsetCount((String)"b.length", (int)b.length, (String)"off", (int)off, (String)"len", (int)len);
        byte[] buf = this.getBufIfOpen();
        if (len == 0) {
            return 0;
        }
        int end = off + len;
        int j = off;
        block0: while (true) {
            if (this.pos >= this.count) {
                this.fill(buf);
            }
            if (this.pos >= this.count) {
                return j > off ? j - off : -1;
            }
            do {
                byte by;
                if (this.pos >= this.count) continue block0;
                if ((by = (b[j++] = buf[this.pos++])) != 10) continue;
                return j - off;
            } while (j != end);
            break;
        }
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        long r;
        long d;
        Assertions.assertPositive((long)n);
        byte[] buf = this.getBufIfOpen();
        for (r = n; r > 0L; r -= d) {
            if (this.pos >= this.count) {
                this.fill(buf);
            }
            if (this.pos >= this.count) break;
            d = this.count - this.pos;
            if (r <= d) {
                this.pos = (int)((long)this.pos + r);
                r = 0L;
                break;
            }
            this.pos = this.count;
        }
        return n - r;
    }

    @Override
    public int available() throws IOException {
        return this.count - this.pos + this.in.available();
    }

    @Override
    public boolean isReady() {
        return this.in != null && this.pos < this.count || this.in.isReady();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        Assertions.assertPositive((int)readlimit);
        this.readlimit = readlimit;
        this.markpos = this.pos;
    }

    @Override
    public void reset() throws IOException {
        if (this.markpos < 0) {
            throw new IOException(this.markpos == -2 ? "Mark invalid" : "Stream not marked");
        }
        this.pos = this.markpos;
    }

    @Override
    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        try {
            this.in.close();
        }
        finally {
            this.in = null;
            this.buf = null;
        }
    }
}

