/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.libj.lang.Assertions;

public class WrappedArrayList<E>
extends ArrayList<E> {
    public static final WrappedArrayList EMPTY_LIST = new WrappedArrayList<Object>(new Object[0]);
    protected final E[] elementData;
    private final int size;

    @SafeVarargs
    public WrappedArrayList(E ... objs) {
        this.elementData = Objects.requireNonNull(objs);
        this.size = objs.length;
    }

    @Override
    public int size() {
        return this.elementData.length;
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.elementData.clone();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size;
        if (a.length < size) {
            return Arrays.copyOf(this.elementData, size, a.getClass());
        }
        if (size > 0) {
            System.arraycopy(this.elementData, 0, a, 0, size);
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public E get(int index) {
        return this.elementData[index];
    }

    @Override
    public E set(int index, E element) {
        E oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int indexOf(Object o) {
        E[] a = this.elementData;
        if (o == null) {
            int i$ = a.length;
            for (int i = 0; i < i$; ++i) {
                if (a[i] != null) continue;
                return i;
            }
        } else {
            int i$ = a.length;
            for (int i = 0; i < i$; ++i) {
                if (!o.equals(a[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.elementData, 16);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        for (E e : this.elementData) {
            action.accept(e);
        }
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        E[] a = this.elementData;
        int i$ = a.length;
        for (int i = 0; i < i$; ++i) {
            a[i] = operator.apply(a[i]);
        }
    }

    @Override
    public void sort(Comparator<? super E> c) {
        Arrays.sort(this.elementData, c);
    }

    @Override
    public WrappedArrayList<E> clone() {
        return new WrappedArrayList<Object>((Object[])this.elementData.clone());
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof List && this.equalsRange((List)obj, 0, this.size);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.elementData);
    }

    @Override
    public String toString() {
        return Arrays.toString(this.elementData);
    }

    @Override
    public void trimToSize() {
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListItr(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        Assertions.assertRange("index", index, "size", this.size, true);
        return new ListItr(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "size", this.size);
        return new SubList(this, fromIndex, toIndex);
    }

    private int indexOfRange(Object o, int start, int end) {
        E[] es = this.elementData;
        if (o == null) {
            for (int i = start; i < end; ++i) {
                if (es[i] != null) continue;
                return i;
            }
        } else {
            for (int i = start; i < end; ++i) {
                if (!o.equals(es[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private int lastIndexOfRange(Object o, int start, int end) {
        E[] es = this.elementData;
        if (o == null) {
            for (int i = end - 1; i >= start; --i) {
                if (es[i] != null) continue;
                return i;
            }
        } else {
            for (int i = end - 1; i >= start; --i) {
                if (!o.equals(es[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean equalsRange(List<?> other, int from, int to) {
        int o$ = other.size();
        if (o$ == 0) {
            return from == to;
        }
        if (from == to) {
            return false;
        }
        E[] es = this.elementData;
        if (other instanceof RandomAccess) {
            int o = 0;
            do {
                if (o != o$ && Objects.equals(es[from], other.get(o++))) continue;
                return false;
            } while (++from < to);
            return o == o$;
        }
        Iterator<?> oit = other.iterator();
        do {
            if (oit.hasNext() && Objects.equals(es[from++], oit.next())) continue;
            return false;
        } while (oit.hasNext());
        return true;
    }

    private int hashCodeRange(int from, int to) {
        E[] es = this.elementData;
        int hashCode = 1;
        for (int i = from; i < to; ++i) {
            E e = es[i];
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    final class ArrayListSpliterator
    implements Spliterator<E> {
        private int index;
        private int fence;
        private int expectedModCount;

        private ArrayListSpliterator(int origin, int fence, int expectedModCount) {
            this.index = origin;
            this.fence = fence;
            this.expectedModCount = expectedModCount;
        }

        private int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                this.expectedModCount = WrappedArrayList.this.modCount;
                hi = this.fence = WrappedArrayList.this.size;
            }
            return hi;
        }

        public ArrayListSpliterator trySplit() {
            ArrayListSpliterator arrayListSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid) {
                arrayListSpliterator = null;
            } else {
                this.index = mid;
                ArrayListSpliterator arrayListSpliterator2 = new ArrayListSpliterator(lo, this.index, this.expectedModCount);
                arrayListSpliterator = arrayListSpliterator2;
            }
            return arrayListSpliterator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int i = this.index;
            int hi = this.getFence();
            if (i >= hi) {
                return false;
            }
            this.index = i + 1;
            action.accept(WrappedArrayList.this.elementData[i]);
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            int i;
            int mc;
            if (action == null) {
                throw new NullPointerException();
            }
            E[] a = WrappedArrayList.this.elementData;
            int hi = this.fence;
            if (hi < 0) {
                mc = WrappedArrayList.this.modCount;
                hi = WrappedArrayList.this.size;
            } else {
                mc = this.expectedModCount;
            }
            if (i >= 0 && (this.index = hi) <= a.length) {
                for (i = this.index; i < hi; ++i) {
                    action.accept(a[i]);
                }
                if (WrappedArrayList.this.modCount == mc) {
                    return;
                }
            }
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16464;
        }
    }

    private static class SubList<E>
    extends AbstractList<E>
    implements RandomAccess {
        private final WrappedArrayList<E> root;
        private final int offset;
        private int size;

        private SubList(WrappedArrayList<E> root, int fromIndex, int toIndex) {
            this.root = root;
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        private SubList(SubList<E> parent, int fromIndex, int toIndex) {
            this.root = parent.root;
            this.offset = parent.offset + fromIndex;
            this.size = toIndex - fromIndex;
            this.modCount = parent.modCount;
        }

        @Override
        public E set(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E get(int index) {
            Assertions.assertRange("index", index, "size", this.size);
            return this.root.elementData[this.offset + index];
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void add(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            return Arrays.copyOfRange(this.root.elementData, this.offset, this.offset + this.size);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.size;
            if (a.length < size) {
                return Arrays.copyOfRange(this.root.elementData, this.offset, this.offset + size, a.getClass());
            }
            System.arraycopy(this.root.elementData, this.offset, a, 0, size);
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }

        @Override
        public boolean equals(Object o) {
            return o == this || o instanceof List && ((WrappedArrayList)this.root).equalsRange((List)o, this.offset, this.offset + this.size);
        }

        @Override
        public int hashCode() {
            return ((WrappedArrayList)this.root).hashCodeRange(this.offset, this.offset + this.size);
        }

        @Override
        public int indexOf(Object o) {
            int index = ((WrappedArrayList)this.root).indexOfRange(o, this.offset, this.offset + this.size);
            return index >= 0 ? index - this.offset : -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            int index = ((WrappedArrayList)this.root).lastIndexOfRange(o, this.offset, this.offset + this.size);
            return index >= 0 ? index - this.offset : -1;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) >= 0;
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(final int index) {
            Assertions.assertRange("index", index, "size", this.size, true);
            return new ListIterator<E>(){
                int cursor;
                int lastRet;
                int expectedModCount;
                {
                    this.cursor = index;
                    this.lastRet = -1;
                    this.expectedModCount = modCount;
                }

                @Override
                public boolean hasNext() {
                    return this.cursor != size;
                }

                @Override
                public E next() {
                    int i = this.cursor;
                    if (i >= size) {
                        throw new NoSuchElementException();
                    }
                    E[] elementData = ((SubList)this).root.elementData;
                    this.cursor = i + 1;
                    this.lastRet = i;
                    return elementData[offset + this.lastRet];
                }

                @Override
                public boolean hasPrevious() {
                    return this.cursor != 0;
                }

                @Override
                public E previous() {
                    int i = this.cursor - 1;
                    if (i < 0) {
                        throw new NoSuchElementException();
                    }
                    E[] elementData = ((SubList)this).root.elementData;
                    this.cursor = i;
                    this.lastRet = i;
                    return elementData[offset + this.lastRet];
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    int i;
                    Objects.requireNonNull(action);
                    int size = size;
                    if (i < size) {
                        E[] es = ((SubList)this).root.elementData;
                        for (i = this.cursor; i < size && root.modCount == this.expectedModCount; ++i) {
                            action.accept(es[offset + i]);
                        }
                        this.cursor = i;
                        this.lastRet = i - 1;
                    }
                }

                @Override
                public int nextIndex() {
                    return this.cursor;
                }

                @Override
                public int previousIndex() {
                    return this.cursor - 1;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(E e) {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    root.set(offset + this.lastRet, e);
                }

                @Override
                public void add(E e) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "size", this.size);
            return new SubList<E>(this, fromIndex, toIndex);
        }

        @Override
        public Spliterator<E> spliterator() {
            return new Spliterator<E>(){
                private int index;
                private int fence;
                private int expectedModCount;
                {
                    this.index = offset;
                    this.fence = -1;
                }

                private int getFence() {
                    int hi = this.fence;
                    if (hi < 0) {
                        this.expectedModCount = modCount;
                        hi = this.fence = offset + size;
                    }
                    return hi;
                }

                public ArrayListSpliterator trySplit() {
                    ArrayListSpliterator arrayListSpliterator;
                    int lo = this.index;
                    int hi = this.getFence();
                    int mid = lo + hi >>> 1;
                    if (lo >= mid) {
                        arrayListSpliterator = null;
                    } else {
                        WrappedArrayList wrappedArrayList = root;
                        wrappedArrayList.getClass();
                        this.index = mid;
                        ArrayListSpliterator arrayListSpliterator2 = wrappedArrayList.new ArrayListSpliterator(lo, this.index, this.expectedModCount);
                        arrayListSpliterator = arrayListSpliterator2;
                    }
                    return arrayListSpliterator;
                }

                @Override
                public boolean tryAdvance(Consumer<? super E> action) {
                    Objects.requireNonNull(action);
                    int hi = this.getFence();
                    int i = this.index;
                    if (i < hi) {
                        this.index = i + 1;
                        action.accept(((SubList)this).root.elementData[i]);
                        return true;
                    }
                    return false;
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    int i;
                    int mc;
                    Objects.requireNonNull(action);
                    WrappedArrayList lst = root;
                    E[] a = lst.elementData;
                    int hi = this.fence;
                    if (hi < 0) {
                        mc = modCount;
                        hi = offset + size;
                    } else {
                        mc = this.expectedModCount;
                    }
                    if (i >= 0 && (this.index = hi) <= a.length) {
                        for (i = this.index; i < hi; ++i) {
                            action.accept(a[i]);
                        }
                        if (lst.modCount == mc) {
                            return;
                        }
                    }
                }

                @Override
                public long estimateSize() {
                    return this.getFence() - this.index;
                }

                @Override
                public int characteristics() {
                    return 16464;
                }
            };
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            int i = this.cursor - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            E[] elementData = WrappedArrayList.this.elementData;
            this.cursor = i;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            WrappedArrayList.this.set(this.lastRet, e);
        }

        @Override
        public void add(E e) {
            int i = this.cursor;
            WrappedArrayList.this.add(i, e);
            this.cursor = i + 1;
        }
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;

        Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != WrappedArrayList.this.size;
        }

        @Override
        public E next() {
            int i = this.cursor;
            if (i >= WrappedArrayList.this.size) {
                throw new NoSuchElementException();
            }
            E[] elementData = WrappedArrayList.this.elementData;
            this.cursor = i + 1;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            int i;
            Objects.requireNonNull(action);
            int size = WrappedArrayList.this.size;
            if (i < size) {
                E[] es = WrappedArrayList.this.elementData;
                for (i = this.cursor; i < size; ++i) {
                    action.accept(es[i]);
                }
                this.cursor = i;
                this.lastRet = i - 1;
            }
        }
    }
}

