/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.libj.lang.Assertions;

public final class Threads {
    private static final AtomicReference<ReaperThread> reaper = new AtomicReference();

    public static void printThreadTrace() {
        Threads.printThreadTrace(System.err);
    }

    public static void printThreadTrace(PrintWriter s) {
        Threads.printThreadTrace(s::println);
    }

    public static void printThreadTrace(PrintStream s) {
        Threads.printThreadTrace(s::println);
    }

    public static void printThreadTrace(Consumer<String> s) {
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        HashMap<Long, Thread> tidToThread = new HashMap<Long, Thread>(stackTraces.size());
        for (Thread thread : stackTraces.keySet()) {
            tidToThread.put(thread.getId(), thread);
        }
        StringBuilder builder = new StringBuilder();
        ThreadInfo[] threadInfos = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
        int i$ = threadInfos.length;
        for (int i = 0; i < i$; ++i) {
            ThreadInfo threadInfo;
            Thread thread;
            if (builder.length() > 0) {
                builder.append("\n\n");
            }
            if ((thread = (Thread)tidToThread.get((threadInfo = threadInfos[i]).getThreadId())) == null) continue;
            Threads.appendThreadTrace(builder, thread, threadInfo);
        }
        s.accept(builder.toString());
    }

    public static String toString(Thread thread) {
        ThreadInfo threadInfo = ManagementFactory.getThreadMXBean().getThreadInfo(thread.getId());
        StringBuilder builder = new StringBuilder();
        Threads.appendThreadTrace(builder, thread, threadInfo);
        return builder.toString();
    }

    private static void appendThreadTrace(StringBuilder builder, Thread thread, ThreadInfo threadInfo) {
        builder.append('\"').append(threadInfo.getThreadName()).append("\" #").append(threadInfo.getThreadId());
        if (thread.isDaemon()) {
            builder.append(" daemon");
        }
        builder.append(" prio=").append(thread.getPriority());
        builder.append("\n   java.lang.Thread.State: ").append((Object)threadInfo.getThreadState());
        for (StackTraceElement stackTraceElement : threadInfo.getStackTrace()) {
            builder.append("\n  at ").append(stackTraceElement);
        }
        builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        if (reaper.get() == null) {
            AtomicReference<ReaperThread> atomicReference = reaper;
            synchronized (atomicReference) {
                if (reaper.get() == null) {
                    reaper.set(new ReaperThread());
                }
            }
        }
    }

    public static Runnable interruptAfterTimeout(Runnable runnable, long timeout, TimeUnit unit) {
        Objects.requireNonNull(runnable);
        Assertions.assertNotNegative(timeout);
        Objects.requireNonNull(unit);
        Threads.init();
        return () -> {
            Threads.reaper.get().add(Thread.currentThread(), TimeUnit.MILLISECONDS.convert(timeout, unit) + System.currentTimeMillis());
            runnable.run();
        };
    }

    public static <V> Callable<V> interruptAfterTimeout(Callable<V> callable, long timeout, TimeUnit unit) {
        Objects.requireNonNull(callable);
        Assertions.assertNotNegative(timeout);
        Objects.requireNonNull(unit);
        Threads.init();
        return () -> {
            Threads.reaper.get().add(Thread.currentThread(), TimeUnit.MILLISECONDS.convert(timeout, unit) + System.currentTimeMillis());
            return callable.call();
        };
    }

    public static void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    private Threads() {
    }

    private static class ReaperThread
    extends Thread {
        private final PriorityBlockingQueue<Entry> queue = new PriorityBlockingQueue();

        private ReaperThread() {
            super("Threads.ReaperThread");
            try {
                this.setDaemon(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                this.setPriority(10);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(Thread thread, long expireTime) {
            this.queue.offer(new Entry(thread, expireTime));
            PriorityBlockingQueue<Entry> priorityBlockingQueue = this.queue;
            synchronized (priorityBlockingQueue) {
                this.queue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Entry entry;
                if ((entry = this.queue.poll()) == null) {
                    try {
                        PriorityBlockingQueue<Entry> priorityBlockingQueue = this.queue;
                        synchronized (priorityBlockingQueue) {
                            this.queue.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (entry.isExpired()) {
                    entry.thread.interrupt();
                    continue;
                }
                this.queue.offer(entry);
                try {
                    long timeout = System.currentTimeMillis() - entry.expireTime;
                    if (timeout <= 0L) continue;
                    ReaperThread reaperThread = this;
                    synchronized (reaperThread) {
                        this.wait(timeout);
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private static class Entry
        implements Comparable<Entry> {
            private static final AtomicLong entrySequence = new AtomicLong(Long.MIN_VALUE);
            private final long sequence = entrySequence.getAndIncrement();
            private final Thread thread;
            private final long expireTime;

            private Entry(Thread thread, long expireTime) {
                this.thread = thread;
                this.expireTime = expireTime;
            }

            private boolean isExpired() {
                return System.currentTimeMillis() >= this.expireTime;
            }

            @Override
            public int compareTo(Entry o) {
                int c = Long.compare(this.expireTime, o.expireTime);
                return c != 0 ? c : Long.compare(this.sequence, o.sequence);
            }
        }
    }
}

