/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.libj.lang.Assertions;
import org.libj.lang.Characters;

public final class Strings {
    public static final String[] EMPTY_ARRAY = new String[0];
    private static final char[] alphaNumeric = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final SecureRandom secureRandom = new SecureRandom();
    private static final ConcurrentHashMap<String, String> interns = new ConcurrentHashMap();
    private static final Pattern replacePattern = Pattern.compile("^/((([^/])|(\\\\/))+)/((([^/])|(\\\\/))+)/$");

    private static String getRandom(SecureRandom secureRandom, int length, int start, int len) {
        if (length == 0) {
            return "";
        }
        Assertions.assertNotNegative(length, () -> "Length must be non-negative: " + length);
        char[] array = new char[length];
        for (int i = 0; i < length; ++i) {
            array[i] = alphaNumeric[start + secureRandom.nextInt(len)];
        }
        return new String(array);
    }

    public static String getRandomAlphaNumeric(SecureRandom secureRandom, int len) {
        return Strings.getRandom(secureRandom, len, 0, alphaNumeric.length);
    }

    public static String getRandomAlphaNumeric(int len) {
        return Strings.getRandom(secureRandom, len, 0, alphaNumeric.length);
    }

    public static String getRandomAlpha(SecureRandom secureRandom, int len) {
        return Strings.getRandom(secureRandom, len, 0, alphaNumeric.length - 10);
    }

    public static String getRandomAlpha(int len) {
        return Strings.getRandom(secureRandom, len, 0, alphaNumeric.length - 10);
    }

    public static String getRandomNumeric(SecureRandom secureRandom, int len) {
        return Strings.getRandom(secureRandom, len, alphaNumeric.length - 10, 10);
    }

    public static String getRandomNumeric(int len) {
        return Strings.getRandom(secureRandom, len, alphaNumeric.length - 10, 10);
    }

    private static boolean interpolateShallow(StringBuilder text, Map<String, String> properties, String open, String close) {
        boolean changed = false;
        int openLen = open.length();
        int closeLen = close.length();
        int start = text.length() - closeLen - 1;
        while ((start = text.lastIndexOf(open, start - 1)) > -1) {
            String key;
            String value;
            int end = text.indexOf(close, start + openLen);
            if (end < start || (value = properties.get(key = text.substring(start + openLen, end))) == null) continue;
            text.replace(start, end + closeLen, value);
            changed = true;
        }
        return changed;
    }

    private static String interpolateDeep(StringBuilder text, Map<String, String> properties, String prefix, String suffix) {
        int max = properties.size() * properties.size();
        int i = 0;
        while (Strings.interpolateShallow(text, properties, prefix, suffix)) {
            if (i == max) {
                throw new IllegalArgumentException("Loop detected");
            }
            ++i;
        }
        return text.toString();
    }

    public static Map<String, String> interpolate(Map<String, String> properties, String prefix, String suffix) {
        StringBuilder b = null;
        if (properties.size() > 0) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String value = entry.getValue();
                if (value == null) continue;
                if (b == null) {
                    b = new StringBuilder(value.length());
                } else {
                    b.setLength(0);
                }
                b.append(value);
                entry.setValue(Strings.interpolateDeep(b, properties, prefix, suffix));
            }
        }
        return properties;
    }

    public static String interpolate(String text, Map<String, String> properties, String prefix, String suffix) {
        return Strings.interpolateDeep(new StringBuilder(text), properties, prefix, suffix);
    }

    public static boolean replace(StringBuilder builder, char target, char replacement) {
        boolean changed = false;
        int i = 0;
        while ((i = Strings.indexOf((CharSequence)builder, target, i)) > -1) {
            builder.setCharAt(i, replacement);
            changed = true;
        }
        return changed;
    }

    public static boolean replace(StringBuilder builder, CharSequence target, CharSequence replacement) {
        String targetString = target.toString();
        String replaceString = replacement.toString();
        int j = builder.lastIndexOf(targetString);
        if (j < 0) {
            return false;
        }
        int targetLen = targetString.length();
        int targetLen1 = Math.max(targetLen, 1);
        int newLengthHint = builder.length() - targetLen + replaceString.length();
        if (newLengthHint < 0) {
            throw new OutOfMemoryError();
        }
        do {
            builder.replace(j, j + targetLen1, replaceString);
        } while ((j = builder.lastIndexOf(targetString, j - targetLen1)) > -1);
        return true;
    }

    public static boolean replaceAll(StringBuilder builder, CharSequence target, CharSequence replacement) {
        int i = 0;
        while (Strings.replace(builder, target, replacement)) {
            ++i;
        }
        return i > 0;
    }

    public static boolean startsWith(CharSequence str, CharSequence prefix) {
        int len = prefix.length();
        if (len == 0) {
            return true;
        }
        if (str.length() < len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(CharSequence str, CharSequence prefix) {
        int len = prefix.length();
        if (len == 0) {
            return true;
        }
        if (str.length() < len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char a = str.charAt(i);
            char b = prefix.charAt(i);
            if (Character.toUpperCase(a) == Character.toUpperCase(b) || Character.toLowerCase(a) == Character.toLowerCase(b)) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(CharSequence str, char prefix) {
        return str.length() > 0 && str.charAt(0) == prefix;
    }

    public static boolean startsWithIgnoreCase(CharSequence str, char prefix) {
        char ch;
        return str.length() > 0 && (Character.toUpperCase(ch = str.charAt(0)) == Character.toUpperCase(prefix) || Character.toLowerCase(ch) == Character.toLowerCase(prefix));
    }

    public static boolean endsWith(CharSequence str, CharSequence suffix) {
        int len = suffix.length();
        if (len == 0) {
            return true;
        }
        if (str.length() < len) {
            return false;
        }
        int offset = str.length() - len;
        for (int i = len - 1; i >= 0; --i) {
            if (str.charAt(offset + i) == suffix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWithIgnoreCase(CharSequence str, CharSequence suffix) {
        int len = suffix.length();
        if (len == 0) {
            return true;
        }
        if (str.length() < len) {
            return false;
        }
        int offset = str.length() - len;
        for (int i = len - 1; i >= 0; --i) {
            char a = str.charAt(offset + i);
            char b = suffix.charAt(i);
            if (Character.toUpperCase(a) == Character.toUpperCase(b) || Character.toLowerCase(a) == Character.toLowerCase(b)) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(CharSequence str, char suffix) {
        int len = str.length();
        return len > 0 && str.charAt(len - 1) == suffix;
    }

    public static boolean endsWithIgnoreCase(CharSequence str, char suffix) {
        char ch;
        int len = str.length();
        return len > 0 && (Character.toUpperCase(ch = str.charAt(len - 1)) == Character.toUpperCase(suffix) || Character.toLowerCase(ch) == Character.toLowerCase(suffix));
    }

    public static StringBuilder toProperCase(StringBuilder builder) {
        boolean nextUpper = true;
        int i$ = builder.length();
        for (int i = 0; i < i$; ++i) {
            char ch = builder.charAt(i);
            if (Character.isWhitespace(ch)) {
                nextUpper = true;
                continue;
            }
            builder.setCharAt(i, nextUpper ? Character.toUpperCase(ch) : Character.toLowerCase(ch));
            nextUpper = false;
        }
        return builder;
    }

    public static StringBuilder toProperCase(String str) {
        return Strings.toProperCase(new StringBuilder(str));
    }

    public static StringBuilder toLowerCase(StringBuilder builder) {
        int i$ = builder.length();
        for (int i = 0; i < i$; ++i) {
            builder.setCharAt(i, Character.toLowerCase(builder.charAt(i)));
        }
        return builder;
    }

    public static StringBuilder toUpperCase(StringBuilder builder) {
        int i$ = builder.length();
        for (int i = 0; i < i$; ++i) {
            builder.setCharAt(i, Character.toUpperCase(builder.charAt(i)));
        }
        return builder;
    }

    private static StringBuilder changeCase(StringBuilder builder, boolean upper, int beginIndex, int endIndex) {
        int length = builder.length();
        if (length == 0) {
            return builder;
        }
        if (beginIndex < 0) {
            throw new IllegalArgumentException("start index (" + beginIndex + ") must be non-negative");
        }
        if (endIndex < beginIndex) {
            throw new IllegalArgumentException("start index (" + beginIndex + ") > end index (" + endIndex + ")");
        }
        if (length < beginIndex) {
            throw new IllegalArgumentException("start index (" + beginIndex + ") > string length (" + length + ")");
        }
        if (beginIndex == endIndex) {
            return builder;
        }
        for (int i = beginIndex; i < endIndex; ++i) {
            builder.setCharAt(i, upper ? Character.toUpperCase(builder.charAt(i)) : Character.toLowerCase(builder.charAt(i)));
        }
        return builder;
    }

    public static StringBuilder toLowerCase(StringBuilder builder, int beginIndex, int endIndex) {
        return Strings.changeCase(builder, false, beginIndex, endIndex);
    }

    public static StringBuilder toLowerCase(StringBuilder builder, int beginIndex) {
        return Strings.changeCase(builder, false, beginIndex, builder.length());
    }

    public static StringBuilder toUpperCase(StringBuilder builder, int beginIndex, int endIndex) {
        return Strings.changeCase(builder, true, beginIndex, endIndex);
    }

    public static StringBuilder toUpperCase(StringBuilder builder, int beginIndex) {
        return Strings.changeCase(builder, true, beginIndex, builder.length());
    }

    public static String pad(String str, Align align, int length) {
        return Strings.pad(str, align, length, ' ', false);
    }

    public static String padAll(String str, Align align, int length) {
        return Strings.padAll(str, align, length, ' ', false);
    }

    public static String pad(String str, Align align, int length, boolean truncate) {
        return Strings.pad(str, align, length, ' ', truncate);
    }

    public static String padAll(String str, Align align, int length, boolean truncate) {
        return Strings.padAll(str, align, length, ' ', truncate);
    }

    public static String pad(String str, Align align, int length, char pad) {
        return Strings.pad(str, align, length, pad, false);
    }

    public static String padAll(String str, Align align, int length, char pad) {
        return Strings.padAll(str, align, length, pad, false);
    }

    public static String pad(String str, Align align, int length, char pad, boolean truncate) {
        int lenPrint = Strings.lengthPrintable(str);
        if (length == lenPrint) {
            return str;
        }
        if (length >= lenPrint) {
            int len = str.length();
            char[] chars = new char[length + len - lenPrint];
            align.pad(chars, str, len, pad);
            return new String(chars);
        }
        if (truncate) {
            return align == Align.LEFT ? str.substring(0, Strings.indexPrintable(str, length)) : str.substring(Strings.indexPrintable(str, str.length() - length));
        }
        throw new IllegalArgumentException("length (" + length + ") must be greater or equal to printable string length (" + lenPrint + ")");
    }

    public static String padAll(String str, Align align, int length, char pad, boolean truncate) {
        StringBuilder b = new StringBuilder();
        String[] lines = str.split("[\n\r]");
        int i$ = lines.length;
        for (int i = 0; i < i$; ++i) {
            if (i > 0) {
                b.append('\n');
            }
            b.append(Strings.pad(lines[i], align, length, pad, truncate));
        }
        return b.toString();
    }

    public static int lengthPrintable(CharSequence str) {
        return Strings.countPrintable(str, -1);
    }

    public static int indexPrintable(CharSequence str, int index) {
        return Strings.countPrintable(str, index);
    }

    private static int countPrintable(CharSequence str, int index) {
        int i;
        int i$ = str.length();
        int start = 0;
        int last = 0;
        boolean esc = false;
        for (i = 0; i < i$; ++i) {
            char ch = str.charAt(i);
            if (esc) {
                esc = ch != 'm';
            } else {
                esc = ch == '[' && last == 27;
                if (!esc && Characters.isPrintable(ch) && start++ == index) break;
            }
            last = ch;
        }
        return index == -1 ? start : i;
    }

    static String hex(long value, int digits) {
        String hex;
        boolean negative;
        boolean bl = negative = value < 0L;
        if (negative) {
            value = -value;
        }
        if ((hex = Long.toString(value & (1L << 4 * digits) - 1L, 16)).length() < digits) {
            hex = Strings.pad(hex, Align.RIGHT, digits, '0');
        }
        return negative ? "-" + hex : hex;
    }

    public static String toUTF8Literal(char ch) {
        return "\\x" + Strings.hex(ch, 2);
    }

    public static String toUTF8Literal(CharSequence str) {
        int length = str.length();
        StringBuilder b = new StringBuilder(length * 4);
        for (int i = 0; i < length; ++i) {
            b.append(Strings.toUTF8Literal(str.charAt(i)));
        }
        return b.toString();
    }

    public static String getAlpha(int n) {
        String string;
        if (n < 26) {
            string = String.valueOf((char)(97 + n));
        } else {
            int scale = n / 26;
            string = Strings.getAlpha(scale - 1) + (char)(97 + n - scale * 26);
        }
        return string;
    }

    public static String getCommonPrefix(String ... strings) {
        int len;
        if (strings == null || (len = strings.length) == 0) {
            return null;
        }
        if (len == 1) {
            return strings[0];
        }
        String string0 = strings[0];
        int i$ = string0.length();
        for (int i = 0; i < i$; ++i) {
            int j$ = len;
            for (int j = 1; j < j$; ++j) {
                if (i != strings[j].length() && string0.charAt(i) == strings[j].charAt(i)) continue;
                return string0.substring(0, i);
            }
        }
        return string0;
    }

    public static String getCommonPrefix(Collection<String> strings) {
        int len;
        if (strings == null || (len = strings.size()) == 0) {
            return null;
        }
        Iterator<String> iterator = strings.iterator();
        if (len == 1) {
            return iterator.next();
        }
        String string0 = iterator.next();
        int i$ = string0.length();
        for (int i = 0; i < i$; ++i) {
            if (i > 0) {
                iterator = strings.iterator();
                iterator.next();
            }
            while (iterator.hasNext()) {
                String next = iterator.next();
                if (i != next.length() && string0.charAt(i) == next.charAt(i)) continue;
                return string0.substring(0, i);
            }
        }
        return string0;
    }

    public static String escapeForJava(String str) {
        return str == null ? null : str.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    public static String repeat(char ch, int count) {
        Assertions.assertNotNegative(count, () -> "count (" + count + ") must be greater than or equal to 0");
        if (count == 0) {
            return "";
        }
        char[] chars = new char[count];
        Arrays.fill(chars, ch);
        return new String(chars);
    }

    public static String repeat(String str, int count) {
        int n;
        Assertions.assertNotNegative(count, () -> "count (" + count + ") must be greater than or equal to 0");
        int length = str.length();
        if (count == 0 || length == 0) {
            return "";
        }
        if (count == 1) {
            return str;
        }
        long longSize = (long)length * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required array size too large: " + longSize);
        }
        char[] chars = new char[size];
        str.getChars(0, length, chars, 0);
        for (n = length; n < size - n; n <<= 1) {
            System.arraycopy(chars, 0, chars, n, n);
        }
        System.arraycopy(chars, 0, chars, n, size - n);
        return new String(chars);
    }

    public static byte[] getBytes(String str, String charsetName) {
        try {
            return str.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String trim(String str, char ch) {
        if (str == null) {
            return null;
        }
        int i = -1;
        int length = str.length();
        while (++i < length && str.charAt(i) == ch) {
        }
        if (i == length) {
            return "";
        }
        int j = length;
        while (j > i && str.charAt(--j) == ch) {
        }
        return i == 0 && j == length - 1 ? str : str.substring(i, j + 1);
    }

    public static String trimStartEnd(String str, char start, char end) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length > 1 && str.charAt(0) == start && str.charAt(length - 1) == end) {
            return str.substring(1, length - 1);
        }
        return str;
    }

    public static int lastIndexOf(CharSequence str, char ch) {
        return Strings.lastIndexOf0(str, ch, str.length() - 1);
    }

    public static int lastIndexOf(CharSequence str, char ch, int fromIndex) {
        return Strings.lastIndexOf0(str, ch, fromIndex);
    }

    private static int lastIndexOf0(CharSequence str, char ch, int fromIndex) {
        for (int i = Math.min(fromIndex, str.length() - 1); i >= 0; --i) {
            if (str.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence str, CharSequence substr) {
        return Strings.lastIndexOf0(str, substr, str.length() - 1);
    }

    public static int lastIndexOf(CharSequence str, CharSequence substr, int fromIndex) {
        return Strings.lastIndexOf0(str, substr, fromIndex);
    }

    private static int lastIndexOf0(CharSequence str, CharSequence substr, int fromIndex) {
        int substrLen = substr.length();
        for (int i = Math.min(fromIndex, str.length() - 1); i >= 0; --i) {
            if (!Strings.regionMatches0(str, false, i, substr, 0, substrLen)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfUnEscaped(CharSequence str, char ch, int fromIndex) {
        boolean escaped = false;
        int i$ = str.length();
        for (int i = Math.max(fromIndex, 0); i < i$; ++i) {
            char c = str.charAt(i);
            if (escaped) {
                if (c == '\\' && ch == '\\') {
                    return i;
                }
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c != ch) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfUnEscaped(CharSequence str, char ch) {
        return Strings.indexOfUnEscaped(str, ch, 0);
    }

    public static int indexOfUnEscaped(CharSequence str, CharSequence substr, int fromIndex) {
        int substrLen = substr.length();
        boolean substrIsBackslash = substrLen == 1 && substr.charAt(0) == '\\';
        boolean escaped = false;
        int i$ = str.length();
        for (int i = Math.max(fromIndex, 0); i < i$; ++i) {
            char c = str.charAt(i);
            if (escaped) {
                if (c == '\\' && substrIsBackslash) {
                    return i;
                }
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (!Strings.regionMatches0(str, false, i, substr, 0, substrLen)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfUnEscaped(CharSequence str, CharSequence substr) {
        return Strings.indexOfUnEscaped(str, substr, 0);
    }

    public static int lastIndexOfUnEscaped(CharSequence str, char ch, int fromIndex) {
        int i;
        do {
            i = Strings.lastIndexOf(str, ch, fromIndex);
            int count = 0;
            for (int j = i - 1; j >= 0 && str.charAt(j) == '\\'; --j) {
                ++count;
            }
            if (count % 2 != 0) continue;
            return i;
        } while ((fromIndex = i - 1) > 0);
        return -1;
    }

    public static int lastIndexOfUnEscaped(CharSequence str, char ch) {
        return Strings.lastIndexOfUnEscaped(str, ch, str.length() - 1);
    }

    public static int lastIndexOfUnEscaped(CharSequence str, CharSequence substr, int fromIndex) {
        int i;
        do {
            i = Strings.lastIndexOf(str, substr, fromIndex);
            int count = 0;
            for (int j = i - 1; j >= 0 && str.charAt(j) == '\\'; --j) {
                ++count;
            }
            if (count % 2 != 0) continue;
            return i;
        } while ((fromIndex = i - 1) > 0);
        return -1;
    }

    public static int lastIndexOfUnEscaped(CharSequence str, CharSequence substr) {
        return Strings.lastIndexOfUnEscaped(str, substr, str.length() - 1);
    }

    public static int indexOfUnQuoted(CharSequence str, char ch, int fromIndex) {
        boolean escaped = false;
        boolean quoted = false;
        int i$ = str.length();
        for (int i = Math.max(fromIndex, 0); i < i$; ++i) {
            char c = str.charAt(i);
            if (escaped) {
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == ch && !quoted) {
                return i;
            }
            if (c != '\"') continue;
            quoted = !quoted;
        }
        return -1;
    }

    public static int indexOfUnQuoted(CharSequence str, char ch) {
        return Strings.indexOfUnQuoted(str, ch, 0);
    }

    public static int indexOfUnQuoted(CharSequence str, CharSequence substr, int fromIndex) {
        int substrLen = substr.length();
        boolean escaped = false;
        boolean quoted = false;
        int i$ = str.length();
        for (int i = Math.max(fromIndex, 0); i < i$; ++i) {
            char c = str.charAt(i);
            if (escaped) {
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (!quoted && Strings.regionMatches0(str, false, i, substr, 0, substrLen)) {
                return i;
            }
            if (c != '\"') continue;
            quoted = !quoted;
        }
        return -1;
    }

    public static int indexOfUnQuoted(CharSequence str, CharSequence substr) {
        return Strings.indexOfUnQuoted(str, substr, 0);
    }

    public static int lastIndexOfUnQuoted(CharSequence str, char ch, int fromIndex) {
        boolean esacped = false;
        boolean quoted = false;
        char n = '\u0000';
        int end = str.length() - 1;
        for (int i = Math.min(fromIndex, end); i >= 0; --i) {
            char c = str.charAt(i);
            if (c == '\\') {
                esacped = true;
            } else if (esacped) {
                esacped = false;
            } else {
                if (n == ch && !quoted) {
                    return i + 1;
                }
                if (n == '\"') {
                    quoted = !quoted;
                }
            }
            n = c;
        }
        return n == ch ? 0 : -1;
    }

    public static int lastIndexOfUnQuoted(CharSequence str, char ch) {
        return Strings.lastIndexOfUnQuoted(str, ch, str.length());
    }

    public static int lastIndexOfUnQuoted(CharSequence str, CharSequence substr, int fromIndex) {
        int substrLen = substr.length();
        boolean esacped = false;
        boolean quoted = false;
        char n = '\u0000';
        int end = str.length() - 1;
        for (int i = Math.min(fromIndex, end); i >= 0; --i) {
            char c = str.charAt(i);
            if (c == '\\') {
                esacped = true;
            } else if (esacped) {
                esacped = false;
            } else {
                if (!quoted && Strings.regionMatches0(str, false, i, substr, 0, substrLen)) {
                    return i + 1;
                }
                if (n == '\"') {
                    quoted = !quoted;
                }
            }
            n = c;
        }
        return substrLen == 1 && substr.charAt(0) == n ? 0 : -1;
    }

    public static int lastIndexOfUnQuoted(CharSequence str, CharSequence substr) {
        return Strings.lastIndexOfUnQuoted(str, substr, str.length());
    }

    public static int indexOfUnEnclosed(CharSequence str, char ch, char open, char close, int fromIndex) {
        boolean escaped = false;
        boolean enclosed = false;
        int i$ = str.length();
        for (int i = Math.max(fromIndex, 0); i < i$; ++i) {
            char c = str.charAt(i);
            if (escaped) {
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (enclosed) {
                enclosed = c != close;
                continue;
            }
            if (c == ch) {
                return i;
            }
            enclosed = c == open;
        }
        return -1;
    }

    public static int indexOfUnEnclosed(CharSequence str, char ch, char open, char close) {
        return Strings.indexOfUnEnclosed(str, ch, open, close, 0);
    }

    public static int indexOfUnEnclosed(CharSequence str, CharSequence substr, char open, char close, int fromIndex) {
        boolean escaped = false;
        boolean enclosed = false;
        int substrLen = substr.length();
        int i$ = str.length();
        for (int i = Math.max(fromIndex, 0); i < i$; ++i) {
            char c = str.charAt(i);
            if (escaped) {
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (enclosed) {
                enclosed = c != close;
                continue;
            }
            if (Strings.regionMatches0(str, false, i, substr, 0, substrLen)) {
                return i;
            }
            enclosed = c == open;
        }
        return -1;
    }

    public static int indexOfUnEnclosed(CharSequence str, CharSequence substr, char open, char close) {
        return Strings.indexOfUnEnclosed(str, substr, open, close, 0);
    }

    public static int indexOfScopeClose(CharSequence str, char open, char close, int fromIndex) {
        boolean escaped = false;
        int i$ = str.length();
        int scope = 1;
        for (int i = Math.max(fromIndex, 0); i < i$; ++i) {
            char c = str.charAt(i);
            if (escaped) {
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == open) {
                ++scope;
                continue;
            }
            if (c != close || --scope != 0) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfScopeClose(CharSequence str, char open, char close) {
        return Strings.indexOfScopeClose(str, open, close, 0);
    }

    public static String truncate(String str, int maxLength) {
        return Strings.truncate(str, maxLength, true);
    }

    public static String truncate(String str, int maxLength, boolean withEllipsis) {
        if (str == null) {
            str = "null";
        }
        if (!withEllipsis) {
            return str.length() <= maxLength ? str : str.substring(0, maxLength);
        }
        if (maxLength < 3) {
            throw new IllegalArgumentException("length (" + maxLength + ") must be >= 3 for ellipses (\"...\")");
        }
        return maxLength == 3 ? "..." : (str.length() > maxLength ? str.substring(0, maxLength - 3).concat("...") : str);
    }

    public static String flipFirstCap(String str) {
        int length = str.length();
        if (length == 0) {
            return str;
        }
        boolean hasLower = false;
        boolean hasUpper = false;
        for (int i = 1; i < length; ++i) {
            hasLower = hasLower || Character.isLowerCase(str.charAt(i));
            boolean bl = hasUpper = hasUpper || Character.isUpperCase(str.charAt(i));
            if (hasLower && hasUpper) break;
        }
        if (hasUpper && !hasLower) {
            return str;
        }
        char ch = str.charAt(0);
        return (Character.isLowerCase(ch) ? Character.toUpperCase(ch) : Character.toLowerCase(ch)) + str.substring(1);
    }

    private static void appendElVar(StringBuilder b, StringBuilder v, Map vs) {
        String name = v.toString();
        Object value = vs.get(name);
        if (value != null) {
            b.append(value);
        } else {
            b.append('$').append('{').append(name).append('}');
        }
        v.setLength(0);
    }

    private static void appendElNoMatch(StringBuilder b, StringBuilder v, char close) {
        b.append('$').append('{');
        if (v.length() > 0) {
            b.append((CharSequence)v);
            v.setLength(0);
        }
        if (close != '\u0000') {
            b.append(close);
        }
    }

    public static String derefEL(String s, Properties vars) {
        return Strings.derefEL(vars, s);
    }

    public static String derefEL(String s, Map<String, String> nameToValue) {
        return Strings.derefEL(nameToValue, s);
    }

    private static String derefEL(Map vs, String s) {
        if (s.length() < 4) {
            return s;
        }
        StringBuilder b = new StringBuilder();
        StringBuilder v = new StringBuilder();
        boolean escape = false;
        int i$ = s.length();
        for (int i = 0; i < i$; ++i) {
            char ch = s.charAt(i);
            if (ch == '\\') {
                if (v.length() > 0) {
                    b.append('$').append('{').append((CharSequence)v);
                    v.setLength(0);
                }
                if (escape = !escape) continue;
                b.append(ch);
                continue;
            }
            if (!escape) {
                if (ch == '$') {
                    if (v.length() > 0) {
                        Strings.appendElVar(b, v, vs);
                    }
                    if (++i == i$) {
                        b.append('$');
                        continue;
                    }
                    ch = s.charAt(i);
                    if (ch != '{') {
                        v.setLength(0);
                        b.append('$');
                        if (ch == '\\') continue;
                        b.append(ch);
                        continue;
                    }
                    if (++i == i$) {
                        Strings.appendElNoMatch(b, v, '\u0000');
                        continue;
                    }
                    ch = s.charAt(i);
                    if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || ch == '_' || ch == '.') {
                        v.append(ch);
                        continue;
                    }
                    Strings.appendElNoMatch(b, v, ch);
                    continue;
                }
                if (v.length() > 0) {
                    if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || ch == '_' || ch == '.') {
                        v.append(ch);
                        continue;
                    }
                    if (ch != '}') {
                        Strings.appendElNoMatch(b, v, ch);
                        continue;
                    }
                    Strings.appendElVar(b, v, vs);
                    if (ch == '}') continue;
                    b.append(ch);
                    continue;
                }
                b.append(ch);
                continue;
            }
            if (v.length() > 0) {
                Strings.appendElVar(b, v, vs);
            }
            b.append(ch);
            escape = false;
        }
        if (v.length() > 0) {
            Strings.appendElNoMatch(b, v, '\u0000');
        }
        return b.toString();
    }

    private static void appendEvVar(StringBuilder builder, StringBuilder v, Map<String, String> vs) {
        String variable = vs.get(v.toString());
        if (variable != null) {
            builder.append(variable);
        }
        v.setLength(0);
    }

    public static String derefEV(String s, Map<String, String> vs) throws ParseException {
        if (s.length() < 2) {
            return s;
        }
        StringBuilder b = new StringBuilder();
        StringBuilder v = new StringBuilder();
        boolean escape = false;
        boolean bracket = false;
        int i$ = s.length();
        for (int i = 0; i < i$; ++i) {
            char ch = s.charAt(i);
            if (ch == '\\') {
                if (v.length() > 0) {
                    Strings.appendEvVar(b, v, vs);
                }
                if (escape = !escape) continue;
                b.append(ch);
                continue;
            }
            if (!escape) {
                if (ch == '$') {
                    if (v.length() > 0) {
                        Strings.appendEvVar(b, v, vs);
                    }
                    if (++i == i$) {
                        b.append('$');
                        continue;
                    }
                    ch = s.charAt(i);
                    if (ch == '$') {
                        throw new ParseException("$$: not supported", i);
                    }
                    if (ch == '{') {
                        bracket = true;
                        if (++i == i$) {
                            throw new ParseException("${: bad substitution", i);
                        }
                        ch = s.charAt(i);
                    }
                    if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || ch == '_') {
                        v.append(ch);
                        continue;
                    }
                    if (!bracket) {
                        b.append('$');
                        if (ch == '\\') continue;
                        b.append(ch);
                        continue;
                    }
                    throw new ParseException("${" + ch + ": bad substitution", i);
                }
                if (v.length() > 0) {
                    if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || ch == '_') {
                        v.append(ch);
                        continue;
                    }
                    if (bracket && ch != '}') {
                        throw new ParseException("${" + v + ch + ": bad substitution", i);
                    }
                    Strings.appendEvVar(b, v, vs);
                    if (bracket && ch == '}') continue;
                    b.append(ch);
                    continue;
                }
                b.append(ch);
                continue;
            }
            if (v.length() > 0) {
                Strings.appendEvVar(b, v, vs);
            }
            b.append(ch);
            escape = false;
        }
        if (v.length() > 0) {
            if (bracket) {
                throw new ParseException("${" + v + ": bad substitution", i$);
            }
            Strings.appendEvVar(b, v, vs);
        }
        return b.toString();
    }

    public static boolean isWhitespace(CharSequence str) {
        int i$ = str.length();
        for (int i = 0; i < i$; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasWhitespace(CharSequence str) {
        int i$ = str.length();
        for (int i = 0; i < i$; ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isLowerCase(CharSequence str) {
        int length = str.length();
        Assertions.assertPositive(length, "Empty");
        for (int i = 0; i < length; ++i) {
            if (Character.isLowerCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperCase(CharSequence str) {
        int length = str.length();
        Assertions.assertPositive(length, "Empty");
        for (int i = 0; i < length; ++i) {
            if (Character.isUpperCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static long hash(CharSequence str) {
        if (str == null) {
            return 0L;
        }
        long hash = 0L;
        int i$ = str.length();
        for (int i = 0; i < i$; ++i) {
            hash = 31L * hash + (long)str.charAt(i);
        }
        return hash;
    }

    public static StringBuilder indent(String str, int spaces) {
        return Strings.indent(new StringBuilder(str), spaces);
    }

    public static StringBuilder indent(StringBuilder str, int spaces) {
        if (spaces == 0) {
            return str;
        }
        String indent = Strings.repeat(' ', spaces);
        Strings.replace(str, "\n\n", "\u0007\n");
        int i = str.length();
        while (i > 0 && (i = Strings.lastIndexOf((CharSequence)str, '\n', i - 1)) > -1) {
            str.insert(i + 1, indent);
        }
        Strings.replace(str, '\u0007', '\n');
        return str;
    }

    public static boolean regionMatches(CharSequence str, boolean ignoreCase, int strOffset, CharSequence substr, int substrOffset, int len) {
        return Strings.regionMatches0(str, ignoreCase, strOffset, substr, substrOffset, len);
    }

    private static boolean regionMatches0(CharSequence str, boolean ignoreCase, int strOffset, CharSequence substr, int substrOffset, int len) {
        if (str instanceof String && substr instanceof String) {
            return ((String)str).regionMatches(ignoreCase, strOffset, (String)substr, substrOffset, len);
        }
        if (substrOffset < 0 || strOffset < 0 || (long)strOffset > (long)str.length() - (long)len || (long)substrOffset > (long)substr.length() - (long)len) {
            return false;
        }
        int i1 = strOffset;
        int i2 = substrOffset;
        while (len-- > 0) {
            char c2;
            char c1 = str.charAt(i1);
            if (c1 != (c2 = substr.charAt(i2))) {
                if (!ignoreCase) {
                    return false;
                }
                if (Character.toUpperCase(c1) != Character.toUpperCase(c2) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i1;
            ++i2;
        }
        return true;
    }

    public static int indexOf(CharSequence str, char ch) {
        return Strings.indexOf(str, ch, 0);
    }

    public static int indexOf(CharSequence str, char ch, int fromIndex) {
        int length;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex > (length = str.length())) {
            return -1;
        }
        for (int i = fromIndex; i < length; ++i) {
            if (str.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(CharSequence str, CharSequence substr) {
        return Strings.indexOf(str, substr, 0);
    }

    public static int indexOf(CharSequence str, CharSequence substr, int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int subStrLength = substr.length();
        int i$ = str.length() - subStrLength + 1;
        if (fromIndex > i$) {
            return -1;
        }
        if (subStrLength == 0) {
            return fromIndex;
        }
        for (int i = fromIndex; i < i$; ++i) {
            if (!Strings.regionMatches0(str, false, i, substr, 0, subStrLength)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence str, char ch) {
        return Strings.indexOfIgnoreCase(str, ch, 0);
    }

    public static int indexOfIgnoreCase(CharSequence str, char ch, int fromIndex) {
        char lCh;
        char uCh;
        int length;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex > (length = str.length())) {
            return -1;
        }
        if (Character.isUpperCase(ch)) {
            uCh = ch;
            lCh = Character.toLowerCase(ch);
        } else {
            uCh = Character.toUpperCase(ch);
            lCh = ch;
        }
        for (int i = fromIndex; i < length; ++i) {
            ch = str.charAt(i);
            if (ch != uCh && ch != lCh) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence substr) {
        return Strings.indexOfIgnoreCase(str, substr, 0);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence substr, int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int subStrLength = substr.length();
        int i$ = str.length() - subStrLength + 1;
        if (fromIndex > i$) {
            return -1;
        }
        if (subStrLength == 0) {
            return fromIndex;
        }
        for (int i = fromIndex; i < i$; ++i) {
            if (!Strings.regionMatches0(str, true, i, substr, 0, subStrLength)) continue;
            return i;
        }
        return -1;
    }

    public static boolean containsIgnoreCase(CharSequence str, char ch) {
        return Strings.indexOfIgnoreCase(str, ch) > -1;
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence substr) {
        return Strings.indexOfIgnoreCase(str, substr) > -1;
    }

    public static UUID toUuidOrNull(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() != 36) {
            return null;
        }
        for (int i = 0; i < 36; ++i) {
            char ch = str.charAt(i);
            if (!(i == 8 || i == 13 || i == 18 || i == 23 ? ch != '-' : !('0' <= ch && ch <= '9' || 'a' <= ch && ch <= 'f' || 'A' <= ch && ch <= 'F'))) continue;
            return null;
        }
        return UUID.fromString(str);
    }

    public static String intern(String str) {
        if (str == null) {
            return null;
        }
        String intern = interns.putIfAbsent(str, str);
        return intern != null ? intern : str;
    }

    private static String[] split(CharSequence s, int i$, char ch, int empties, StringBuilder b, int index, int depth) {
        String[] parts;
        char c = s.charAt(index);
        if (c != ch) {
            b.append(c);
            if (++index == i$) {
                if (index != i$ || b.length() > 0) {
                    String part = b.toString();
                    parts = new String[depth + 1];
                    parts[depth] = part;
                } else {
                    parts = new String[depth - empties];
                }
            } else {
                parts = Strings.split(s, i$, ch, empties, b, index, depth);
            }
        } else if (++index != i$ || b.length() > 0) {
            String part = b.toString();
            parts = index == i$ ? new String[depth + 1] : Strings.split(s, i$, ch, part.length() == 0 ? empties + 1 : 0, new StringBuilder(), index, depth + 1);
            parts[Math.min((int)(parts.length - 1), (int)depth)] = part;
        } else {
            parts = index == i$ ? new String[depth - empties] : Strings.split(s, i$, ch, empties, new StringBuilder(), index, depth);
        }
        return parts;
    }

    public static String[] split(CharSequence str, char ch) {
        int i$ = str.length();
        return i$ == 0 ? EMPTY_ARRAY : Strings.split(str, i$, ch, 0, new StringBuilder(), 0, 0);
    }

    public static boolean equals(CharSequence a, CharSequence b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int len = a.length();
        if (len != b.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(CharSequence a, CharSequence b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int len = a.length();
        if (len != b.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (Character.toLowerCase(a.charAt(i)) == Character.toLowerCase(b.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String searchReplace(String str, String searchReplaceRegex) {
        if (searchReplaceRegex == null) {
            return str;
        }
        Matcher matcher = replacePattern.matcher(searchReplaceRegex);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(searchReplaceRegex + ": must be in the form: /<search>/<replace>/");
        }
        String regex = matcher.group(1);
        String replacement = matcher.group(5).replaceAll("((\\\\[lLuU])(\\$((\\d+)|(\\{[^}]+\\})))+)", "\\\\$1\\\\\\\\$2");
        str = str.replaceFirst(regex, replacement);
        StringBuilder b = new StringBuilder();
        boolean escaped = false;
        Boolean upperOne = null;
        boolean upperAll = false;
        Boolean lowerOne = null;
        boolean lowerAll = false;
        int i$ = str.length();
        for (int i = 0; i < i$; ++i) {
            char ch = str.charAt(i);
            if (escaped) {
                escaped = false;
                if (ch == 'u') {
                    upperOne = upperOne != null ? null : Boolean.TRUE;
                    continue;
                }
                if (ch == 'U') {
                    upperAll = !upperAll;
                    continue;
                }
                if (ch == 'l') {
                    lowerOne = lowerOne != null ? null : Boolean.TRUE;
                    continue;
                }
                if (ch == 'L') {
                    lowerAll = !lowerAll;
                    continue;
                }
            } else {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                if (upperOne != null) {
                    if (upperOne.booleanValue()) {
                        b.append(Character.toUpperCase(ch));
                    } else {
                        b.append(ch);
                    }
                    upperOne = Boolean.FALSE;
                    continue;
                }
                if (upperAll) {
                    b.append(Character.toUpperCase(ch));
                    continue;
                }
                if (lowerOne != null) {
                    if (lowerOne.booleanValue()) {
                        b.append(Character.toLowerCase(ch));
                    } else {
                        b.append(ch);
                    }
                    lowerOne = Boolean.FALSE;
                    continue;
                }
                if (lowerAll) {
                    b.append(Character.toLowerCase(ch));
                    continue;
                }
            }
            b.append(ch);
        }
        return b.toString();
    }

    private Strings() {
    }

    public static enum Align {
        LEFT{

            @Override
            void pad(char[] chars, CharSequence seq, int len, char pad) {
                Arrays.fill(chars, len, chars.length, pad);
                for (int i = 0; i < len; ++i) {
                    chars[i] = seq.charAt(i);
                }
            }
        }
        ,
        CENTER{

            @Override
            void pad(char[] chars, CharSequence seq, int len, char pad) {
                int i;
                int offset = (chars.length - len) / 2;
                Arrays.fill(chars, 0, offset, pad);
                for (i = 0; i < len; ++i) {
                    chars[i + offset] = seq.charAt(i);
                }
                i += offset;
                while (i < chars.length) {
                    chars[i] = pad;
                    ++i;
                }
            }
        }
        ,
        RIGHT{

            @Override
            void pad(char[] chars, CharSequence seq, int len, char pad) {
                int offset = chars.length - len;
                Arrays.fill(chars, 0, offset, pad);
                for (int i = 0; i < len; ++i) {
                    chars[i + offset] = seq.charAt(i);
                }
            }
        };


        abstract void pad(char[] var1, CharSequence var2, int var3, char var4);
    }
}

