/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.ServiceConfigurationError;
import java.util.function.Consumer;

public final class ServiceLoaders {
    private static void fail(Class<?> service, String message, Throwable cause) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + message, cause);
    }

    private static void fail(Class<?> service, String message) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + message);
    }

    private static void fail(Class<?> service, URL resource, int line, String message) throws ServiceConfigurationError {
        ServiceLoaders.fail(service, resource + ":" + line + ": " + message);
    }

    private static void add(Class<?> service, String providerName, Consumer consumer, ClassLoader classLoader) {
        try {
            consumer.accept(Class.forName(providerName, false, classLoader));
        }
        catch (ClassNotFoundException e) {
            ServiceLoaders.fail(service, "Provider " + providerName + " not found");
        }
        catch (Throwable t) {
            ServiceLoaders.fail(service, "Provider " + providerName + " could not be instantiated", t);
        }
    }

    private static <S> int parseLine(Class<S> service, URL resource, BufferedReader reader, int lineCount, Consumer<? extends Class<? super S>> consumer, ClassLoader classLoader) throws IOException {
        int n;
        String line = reader.readLine();
        if (line == null) {
            return -1;
        }
        int ci = line.indexOf(35);
        if (ci >= 0) {
            line = line.substring(0, ci);
        }
        if ((n = (line = line.trim()).length()) != 0) {
            int codePoint;
            if (line.indexOf(32) >= 0 || line.indexOf(9) >= 0) {
                ServiceLoaders.fail(service, resource, lineCount, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(codePoint = line.codePointAt(0))) {
                ServiceLoaders.fail(service, resource, lineCount, "Illegal provider-class name: " + line);
            }
            for (int i = Character.charCount(codePoint); i < n; i += Character.charCount(codePoint)) {
                codePoint = line.codePointAt(i);
                if (Character.isJavaIdentifierPart(codePoint) || codePoint == 46) continue;
                ServiceLoaders.fail(service, resource, lineCount, "Illegal provider-class name: " + line);
            }
            ServiceLoaders.add(service, line, consumer, classLoader);
        }
        return lineCount + 1;
    }

    private static <S> void parse(URL resource, Class<S> service, Consumer<? extends Class<? super S>> consumer, ClassLoader classLoader) {
        try {
            URLConnection connection = resource.openConnection();
            connection.setUseCaches(false);
            try (InputStream in = connection.getInputStream();
                 BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                int lc = 1;
                while ((lc = ServiceLoaders.parseLine(service, resource, r, lc, consumer, classLoader)) >= 0) {
                }
            }
        }
        catch (IOException e) {
            ServiceLoaders.fail(service, "Error accessing configuration file", e);
        }
    }

    public static <S> void load(Class<S> service, Consumer<? extends Class<? super S>> consumer) throws IOException {
        ServiceLoaders.load(service, Thread.currentThread().getContextClassLoader(), consumer);
    }

    public static <S> void load(Class<S> service, ClassLoader classLoader, Consumer<? extends Class<? super S>> consumer) throws IOException {
        Enumeration<URL> resources;
        String resourceName = "META-INF/services/" + service.getName();
        Enumeration<URL> enumeration = resources = classLoader == null ? ClassLoader.getSystemResources(resourceName) : classLoader.getResources(resourceName);
        while (resources.hasMoreElements()) {
            ServiceLoaders.parse(resources.nextElement(), service, consumer, classLoader);
        }
    }

    private ServiceLoaders() {
    }
}

