/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.jar.Manifest;

public final class Manifests {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Manifest getManifest(Class<?> cls) throws IOException {
        CodeSource codeSource = cls.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            return null;
        }
        String str = codeSource.getLocation().toString();
        URL url = new URL((str.endsWith(".jar") ? "jar:" + str + "!" : str) + "/META-INF/MANIFEST.MF");
        try (InputStream in = url.openStream();){
            Manifest manifest = new Manifest(in);
            return manifest;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static Manifest[] getManifests(Class<?> cls) throws IOException {
        String name = cls.getName().replace('.', '/').concat(".class");
        return Manifests.getManifests(cls.getClassLoader().getResources(name), name.length(), 0);
    }

    private static Manifest[] getManifests(Enumeration<URL> resources, int length, int depth) throws IOException {
        Manifest manifest;
        if (!resources.hasMoreElements()) {
            return new Manifest[depth];
        }
        String path = resources.nextElement().toString();
        URL url = new URL(path.substring(0, path.length() - length) + "META-INF/MANIFEST.MF");
        try (InputStream in = url.openStream();){
            manifest = new Manifest(in);
        }
        catch (FileNotFoundException e) {
            manifest = null;
        }
        if (manifest == null) {
            return Manifests.getManifests(resources, length, depth);
        }
        Manifest[] manifests = Manifests.getManifests(resources, length, depth + 1);
        manifests[depth] = manifest;
        return manifests;
    }

    private Manifests() {
    }
}

