/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.util.Arrays;
import org.libj.lang.Assertions;
import org.libj.lang.DataEncoding;

public class Hexadecimal
extends DataEncoding<byte[], String> {
    private static final char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private static int charToNibble(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        throw new IllegalArgumentException("Illegal hexadecimal character: " + ch);
    }

    public static String encode(byte[] bytes) {
        return Hexadecimal.encode(bytes, 0, bytes.length);
    }

    public static String encode(byte[] bytes, int offset, int len) {
        StringBuilder str = new StringBuilder(len * 2);
        int i$ = len + offset;
        for (int i = offset; i < i$; ++i) {
            byte b = bytes[i];
            str.append(hexChar[(b & 0xF0) >>> 4]).append(hexChar[b & 0xF]);
        }
        return str.toString();
    }

    private static void decode0(String hex, int fromIndex, int toIndex, byte[] bytes, int offset) {
        int i = fromIndex;
        int j = offset;
        while (i < toIndex) {
            int high = Hexadecimal.charToNibble(hex.charAt(i++));
            int low = Hexadecimal.charToNibble(hex.charAt(i++));
            bytes[j] = (byte)(high << 4 | low);
            ++j;
        }
    }

    public static void decode(String hex, int fromIndex, int toIndex, byte[] bytes, int offset) {
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "hex.length()", hex.length());
        int length = toIndex - fromIndex;
        if (length == 0) {
            return;
        }
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Odd hex length: " + length);
        }
        Hexadecimal.decode0(hex, fromIndex, toIndex, bytes, offset);
    }

    public static byte[] decode(String hex, int fromIndex, int toIndex) {
        Assertions.assertRange("fromIndex", fromIndex, "toIndex", toIndex, "hex.length()", hex.length());
        int length = toIndex - fromIndex;
        if (length == 0) {
            return new byte[0];
        }
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Odd hex length: " + length);
        }
        byte[] bytes = new byte[length / 2];
        Hexadecimal.decode0(hex, fromIndex, toIndex, bytes, 0);
        return bytes;
    }

    public static void decode(String hex, byte[] bytes, int offset) {
        Hexadecimal.decode(hex, 0, hex.length(), bytes, offset);
    }

    public static byte[] decode(String hex) {
        int length = hex.length();
        if (length == 0) {
            return new byte[0];
        }
        byte[] bytes = new byte[length / 2];
        Hexadecimal.decode(hex, 0, hex.length(), bytes, 0);
        return bytes;
    }

    public Hexadecimal(byte[] bytes) {
        super(bytes, null);
    }

    public Hexadecimal(String hex) {
        super(null, hex);
    }

    @Override
    public byte[] getData() {
        byte[] byArray;
        if (this.data == null) {
            byte[] byArray2 = Hexadecimal.decode((String)((Object)this.encoded));
            this.data = byArray2;
            byArray = byArray2;
        } else {
            byArray = (byte[])this.data;
        }
        return byArray;
    }

    @Override
    public String getEncoded() {
        String string;
        if (this.encoded == null) {
            this.encoded = Hexadecimal.encode((byte[])this.data);
            string = this.encoded;
        } else {
            string = (String)((Object)this.encoded);
        }
        return string;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Hexadecimal)) {
            return false;
        }
        Hexadecimal that = (Hexadecimal)obj;
        return this.encoded != null && that.encoded != null ? ((String)((Object)this.encoded)).equalsIgnoreCase((String)((Object)that.encoded)) : Arrays.equals(this.getData(), that.getData());
    }

    public int hashCode() {
        return 31 + Arrays.hashCode(this.getData());
    }

    public String toString() {
        return this.getEncoded();
    }
}

