/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.io.IOException;
import org.libj.lang.Assertions;

public class CountingAppendable
implements Appendable {
    protected final Appendable target;
    private long count;

    public CountingAppendable(Appendable target) {
        this.target = Assertions.assertNotNull(target);
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        this.count += (long)csq.length();
        this.target.append(csq);
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        this.count += (long)(end - start);
        this.target.append(csq, start, end);
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        ++this.count;
        this.target.append(c);
        return this;
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public boolean equals(Object obj) {
        return this.target.equals(obj);
    }

    public String toString() {
        return this.target.toString();
    }
}

