/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import org.libj.lang.Assertions;

public final class Bytes {
    private static final double LOG_2 = 0.6931471805599453;

    public static int indexOf(byte[] bytes, byte ... sequence) {
        return bytes.length == 0 ? -1 : Bytes.indexOf(bytes, 0, sequence);
    }

    public static int indexOf(byte[] bytes, int offset, byte ... sequence) {
        Assertions.assertRangeArray(offset, bytes.length);
        if (sequence.length == 0 || bytes.length < sequence.length) {
            return -1;
        }
        int i$ = bytes.length;
        for (int i = offset; i < i$; ++i) {
            if (bytes[i] != sequence[0]) continue;
            boolean match = true;
            for (int j = 0; j < sequence.length && (match = bytes.length > i + j && sequence[j] == bytes[i + j]); ++j) {
            }
            if (!match) continue;
            return i;
        }
        return -1;
    }

    public static void replaceAll(byte[] bytes, byte target, byte replacement) {
        int index = 0;
        while ((index = Bytes.indexOf(bytes, index + 1, target)) > -1) {
            bytes[index] = replacement;
        }
    }

    public static void replaceAll(byte[] bytes, byte[] target, byte[] replacement) {
        if (target.length != replacement.length) {
            throw new IllegalArgumentException("target.length != replacement.length");
        }
        if (bytes.length < target.length || target.length == 0) {
            return;
        }
        if (target.length == 1) {
            Bytes.replaceAll(bytes, target[0], replacement[0]);
            return;
        }
        int index = -1;
        while ((index = Bytes.indexOf(bytes, index + 1, target)) > -1) {
            System.arraycopy(replacement, 0, bytes, index, replacement.length);
        }
    }

    public static byte[] toBytes(short value, byte[] bytes, int offset, boolean isBigEndian) {
        if (isBigEndian) {
            offset = bytes.length - offset;
            bytes[--offset] = (byte)(value & 0xFF);
            if (offset == 0) {
                return bytes;
            }
            bytes[--offset] = (byte)(value >> 8 & 0xFF);
            return bytes;
        }
        bytes[offset++] = (byte)(value & 0xFF);
        bytes[offset] = (byte)(value >> 8 & 0xFF);
        return bytes;
    }

    public static byte[] toBytes(char c, byte[] bytes, int offset, boolean isBigEndian) {
        if (isBigEndian) {
            offset = bytes.length - offset;
            bytes[--offset] = (byte)(c & 0xFF);
            if (offset == 0) {
                return bytes;
            }
            bytes[--offset] = (byte)(c >> 8 & 0xFF);
            return bytes;
        }
        bytes[offset++] = (byte)(c & 0xFF);
        bytes[offset] = (byte)(c >> 8 & 0xFF);
        return bytes;
    }

    public static byte[] toBytes(int i, byte[] bytes, int offset, boolean isBigEndian) {
        if (isBigEndian) {
            offset = bytes.length - offset;
            bytes[--offset] = (byte)(i & 0xFF);
            if (offset == 0) {
                return bytes;
            }
            bytes[--offset] = (byte)(i >> 8 & 0xFF);
            if (offset == 0) {
                return bytes;
            }
            bytes[--offset] = (byte)(i >> 16 & 0xFF);
            if (offset == 0) {
                return bytes;
            }
            bytes[--offset] = (byte)(i >> 24 & 0xFF);
            return bytes;
        }
        bytes[offset++] = (byte)(i & 0xFF);
        if (offset == bytes.length) {
            return bytes;
        }
        bytes[offset++] = (byte)(i >> 8 & 0xFF);
        if (offset == bytes.length) {
            return bytes;
        }
        bytes[offset++] = (byte)(i >> 16 & 0xFF);
        if (offset == bytes.length) {
            return bytes;
        }
        bytes[offset] = (byte)(i >> 24 & 0xFF);
        return bytes;
    }

    public static byte[] toBytes(long l, byte[] bytes, int offset, boolean isBigEndian) {
        if (isBigEndian) {
            offset = bytes.length - offset;
            bytes[--offset] = (byte)(l & 0xFFL);
            if (offset == 0) {
                return bytes;
            }
            bytes[--offset] = (byte)(l >> 8 & 0xFFL);
            if (offset == 0) {
                return bytes;
            }
            bytes[--offset] = (byte)(l >> 16 & 0xFFL);
            if (offset == 0) {
                return bytes;
            }
            bytes[--offset] = (byte)(l >> 24 & 0xFFL);
            if (offset == 0) {
                return bytes;
            }
            bytes[--offset] = (byte)(l >> 32 & 0xFFL);
            if (offset == 0) {
                return bytes;
            }
            bytes[--offset] = (byte)(l >> 40 & 0xFFL);
            if (offset == 0) {
                return bytes;
            }
            bytes[--offset] = (byte)(l >> 48 & 0xFFL);
            if (offset == 0) {
                return bytes;
            }
            bytes[--offset] = (byte)(l >> 56 & 0xFFL);
            return bytes;
        }
        bytes[offset++] = (byte)(l & 0xFFL);
        if (offset == bytes.length) {
            return bytes;
        }
        bytes[offset++] = (byte)(l >> 8 & 0xFFL);
        if (offset == bytes.length) {
            return bytes;
        }
        bytes[offset++] = (byte)(l >> 16 & 0xFFL);
        if (offset == bytes.length) {
            return bytes;
        }
        bytes[offset++] = (byte)(l >> 24 & 0xFFL);
        if (offset == bytes.length) {
            return bytes;
        }
        bytes[offset++] = (byte)(l >> 32 & 0xFFL);
        if (offset == bytes.length) {
            return bytes;
        }
        bytes[offset++] = (byte)(l >> 40 & 0xFFL);
        if (offset == bytes.length) {
            return bytes;
        }
        bytes[offset++] = (byte)(l >> 48 & 0xFFL);
        if (offset == bytes.length) {
            return bytes;
        }
        bytes[offset] = (byte)(l >> 56 & 0xFFL);
        return bytes;
    }

    public static short toShort(byte[] src, int offset, boolean isBigEndian) {
        return (short)Bytes.toShort(src, offset, isBigEndian, true);
    }

    public static int toShort(byte[] src, int offset, boolean isBigEndian, boolean signed) {
        int value = 0;
        if (isBigEndian) {
            offset = src.length - offset;
            value |= src[--offset] & 0xFF;
            if (offset == 0) {
                return value;
            }
            value |= (src[--offset] & 0xFF) << 8;
            if (offset == 0) {
                return value;
            }
        } else {
            value |= src[offset++] & 0xFF;
            if (offset == src.length) {
                return value;
            }
            value |= (src[offset++] & 0xFF) << 8;
            if (offset == src.length) {
                return value;
            }
        }
        return signed ? (int)value : value;
    }

    public static int toInt(byte[] src, int offset, boolean isBigEndian) {
        return (int)Bytes.toInt(src, offset, isBigEndian, true);
    }

    public static long toInt(byte[] src, int offset, boolean isBigEndian, boolean signed) {
        long value = 0L;
        if (isBigEndian) {
            offset = src.length - offset;
            value |= (long)src[--offset] & 0xFFL;
            if (offset == 0) {
                return value;
            }
            value |= ((long)src[--offset] & 0xFFL) << 8;
            if (offset == 0) {
                return value;
            }
            value |= ((long)src[--offset] & 0xFFL) << 16;
            if (offset == 0) {
                return value;
            }
            value |= ((long)src[--offset] & 0xFFL) << 24;
        } else {
            value |= (long)src[offset++] & 0xFFL;
            if (offset == src.length) {
                return value;
            }
            value |= ((long)src[offset++] & 0xFFL) << 8;
            if (offset == src.length) {
                return value;
            }
            value |= ((long)src[offset++] & 0xFFL) << 16;
            if (offset == src.length) {
                return value;
            }
            value |= ((long)src[offset] & 0xFFL) << 24;
        }
        return signed ? (long)((int)value) : value;
    }

    public static long toLong(byte[] src, int offset, boolean isBigEndian) {
        long value = 0L;
        if (isBigEndian) {
            offset = src.length - offset;
            value |= (long)src[--offset] & 0xFFL;
            if (offset == 0) {
                return value;
            }
            value |= ((long)src[--offset] & 0xFFL) << 8;
            if (offset == 0) {
                return value;
            }
            value |= ((long)src[--offset] & 0xFFL) << 16;
            if (offset == 0) {
                return value;
            }
            value |= ((long)src[--offset] & 0xFFL) << 24;
            if (offset == 0) {
                return value;
            }
            value |= ((long)src[--offset] & 0xFFL) << 32;
            if (offset == 0) {
                return value;
            }
            value |= ((long)src[--offset] & 0xFFL) << 40;
            if (offset == 0) {
                return value;
            }
            value |= ((long)src[--offset] & 0xFFL) << 48;
            if (offset == 0) {
                return value;
            }
            value |= ((long)src[--offset] & 0xFFL) << 56;
        } else {
            value |= (long)src[offset++] & 0xFFL;
            if (offset == src.length) {
                return value;
            }
            value |= ((long)src[offset++] & 0xFFL) << 8;
            if (offset == src.length) {
                return value;
            }
            value |= ((long)src[offset++] & 0xFFL) << 16;
            if (offset == src.length) {
                return value;
            }
            value |= ((long)src[offset++] & 0xFFL) << 24;
            if (offset == src.length) {
                return value;
            }
            value |= ((long)src[offset++] & 0xFFL) << 32;
            if (offset == src.length) {
                return value;
            }
            value |= ((long)src[offset++] & 0xFFL) << 40;
            if (offset == src.length) {
                return value;
            }
            value |= ((long)src[offset++] & 0xFFL) << 48;
            if (offset == src.length) {
                return value;
            }
            value |= ((long)src[offset] & 0xFFL) << 56;
        }
        return value;
    }

    public static short toOctal(byte b) {
        short value = 0;
        int i = 0;
        while (b != 0) {
            int remainder = b % 8;
            b = (byte)(b / 8);
            value = (short)((double)value + (double)remainder * StrictMath.pow(10.0, i));
            ++i;
        }
        return value;
    }

    public static short[] toOctal(byte ... bytes) {
        short[] octal = new short[bytes.length];
        int i$ = bytes.length;
        for (int i = 0; i < i$; ++i) {
            octal[i] = Bytes.toOctal(bytes[i]);
        }
        return octal;
    }

    public static int writeBitsB(byte[] dest, int offset, byte src, byte bits) {
        int i = offset / 8;
        int right = offset % 8;
        int left = 8 - bits;
        src = (byte)(src << left);
        if (left >= right) {
            int n = i;
            dest[n] = (byte)(dest[n] | (byte)((src & 0xFF) >> right));
        } else {
            int n = i;
            dest[n] = (byte)(dest[n] | (src & 0xFF) >> right);
            int n2 = i + 1;
            dest[n2] = (byte)(dest[n2] | src << 8 - right);
        }
        return offset + bits;
    }

    public static int writeBitsB(byte[] dest, int offset, byte[] src, long bits) {
        byte remainder = (byte)(1L + (bits - 1L) % 8L);
        offset = Bytes.writeBitsB(dest, offset, src[0], remainder);
        bits -= (long)remainder;
        int i = 1;
        while (bits > 0L) {
            offset = Bytes.writeBitsB(dest, offset, src[i++], (byte)8);
            bits -= 8L;
        }
        return offset;
    }

    public static int writeBitsL(byte[] dest, int offset, byte src, byte bits) {
        int i = offset / 8;
        int r = offset % 8;
        int left = 8 - bits;
        src = (byte)(src >> left);
        if (left >= r) {
            int n = i;
            dest[n] = (byte)(dest[n] | (byte)((src & 0xFF) << left - r));
        } else {
            int right = r - left;
            int n = i;
            dest[n] = (byte)(dest[n] | (src & 0xFF) >> right);
            int n2 = i + 1;
            dest[n2] = (byte)(dest[n2] | src << 8 - right);
        }
        return offset + bits;
    }

    public static int writeBitsL(byte[] dest, int offset, byte[] src, int bits) {
        int i = 0;
        while (bits > 8) {
            offset = Bytes.writeBitsL(dest, offset, src[i++], (byte)8);
            bits -= 8;
        }
        return Bytes.writeBitsL(dest, offset, src[i], (byte)(1 + (bits - 1) % 8));
    }

    public static byte readBitsFromByte(byte[] src, int offset, byte bits) {
        int i = offset / 8;
        int left = offset % 8;
        bits = (byte)(8 - bits);
        byte dest = (byte)((src[i] << left & 0xFF) >> bits);
        return left <= bits ? dest : (byte)(dest | (src[i + 1] & 0xFF) >> 8 + bits - left);
    }

    public static byte[] readBitsFromBytes(byte[] src, int offset, long bits) {
        if (bits <= 8L) {
            return new byte[]{Bytes.readBitsFromByte(src, offset, (byte)bits)};
        }
        byte[] dest = new byte[(int)(1L + (bits - 1L) / 8L)];
        byte remainder = (byte)(1L + (bits - 1L) % 8L);
        dest[0] = Bytes.readBitsFromByte(src, offset, remainder);
        offset += remainder;
        int i = 1;
        int i$ = dest.length;
        while (i < i$) {
            dest[i] = Bytes.readBitsFromByte(src, offset, (byte)8);
            ++i;
            offset += 8;
        }
        return dest;
    }

    public static byte getSize(int value) {
        return (byte)(1.0 + StrictMath.log(value) / 0.6931471805599453);
    }

    public static byte getSize(long value) {
        return (byte)(1.0 + StrictMath.log(value) / 0.6931471805599453);
    }

    private Bytes() {
    }
}

