/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

public final class Buffers {
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public static byte[] set(byte[] buf, int bit, double resize) {
        int i = bit / 8;
        if (i >= buf.length) {
            if (resize == 0.0) {
                throw new ArrayIndexOutOfBoundsException(bit);
            }
            byte[] resized = new byte[resize < 0.0 ? i - (int)resize : (int)((double)(i + 1) * resize)];
            System.arraycopy(buf, 0, resized, 0, buf.length);
            buf = resized;
        }
        int n = i;
        buf[n] = (byte)(buf[n] | 1 << bit % 8);
        return buf;
    }

    public static char[] set(char[] buf, int bit, double resize) {
        int i = bit / 16;
        if (i >= buf.length) {
            if (resize == 0.0) {
                throw new ArrayIndexOutOfBoundsException(bit);
            }
            char[] resized = new char[resize < 0.0 ? i - (int)resize : (int)((double)(i + 1) * resize)];
            System.arraycopy(buf, 0, resized, 0, buf.length);
            buf = resized;
        }
        int n = i;
        buf[n] = (char)(buf[n] | 1 << bit % 16);
        return buf;
    }

    public static short[] set(short[] buf, int bit, double resize) {
        int i = bit / 16;
        if (i >= buf.length) {
            if (resize == 0.0) {
                throw new ArrayIndexOutOfBoundsException(bit);
            }
            short[] resized = new short[resize < 0.0 ? i - (int)resize : (int)((double)(i + 1) * resize)];
            System.arraycopy(buf, 0, resized, 0, buf.length);
            buf = resized;
        }
        int n = i;
        buf[n] = (short)(buf[n] | 1 << bit % 16);
        return buf;
    }

    public static int[] set(int[] buf, int bit, double resize) {
        int i = bit / 32;
        if (i >= buf.length) {
            if (resize == 0.0) {
                throw new ArrayIndexOutOfBoundsException(bit);
            }
            int[] resized = new int[resize < 0.0 ? i - (int)resize : (int)((double)(i + 1) * resize)];
            System.arraycopy(buf, 0, resized, 0, buf.length);
            buf = resized;
        }
        int n = i;
        buf[n] = buf[n] | 1 << bit % 32;
        return buf;
    }

    public static long[] set(long[] buf, int bit, double resize) {
        int i = bit / 64;
        if (i >= buf.length) {
            if (resize == 0.0) {
                throw new ArrayIndexOutOfBoundsException(bit);
            }
            long[] resized = new long[resize < 0.0 ? i - (int)resize : (int)((double)(i + 1) * resize)];
            System.arraycopy(buf, 0, resized, 0, buf.length);
            buf = resized;
        }
        int n = i;
        buf[n] = buf[n] | 1L << bit % 64;
        return buf;
    }

    public static byte[] clear(byte[] buf, int bit) {
        int i = bit / 8;
        if (i >= buf.length) {
            return buf;
        }
        int n = bit / 8;
        buf[n] = (byte)(buf[n] & ~(1 << bit % 8));
        return buf;
    }

    public static char[] clear(char[] buf, int bit) {
        int i = bit / 16;
        if (i >= buf.length) {
            return buf;
        }
        int n = bit / 16;
        buf[n] = (char)(buf[n] & ~(1 << bit % 16));
        return buf;
    }

    public static short[] clear(short[] buf, int bit) {
        int i = bit / 16;
        if (i >= buf.length) {
            return buf;
        }
        int n = bit / 16;
        buf[n] = (short)(buf[n] & ~(1 << bit % 16));
        return buf;
    }

    public static int[] clear(int[] buf, int bit) {
        int i = bit / 32;
        if (i >= buf.length) {
            return buf;
        }
        int n = bit / 32;
        buf[n] = buf[n] & ~(1 << bit % 32);
        return buf;
    }

    public static long[] clear(long[] buf, int bit) {
        int i = bit / 64;
        if (i >= buf.length) {
            return buf;
        }
        int n = bit / 64;
        buf[n] = buf[n] & (1L << bit % 64 ^ 0xFFFFFFFFFFFFFFFFL);
        return buf;
    }

    public static boolean get(byte[] buf, int bit) {
        int i = bit / 8;
        return i < buf.length && (buf[i] >> bit % 8 & 1) != 0;
    }

    public static boolean get(char[] buf, int bit) {
        int i = bit / 16;
        return i < buf.length && (buf[i] >> bit % 16 & 1) != 0;
    }

    public static boolean get(short[] buf, int bit) {
        int i = bit / 16;
        return i < buf.length && (buf[i] >> bit % 16 & 1) != 0;
    }

    public static boolean get(int[] buf, int bit) {
        int i = bit / 32;
        return i < buf.length && (buf[i] >> bit % 32 & 1) != 0;
    }

    public static boolean get(long[] buf, int bit) {
        int i = bit / 64;
        return i < buf.length && (buf[i] >> bit % 64 & 1L) != 0L;
    }

    public static int length(byte[] buf) {
        int i = buf.length;
        if (i == 0) {
            return 0;
        }
        --i;
        while (buf[i] == 0 && --i >= 0) {
        }
        return ++i;
    }

    public static int length(char[] buf) {
        int i = buf.length;
        if (i == 0) {
            return 0;
        }
        --i;
        while (buf[i] == '\u0000' && --i >= 0) {
        }
        return ++i;
    }

    public static int length(short[] buf) {
        int i = buf.length;
        if (i == 0) {
            return 0;
        }
        --i;
        while (buf[i] == 0 && --i >= 0) {
        }
        return ++i;
    }

    public static int length(int[] buf) {
        int i = buf.length;
        if (i == 0) {
            return 0;
        }
        --i;
        while (buf[i] == 0 && --i >= 0) {
        }
        return ++i;
    }

    public static int length(long[] buf) {
        int i = buf.length;
        if (i == 0) {
            return 0;
        }
        --i;
        while (buf[i] == 0L && --i >= 0) {
        }
        return ++i;
    }

    public static byte[] trimToLength(byte[] buf) {
        int length = Buffers.length(buf);
        if (buf.length == length) {
            return buf;
        }
        byte[] trimmed = new byte[length];
        System.arraycopy(buf, 0, trimmed, 0, length);
        return trimmed;
    }

    public static char[] trimToLength(char[] buf) {
        int length = Buffers.length(buf);
        if (buf.length == length) {
            return buf;
        }
        char[] trimmed = new char[length];
        System.arraycopy(buf, 0, trimmed, 0, length);
        return trimmed;
    }

    public static short[] trimToLength(short[] buf) {
        int length = Buffers.length(buf);
        if (buf.length == length) {
            return buf;
        }
        short[] trimmed = new short[length];
        System.arraycopy(buf, 0, trimmed, 0, length);
        return trimmed;
    }

    public static int[] trimToLength(int[] buf) {
        int length = Buffers.length(buf);
        if (buf.length == length) {
            return buf;
        }
        int[] trimmed = new int[length];
        System.arraycopy(buf, 0, trimmed, 0, length);
        return trimmed;
    }

    public static long[] trimToLength(long[] buf) {
        int length = Buffers.length(buf);
        if (buf.length == length) {
            return buf;
        }
        long[] trimmed = new long[length];
        System.arraycopy(buf, 0, trimmed, 0, length);
        return trimmed;
    }

    private static void toUnsignedString(long val, byte[] buf, int index, int size) {
        int offset = index * size;
        int pos = size + offset;
        do {
            buf[--pos] = (byte)digits[(int)val & 1];
            val >>>= 1;
        } while (pos > offset);
    }

    public static String toString(byte ... buf) {
        byte[] bytes = new byte[buf.length * 8];
        int i$ = buf.length;
        for (int i = 0; i < i$; ++i) {
            Buffers.toUnsignedString(buf[i], bytes, i, 8);
        }
        return new String(bytes);
    }

    public static String toString(char ... buf) {
        byte[] bytes = new byte[buf.length * 16];
        int i$ = buf.length;
        for (int i = 0; i < i$; ++i) {
            Buffers.toUnsignedString(buf[i], bytes, i, 16);
        }
        return new String(bytes);
    }

    public static String toString(short ... buf) {
        byte[] bytes = new byte[buf.length * 16];
        int i$ = buf.length;
        for (int i = 0; i < i$; ++i) {
            Buffers.toUnsignedString(buf[i], bytes, i, 16);
        }
        return new String(bytes);
    }

    public static String toString(int ... buf) {
        byte[] bytes = new byte[buf.length * 32];
        int i$ = buf.length;
        for (int i = 0; i < i$; ++i) {
            Buffers.toUnsignedString(buf[i], bytes, i, 32);
        }
        return new String(bytes);
    }

    public static String toString(long ... buf) {
        byte[] bytes = new byte[buf.length * 64];
        int i$ = buf.length;
        for (int i = 0; i < i$; ++i) {
            Buffers.toUnsignedString(buf[i], bytes, i, 64);
        }
        return new String(bytes);
    }

    private Buffers() {
    }
}

