/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class BigDecimals {
    private static final ConcurrentHashMap<Serializable, BigDecimal> instances = new ConcurrentHashMap();
    public static final BigDecimal POSITIVE_INFINITY = new BigDecimalInfinity(1);
    public static final BigDecimal NEGATIVE_INFINITY = new BigDecimalInfinity(-1);
    public static final BigDecimal ZERO = BigDecimals.init((Serializable)((Object)"0"), BigDecimal.ZERO);
    public static final BigDecimal ONE = BigDecimals.init((Serializable)((Object)"1"), BigDecimal.ONE);
    public static final BigDecimal TWO = BigDecimals.init((Serializable)((Object)"2"), BigDecimal.valueOf(2L));
    public static final BigDecimal E = BigDecimals.init((Serializable)((Object)String.valueOf(Math.E)), BigDecimal.valueOf(Math.E));
    public static final BigDecimal PI = BigDecimals.init((Serializable)((Object)String.valueOf(Math.PI)), BigDecimal.valueOf(Math.PI));
    public static final BigDecimal LOG_2 = BigDecimals.init((Serializable)((Object)String.valueOf(0.6931471805599453)), BigDecimal.valueOf(0.6931471805599453));
    public static final BigDecimal LOG_10 = BigDecimals.init((Serializable)((Object)String.valueOf(2.302585092994046)), BigDecimal.valueOf(2.302585092994046));
    public static final BigDecimal SQRT_2 = BigDecimals.init((Serializable)((Object)String.valueOf(1.414213562373095)), BigDecimal.valueOf(1.414213562373095));

    private static BigDecimal init(Serializable key, BigDecimal val) {
        instances.put(key, val);
        return val;
    }

    public static BigDecimal intern(String val) {
        BigDecimal instance = instances.get(Objects.requireNonNull(val));
        return instance != null ? instance : BigDecimals.init((Serializable)((Object)val), new BigDecimal(val));
    }

    public static BigDecimal intern(BigDecimal n) {
        BigDecimal instance = instances.putIfAbsent((Serializable)((Object)n.toString()), n);
        return instance != null ? instance : n;
    }

    public static BigDecimal intern(long val) {
        BigDecimal instance = instances.get(val);
        return instance != null ? instance : BigDecimals.init(Long.valueOf(val), new BigDecimal(val));
    }

    public static BigDecimal intern(Long val) {
        BigDecimal instance = instances.get(Objects.requireNonNull(val));
        return instance != null ? instance : BigDecimals.init(val, new BigDecimal(val));
    }

    public static BigDecimal intern(double val) {
        BigDecimal instance = instances.get(val);
        return instance != null ? instance : BigDecimals.init(Double.valueOf(val), new BigDecimal(val));
    }

    public static BigDecimal intern(Double val) {
        BigDecimal instance = instances.get(Objects.requireNonNull(val));
        return instance != null ? instance : BigDecimals.init(val, new BigDecimal(val));
    }

    public static BigDecimal setScale(BigDecimal v, int newScale, RoundingMode rm) {
        int newScale1 = newScale + 1;
        if (v.scale() <= newScale1) {
            return v.setScale(newScale, rm);
        }
        if (rm != RoundingMode.UNNECESSARY) {
            v = v.setScale(newScale1, RoundingMode.DOWN);
        }
        return v.setScale(newScale, rm);
    }

    private BigDecimals() {
    }

    private static class BigDecimalInfinity
    extends BigDecimal {
        private final int signum;
        private final String str;

        private BigDecimalInfinity(int signum) {
            super(0);
            this.signum = signum;
            this.str = signum < 0 ? "-Infinity" : "Infinity";
        }

        @Override
        public int signum() {
            return this.signum;
        }

        @Override
        public BigDecimal scaleByPowerOfTen(int n) {
            return this;
        }

        @Override
        public BigDecimal stripTrailingZeros() {
            return this;
        }

        @Override
        public BigInteger toBigIntegerExact() {
            throw new ArithmeticException();
        }

        @Override
        public String toEngineeringString() {
            return this.toString();
        }

        @Override
        public String toPlainString() {
            return this.toString();
        }

        @Override
        public String toString() {
            return this.str;
        }
    }
}

