/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.util.Collection;
import java.util.function.Supplier;

public final class Assertions {
    public static boolean assertTrue(boolean value, String message) {
        if (!value) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static boolean assertTrue(boolean value, Supplier<String> message) {
        if (!value) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static boolean assertTrue(boolean value, String format, Object ... args) {
        if (!value) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static boolean assertTrue(boolean value) {
        return Assertions.assertTrue(value, "false");
    }

    public static boolean assertFalse(boolean value, String message) {
        if (value) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static boolean assertFalse(boolean value, Supplier<String> message) {
        if (value) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static boolean assertFalse(boolean value, String format, Object ... args) {
        if (value) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static boolean assertFalse(boolean value) {
        return Assertions.assertFalse(value, "true");
    }

    public static <T> T assertNull(T obj, String message) {
        if (obj != null) {
            throw new IllegalArgumentException(message);
        }
        return obj;
    }

    public static <T> T assertNull(T obj, Supplier<String> message) {
        if (obj != null) {
            throw new IllegalArgumentException(message.get());
        }
        return obj;
    }

    public static <T> T assertNull(T obj, String format, Object ... args) {
        if (obj != null) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return obj;
    }

    public static <T> T assertNull(T obj) {
        return Assertions.assertNull(obj, "not null");
    }

    public static <T> T assertNotNull(T obj, String message) {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
        return obj;
    }

    public static <T> T assertNotNull(T obj, Supplier<String> message) {
        if (obj == null) {
            throw new IllegalArgumentException(message.get());
        }
        return obj;
    }

    public static <T> T assertNotNull(T obj, String format, Object ... args) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return obj;
    }

    public static <T> T assertNotNull(T obj) {
        return Assertions.assertNotNull(obj, "null");
    }

    public static <T> T[] assertNotNullArray(T[] obj, String message) {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
        int i$ = obj.length;
        for (int i = 0; i < i$; ++i) {
            if (obj[i] != null) continue;
            throw new IllegalArgumentException(message + " at index " + i);
        }
        return obj;
    }

    public static <T> T[] assertNotNullArray(T[] obj, Supplier<String> message) {
        if (obj == null) {
            throw new IllegalArgumentException(message.get());
        }
        int i$ = obj.length;
        for (int i = 0; i < i$; ++i) {
            if (obj[i] != null) continue;
            throw new IllegalArgumentException(message + " at index " + i);
        }
        return obj;
    }

    public static <T> T[] assertNotNullArray(T[] obj, String format, Object ... args) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        int i$ = obj.length;
        for (int i = 0; i < i$; ++i) {
            if (obj[i] != null) continue;
            throw new IllegalArgumentException(String.format(format, args) + " at index " + i);
        }
        return obj;
    }

    public static <T> T[] assertNotNullArray(T[] obj) {
        return Assertions.assertNotNullArray(obj, "null");
    }

    public static boolean[] assertNotEmpty(boolean[] obj, String message) {
        Assertions.assertNotNull(obj, message);
        if (obj.length == 0) {
            throw new IllegalArgumentException(message);
        }
        return obj;
    }

    public static boolean[] assertNotEmpty(boolean[] obj, Supplier<String> message) {
        Assertions.assertNotNull(obj, message);
        if (obj.length == 0) {
            throw new IllegalArgumentException(message.get());
        }
        return obj;
    }

    public static boolean[] assertNotEmpty(boolean[] obj, String format, Object ... args) {
        Assertions.assertNotNull(obj, format, args);
        if (obj.length == 0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return obj;
    }

    public static boolean[] assertNotEmpty(boolean[] obj) {
        Assertions.assertNotNull(obj, "null");
        if (obj.length == 0) {
            throw new IllegalArgumentException("empty");
        }
        return obj;
    }

    public static byte[] assertNotEmpty(byte[] obj, String message) {
        Assertions.assertNotNull(obj, message);
        if (obj.length == 0) {
            throw new IllegalArgumentException(message);
        }
        return obj;
    }

    public static byte[] assertNotEmpty(byte[] obj, Supplier<String> message) {
        Assertions.assertNotNull(obj, message);
        if (obj.length == 0) {
            throw new IllegalArgumentException(message.get());
        }
        return obj;
    }

    public static byte[] assertNotEmpty(byte[] obj, String format, Object ... args) {
        Assertions.assertNotNull(obj, format, args);
        if (obj.length == 0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return obj;
    }

    public static byte[] assertNotEmpty(byte[] obj) {
        Assertions.assertNotNull(obj, "null");
        if (obj.length == 0) {
            throw new IllegalArgumentException("empty");
        }
        return obj;
    }

    public static char[] assertNotEmpty(char[] obj, String message) {
        Assertions.assertNotNull(obj, message);
        if (obj.length == 0) {
            throw new IllegalArgumentException(message);
        }
        return obj;
    }

    public static char[] assertNotEmpty(char[] obj, Supplier<String> message) {
        Assertions.assertNotNull(obj, message);
        if (obj.length == 0) {
            throw new IllegalArgumentException(message.get());
        }
        return obj;
    }

    public static char[] assertNotEmpty(char[] obj, String format, Object ... args) {
        Assertions.assertNotNull(obj, format, args);
        if (obj.length == 0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return obj;
    }

    public static char[] assertNotEmpty(char[] obj) {
        Assertions.assertNotNull(obj, "null");
        if (obj.length == 0) {
            throw new IllegalArgumentException("empty");
        }
        return obj;
    }

    public static short[] assertNotEmpty(short[] obj, String message) {
        Assertions.assertNotNull(obj, message);
        if (obj.length == 0) {
            throw new IllegalArgumentException(message);
        }
        return obj;
    }

    public static short[] assertNotEmpty(short[] obj, Supplier<String> message) {
        Assertions.assertNotNull(obj, message);
        if (obj.length == 0) {
            throw new IllegalArgumentException(message.get());
        }
        return obj;
    }

    public static short[] assertNotEmpty(short[] obj, String format, Object ... args) {
        Assertions.assertNotNull(obj, format, args);
        if (obj.length == 0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return obj;
    }

    public static short[] assertNotEmpty(short[] obj) {
        Assertions.assertNotNull(obj, "null");
        if (obj.length == 0) {
            throw new IllegalArgumentException("empty");
        }
        return obj;
    }

    public static int[] assertNotEmpty(int[] obj, String message) {
        Assertions.assertNotNull(obj, message);
        if (obj.length == 0) {
            throw new IllegalArgumentException(message);
        }
        return obj;
    }

    public static int[] assertNotEmpty(int[] obj, Supplier<String> message) {
        Assertions.assertNotNull(obj, message);
        if (obj.length == 0) {
            throw new IllegalArgumentException(message.get());
        }
        return obj;
    }

    public static int[] assertNotEmpty(int[] obj, String format, Object ... args) {
        Assertions.assertNotNull(obj, format, args);
        if (obj.length == 0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return obj;
    }

    public static int[] assertNotEmpty(int[] obj) {
        Assertions.assertNotNull(obj, "null");
        if (obj.length == 0) {
            throw new IllegalArgumentException("empty");
        }
        return obj;
    }

    public static long[] assertNotEmpty(long[] obj, String message) {
        Assertions.assertNotNull(obj, message);
        if (obj.length == 0) {
            throw new IllegalArgumentException(message);
        }
        return obj;
    }

    public static long[] assertNotEmpty(long[] obj, Supplier<String> message) {
        Assertions.assertNotNull(obj, message);
        if (obj.length == 0) {
            throw new IllegalArgumentException(message.get());
        }
        return obj;
    }

    public static long[] assertNotEmpty(long[] obj, String format, Object ... args) {
        Assertions.assertNotNull(obj, format, args);
        if (obj.length == 0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return obj;
    }

    public static long[] assertNotEmpty(long[] obj) {
        Assertions.assertNotNull(obj, "null");
        if (obj.length == 0) {
            throw new IllegalArgumentException("empty");
        }
        return obj;
    }

    public static float[] assertNotEmpty(float[] obj, String message) {
        Assertions.assertNotNull(obj, message);
        if (obj.length == 0) {
            throw new IllegalArgumentException(message);
        }
        return obj;
    }

    public static float[] assertNotEmpty(float[] obj, Supplier<String> message) {
        Assertions.assertNotNull(obj, message);
        if (obj.length == 0) {
            throw new IllegalArgumentException(message.get());
        }
        return obj;
    }

    public static float[] assertNotEmpty(float[] obj, String format, Object ... args) {
        Assertions.assertNotNull(obj, format, args);
        if (obj.length == 0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return obj;
    }

    public static float[] assertNotEmpty(float[] obj) {
        Assertions.assertNotNull(obj, "null");
        if (obj.length == 0) {
            throw new IllegalArgumentException("empty");
        }
        return obj;
    }

    public static double[] assertNotEmpty(double[] obj, String message) {
        Assertions.assertNotNull(obj, message);
        if (obj.length == 0) {
            throw new IllegalArgumentException(message);
        }
        return obj;
    }

    public static double[] assertNotEmpty(double[] obj, Supplier<String> message) {
        Assertions.assertNotNull(obj, message);
        if (obj.length == 0) {
            throw new IllegalArgumentException(message.get());
        }
        return obj;
    }

    public static double[] assertNotEmpty(double[] obj, String format, Object ... args) {
        Assertions.assertNotNull(obj, format, args);
        if (obj.length == 0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return obj;
    }

    public static double[] assertNotEmpty(double[] obj) {
        Assertions.assertNotNull(obj, "null");
        if (obj.length == 0) {
            throw new IllegalArgumentException("empty");
        }
        return obj;
    }

    public static <T> T[] assertNotEmpty(T[] obj, String message) {
        Assertions.assertNotNull(obj, message);
        if (obj.length == 0) {
            throw new IllegalArgumentException(message);
        }
        return obj;
    }

    public static <T> T[] assertNotEmpty(T[] obj, Supplier<String> message) {
        Assertions.assertNotNull(obj, message);
        if (obj.length == 0) {
            throw new IllegalArgumentException(message.get());
        }
        return obj;
    }

    public static <T> T[] assertNotEmpty(T[] obj, String format, Object ... args) {
        Assertions.assertNotNull(obj, format, args);
        if (obj.length == 0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return obj;
    }

    public static <T> T[] assertNotEmpty(T[] obj) {
        Assertions.assertNotNull(obj, "null");
        if (obj.length == 0) {
            throw new IllegalArgumentException("empty");
        }
        return obj;
    }

    public static <T extends Collection<?>> T assertNotEmpty(T obj, String message) {
        Assertions.assertNotNull(obj, message);
        if (obj.size() == 0) {
            throw new IllegalArgumentException(message);
        }
        return obj;
    }

    public static <T extends Collection<?>> T assertNotEmpty(T obj, Supplier<String> message) {
        Assertions.assertNotNull(obj, message);
        if (obj.size() == 0) {
            throw new IllegalArgumentException(message.get());
        }
        return obj;
    }

    public static <T extends Collection<?>> T assertNotEmpty(T obj, String format, Object ... args) {
        if (Assertions.assertNotNull(obj, format, args).size() == 0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return obj;
    }

    public static <T extends Collection<?>> T assertNotEmpty(T obj) {
        Assertions.assertNotNull(obj, "null");
        if (obj.size() == 0) {
            throw new IllegalArgumentException("empty");
        }
        return obj;
    }

    public static CharSequence assertNotEmpty(CharSequence str, String message) {
        Assertions.assertNotNull(str, message);
        if (str.length() == 0) {
            throw new IllegalArgumentException(message);
        }
        return str;
    }

    public static CharSequence assertNotEmpty(CharSequence str, Supplier<String> message) {
        Assertions.assertNotNull(str, message);
        if (str.length() == 0) {
            throw new IllegalArgumentException(message.get());
        }
        return str;
    }

    public static CharSequence assertNotEmpty(CharSequence str, String format, Object ... args) {
        if (Assertions.assertNotNull(str, format, args).length() == 0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return str;
    }

    public static CharSequence assertNotEmpty(CharSequence str) {
        Assertions.assertNotNull(str, "null");
        if (str.length() == 0) {
            throw new IllegalArgumentException("empty");
        }
        return str;
    }

    public static float assertFinite(float value, String message) {
        if (!Float.isFinite(value)) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static float assertFinite(float value, Supplier<String> message) {
        if (!Float.isFinite(value)) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static float assertFinite(float value, String format, Object ... args) {
        if (!Float.isFinite(value)) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static float assertFinite(float value) {
        if (!Float.isFinite(value)) {
            throw new IllegalArgumentException(value + " is not finite");
        }
        return value;
    }

    public static double assertFinite(double value, String message) {
        if (!Double.isFinite(value)) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static double assertFinite(double value, Supplier<String> message) {
        if (!Double.isFinite(value)) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static double assertFinite(double value, String format, Object ... args) {
        if (!Double.isFinite(value)) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static double assertFinite(double value) {
        if (!Double.isFinite(value)) {
            throw new IllegalArgumentException(value + " is not finite");
        }
        return value;
    }

    public static byte assertPositive(byte value) {
        if (value <= 0) {
            throw new IllegalArgumentException(value + " is not positive");
        }
        return value;
    }

    public static byte assertPositive(byte value, String message) {
        if (value <= 0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static byte assertPositive(byte value, Supplier<String> message) {
        if (value <= 0) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static byte assertPositive(byte value, String format, Object ... args) {
        if (value <= 0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static short assertPositive(short value) {
        if (value <= 0) {
            throw new IllegalArgumentException(value + " is not positive");
        }
        return value;
    }

    public static short assertPositive(short value, String message) {
        if (value <= 0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static short assertPositive(short value, Supplier<String> message) {
        if (value <= 0) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static short assertPositive(short value, String format, Object ... args) {
        if (value <= 0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static int assertPositive(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException(value + " is not positive");
        }
        return value;
    }

    public static int assertPositive(int value, String message) {
        if (value <= 0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static int assertPositive(int value, Supplier<String> message) {
        if (value <= 0) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static int assertPositive(int value, String format, Object ... args) {
        if (value <= 0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static long assertPositive(long value) {
        if (value <= 0L) {
            throw new IllegalArgumentException(value + " is not positive");
        }
        return value;
    }

    public static long assertPositive(long value, String message) {
        if (value <= 0L) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static long assertPositive(long value, Supplier<String> message) {
        if (value <= 0L) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static long assertPositive(long value, String format, Object ... args) {
        if (value <= 0L) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static float assertPositive(float value) {
        if (Assertions.assertFinite(value) <= 0.0f) {
            throw new IllegalArgumentException(value + " is not positive");
        }
        return value;
    }

    public static float assertPositive(float value, String message) {
        if (Assertions.assertFinite(value) <= 0.0f) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static float assertPositive(float value, Supplier<String> message) {
        if (Assertions.assertFinite(value) <= 0.0f) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static float assertPositive(float value, String format, Object ... args) {
        if (Assertions.assertFinite(value) <= 0.0f) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static double assertPositive(double value) {
        if (Assertions.assertFinite(value) <= 0.0) {
            throw new IllegalArgumentException(value + " is not positive");
        }
        return value;
    }

    public static double assertPositive(double value, String message) {
        if (Assertions.assertFinite(value) <= 0.0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static double assertPositive(double value, Supplier<String> message) {
        if (Assertions.assertFinite(value) <= 0.0) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static double assertPositive(double value, String format, Object ... args) {
        if (Assertions.assertFinite(value) <= 0.0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static byte assertNotNegative(byte value, String message) {
        if (value < 0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static byte assertNotNegative(byte value, Supplier<String> message) {
        if (value < 0) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static byte assertNotNegative(byte value, String format, Object ... args) {
        if (value < 0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static byte assertNotNegative(byte value) {
        if (value < 0) {
            throw new IllegalArgumentException(value + " is negative");
        }
        return value;
    }

    public static short assertNotNegative(short value, String message) {
        if (value < 0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static short assertNotNegative(short value, Supplier<String> message) {
        if (value < 0) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static short assertNotNegative(short value, String format, Object ... args) {
        if (value < 0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static short assertNotNegative(short value) {
        if (value < 0) {
            throw new IllegalArgumentException(value + " is negative");
        }
        return value;
    }

    public static int assertNotNegative(int value, String message) {
        if (value < 0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static int assertNotNegative(int value, Supplier<String> message) {
        if (value < 0) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static int assertNotNegative(int value, String format, Object ... args) {
        if (value < 0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static int assertNotNegative(int value) {
        if (value < 0) {
            throw new IllegalArgumentException(value + " is negative");
        }
        return value;
    }

    public static long assertNotNegative(long value, String message) {
        if (value < 0L) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static long assertNotNegative(long value, Supplier<String> message) {
        if (value < 0L) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static long assertNotNegative(long value, String format, Object ... args) {
        if (value < 0L) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static long assertNotNegative(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException(value + " is negative");
        }
        return value;
    }

    public static byte assertNotZero(byte value, String message) {
        if (value == 0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static byte assertNotZero(byte value, Supplier<String> message) {
        if (value == 0) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static byte assertNotZero(byte value, String format, Object ... args) {
        if (value == 0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static byte assertNotZero(byte value) {
        if (value == 0) {
            throw new IllegalArgumentException(value + " is zero");
        }
        return value;
    }

    public static short assertNotZero(short value, String message) {
        if (value == 0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static short assertNotZero(short value, Supplier<String> message) {
        if (value == 0) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static short assertNotZero(short value, String format, Object ... args) {
        if (value == 0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static short assertNotZero(short value) {
        if (value == 0) {
            throw new IllegalArgumentException(value + " is zero");
        }
        return value;
    }

    public static int assertNotZero(int value, String message) {
        if (value == 0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static int assertNotZero(int value, Supplier<String> message) {
        if (value == 0) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static int assertNotZero(int value, String format, Object ... args) {
        if (value == 0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static int assertNotZero(int value) {
        if (value == 0) {
            throw new IllegalArgumentException(value + " is zero");
        }
        return value;
    }

    public static long assertNotZero(long value, String message) {
        if (value == 0L) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static long assertNotZero(long value, Supplier<String> message) {
        if (value == 0L) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static long assertNotZero(long value, String format, Object ... args) {
        if (value == 0L) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static long assertNotZero(long value) {
        if (value == 0L) {
            throw new IllegalArgumentException(value + " is zero");
        }
        return value;
    }

    public static float assertNotZero(float value, String message) {
        if (value == 0.0f) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static float assertNotZero(float value, Supplier<String> message) {
        if (value == 0.0f) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static float assertNotZero(float value, String format, Object ... args) {
        if (value == 0.0f) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static float assertNotZero(float value) {
        if (value == 0.0f) {
            throw new IllegalArgumentException(value + " is zero");
        }
        return value;
    }

    public static double assertNotZero(double value, String message) {
        if (value == 0.0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static double assertNotZero(double value, Supplier<String> message) {
        if (value == 0.0) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static double assertNotZero(double value, String format, Object ... args) {
        if (value == 0.0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static double assertNotZero(double value) {
        if (value == 0.0) {
            throw new IllegalArgumentException(value + " is zero");
        }
        return value;
    }

    public static float assertNotNegative(float value, String message) {
        if (Assertions.assertFinite(value) < 0.0f) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static float assertNotNegative(float value, Supplier<String> message) {
        if (Assertions.assertFinite(value) < 0.0f) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static float assertNotNegative(float value, String format, Object ... args) {
        if (Assertions.assertFinite(value) < 0.0f) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static float assertNotNegative(float value) {
        if (Assertions.assertFinite(value) < 0.0f) {
            throw new IllegalArgumentException(value + " is negative");
        }
        return value;
    }

    public static double assertNotNegative(double value, String message) {
        if (Assertions.assertFinite(value) < 0.0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static double assertNotNegative(double value, Supplier<String> message) {
        if (Assertions.assertFinite(value) < 0.0) {
            throw new IllegalArgumentException(message.get());
        }
        return value;
    }

    public static double assertNotNegative(double value, String format, Object ... args) {
        if (Assertions.assertFinite(value) < 0.0) {
            throw new IllegalArgumentException(String.format(format, args));
        }
        return value;
    }

    public static double assertNotNegative(double value) {
        if (Assertions.assertFinite(value) < 0.0) {
            throw new IllegalArgumentException(value + " is negative");
        }
        return value;
    }

    public static byte assertRangeMinMax(byte value, byte min, byte max) {
        if (max < min) {
            throw new IllegalArgumentException("Illegal bounds: min (" + min + ") is not less than or equal to max (" + max + ")");
        }
        if (value < min || max < value) {
            throw new IllegalArgumentException(value + " is not in range: [" + min + "," + max + ")");
        }
        return value;
    }

    public static short assertRangeMinMax(short value, short min, short max) {
        if (max < min) {
            throw new IllegalArgumentException("Illegal bounds: min (" + min + ") is not less than or equal to max (" + max + ")");
        }
        if (value < min || max < value) {
            throw new IllegalArgumentException(value + " is not in range: [" + min + "," + max + ")");
        }
        return value;
    }

    public static int assertRangeMinMax(int value, int min, int max) {
        if (max < min) {
            throw new IllegalArgumentException("Illegal bounds: min (" + min + ") is not less than or equal to max (" + max + ")");
        }
        if (value < min || max < value) {
            throw new IllegalArgumentException(value + " is not in range: [" + min + "," + max + ")");
        }
        return value;
    }

    public static long assertRangeMinMax(long value, long min, long max) {
        if (max < min) {
            throw new IllegalArgumentException("Illegal bounds: min (" + min + ") is not less than or equal to max (" + max + ")");
        }
        if (value < min || max < value) {
            throw new IllegalArgumentException(value + " is not in range: [" + min + "," + max + ")");
        }
        return value;
    }

    public static float assertRangeMinMax(float value, float min, float max) {
        Assertions.assertFinite(value);
        Assertions.assertFinite(min);
        Assertions.assertFinite(max);
        if (max < min) {
            throw new IllegalArgumentException("Illegal bounds: min (" + min + ") is not less than or equal to max (" + max + ")");
        }
        if (value < min || max < value) {
            throw new IllegalArgumentException(value + " is not in range: [" + min + "," + max + ")");
        }
        return value;
    }

    public static double assertRangeMinMax(double value, double min, double max) {
        Assertions.assertFinite(value);
        Assertions.assertFinite(min);
        Assertions.assertFinite(max);
        if (max < min) {
            throw new IllegalArgumentException("Illegal bounds: min (" + min + ") is not less than or equal to max (" + max + ")");
        }
        if (value < min || max < value) {
            throw new IllegalArgumentException(value + " is not in range: [" + min + "," + max + ")");
        }
        return value;
    }

    public static void assertOffsetLengthArray(int offset, int length) {
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException(length);
        }
    }

    public static void assertRangeArray(int fromIndex, int toIndex, int length) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > length) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex (" + fromIndex + ") > toIndex (" + toIndex + ")");
        }
    }

    public static int assertRangeArray(int index, int length) {
        if (index < 0 || length <= index) {
            throw new ArrayIndexOutOfBoundsException("Index: " + index + ", Length: " + length);
        }
        return index;
    }

    public static void assertOffsetLength(String offsetLabel, int offset, String lengthLabel, int length) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException(offsetLabel + ": " + offset);
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException(lengthLabel + ": " + length);
        }
    }

    public static int assertRange(String indexLabel, int index, String lengthLabel, int length) {
        if (index < 0 || length <= index) {
            throw new IndexOutOfBoundsException(indexLabel + ": " + index + ", " + lengthLabel + ": " + length);
        }
        return index;
    }

    public static void assertRange(String fromIndexLabel, int fromIndex, String toIndexLabel, int toIndex, String sizeLabel, int size) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException(fromIndexLabel + ": " + fromIndex);
        }
        if (toIndex > size) {
            throw new IndexOutOfBoundsException(toIndexLabel + " (" + toIndex + ") > " + sizeLabel + " (" + size + ")");
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException(fromIndexLabel + " (" + fromIndex + ") > " + toIndexLabel + " (" + toIndex + ")");
        }
    }

    public static int assertRange(String indexLabel, int index, String sizeLabel, int size, boolean forAdd) {
        if (index < 0 || (forAdd ? size < index : size <= index)) {
            throw new IndexOutOfBoundsException(indexLabel + ": " + index + ", " + sizeLabel + ": " + size);
        }
        return index;
    }

    public static void assertBoundsOffsetCount(String lengthLabel, int length, String offsetLabel, int offset, String countLabel, int count) {
        if (length < 0) {
            throw new IllegalArgumentException(lengthLabel + ": " + length);
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException(offsetLabel + ": " + offset);
        }
        if (count < 0) {
            throw new IndexOutOfBoundsException(countLabel + ": " + count);
        }
        if (length < offset + count) {
            throw new IndexOutOfBoundsException(lengthLabel + " (" + length + ") < " + offsetLabel + " (" + offset + ") + " + countLabel + " (" + count + ")");
        }
    }

    private Assertions() {
    }
}

