/* Copyright (c) 2010 Seva Safris, LibJ
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * You should have received a copy of The MIT License (MIT) along with this
 * program. If not, see <http://opensource.org/licenses/MIT/>.
 */

package org.libj.lang;

/** Common numerical constants. */
public final class Constants {
  /** The {@code double} constant {@code log(2)}. */
  public static final double LOG_2 = 0.6931471805599453;

  /** The {@code double} constant {@code log(10)}. */
  public static final double LOG_10 = 2.302585092994046;

  /** The {@code double} constant {@code sqrt(2)}. */
  public static final double SQRT_2 = 1.414213562373095;

  private Constants() {
  }
}