/*
 * Decompiled with CFR 0.152.
 */
package org.libj.io;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.libj.util.StringPaths;
import org.libj.util.function.Throwing;

public final class FileUtil {
    private static File CWD;
    private static File TEMP_DIR;
    private static ConcurrentMap<Path, ArrayList<DirectoryStream.Filter<? super Path>>> deleteOnExit;
    private static final AtomicBoolean deleteOnExitMutex;
    private static final DirectoryStream.Filter<Path> anyStreamFilter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteOnExit(Path path, DirectoryStream.Filter<? super Path> filter, final Consumer<Throwable> onThrow) {
        ArrayList<DirectoryStream.Filter<? super Path>> filters;
        if (!deleteOnExitMutex.get()) {
            AtomicBoolean atomicBoolean = deleteOnExitMutex;
            synchronized (atomicBoolean) {
                if (!deleteOnExitMutex.get()) {
                    deleteOnExit = new ConcurrentHashMap<Path, ArrayList<DirectoryStream.Filter<? super Path>>>();
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            for (Map.Entry entry : deleteOnExit.entrySet()) {
                                Path path = (Path)entry.getKey();
                                ArrayList value = (ArrayList)entry.getValue();
                                int i$ = value.size();
                                for (int i = 0; i < i$; ++i) {
                                    DirectoryStream.Filter filter = (DirectoryStream.Filter)value.get(i);
                                    try {
                                        FileUtil.deleteAll0(path, filter);
                                        continue;
                                    }
                                    catch (Throwable t) {
                                        if (onThrow == null) continue;
                                        onThrow.accept(t);
                                    }
                                }
                            }
                        }
                    });
                    deleteOnExitMutex.set(true);
                }
            }
        }
        if ((filters = (ArrayList<DirectoryStream.Filter<? super Path>>)deleteOnExit.get(path)) == null) {
            filters = new ArrayList<DirectoryStream.Filter<? super Path>>(1);
            deleteOnExit.put(path, filters);
        }
        filters.add(filter != null ? filter : anyStreamFilter);
    }

    public static File existsOrNull(String pathname) {
        File file = new File(pathname);
        return file.exists() ? file : null;
    }

    public static File getCwd() {
        return CWD == null ? (CWD = new File("").getAbsoluteFile()) : CWD;
    }

    public static File getTempDir() {
        return TEMP_DIR == null ? (TEMP_DIR = new File(System.getProperty("java.io.tmpdir"))) : TEMP_DIR;
    }

    private static void deleteAll0(Path path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, filter);){
                for (Path entry : stream) {
                    if (Files.isDirectory(entry, new LinkOption[0])) {
                        FileUtil.deleteAll0(entry, filter);
                        continue;
                    }
                    Files.delete(entry);
                }
            }
        }
        Files.delete(path);
    }

    public static void deleteAllOnExit(Path path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        FileUtil.deleteOnExit(path, filter, null);
    }

    public static void deleteAllOnExit(Path path, DirectoryStream.Filter<? super Path> filter, Consumer<Throwable> onThrowable) throws IOException {
        File file = path.toFile();
        if (file.isDirectory()) {
            FileUtil.deleteOnExit(path, filter, onThrowable);
        } else if (filter != null && filter.accept(path)) {
            file.deleteOnExit();
        }
    }

    public static void deleteAllOnExit(File file, DirectoryStream.Filter<? super Path> filter) throws IOException {
        FileUtil.deleteAllOnExit(file, filter, null);
    }

    public static void deleteAllOnExit(File file, DirectoryStream.Filter<? super Path> filter, Consumer<Throwable> onThrowable) throws IOException {
        Path path = file.toPath();
        if (file.isDirectory()) {
            FileUtil.deleteOnExit(path, filter, onThrowable);
        } else if (filter != null && filter.accept(path)) {
            file.deleteOnExit();
        }
    }

    public static void deleteAllOnExit(Path path) {
        try {
            FileUtil.deleteAllOnExit(path, anyStreamFilter);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Should not ever occur", e);
        }
    }

    public static void deleteAllOnExit(File file) {
        try {
            FileUtil.deleteAllOnExit(file, anyStreamFilter);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Should not ever occur", e);
        }
    }

    public static boolean deleteAll(Path path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        FileUtil.deleteAll0(path, filter != null ? filter : anyStreamFilter);
        return !Files.exists(path, new LinkOption[0]);
    }

    public static boolean deleteAll(Path path) throws IOException {
        FileUtil.deleteAll0(path, anyStreamFilter);
        return !Files.exists(path, new LinkOption[0]);
    }

    public static Path copyAll(Path source, Path target, CopyOption ... options) throws IOException {
        if (Files.isRegularFile(source, new LinkOption[0])) {
            return Files.copy(source, target, options);
        }
        if (Files.exists(target, new LinkOption[0]) && options != null) {
            int i$ = options.length;
            for (int i = 0; i < i$; ++i) {
                if (options[i] != StandardCopyOption.REPLACE_EXISTING || FileUtil.deleteAll(target)) continue;
                throw new DirectoryNotEmptyException(target.toString());
            }
        }
        Files.walk(source, new FileVisitOption[0]).forEach(Throwing.rethrow(path -> {
            Path resolved = target.resolve(source.relativize((Path)path));
            if (Files.isRegularFile(path, new LinkOption[0])) {
                Files.copy(path, resolved, options);
            } else if (!Files.exists(resolved, new LinkOption[0])) {
                Files.createDirectory(resolved, new FileAttribute[0]);
            }
        }));
        return target;
    }

    public static File commonality(File ... files) {
        int i;
        if (files.length == 0) {
            throw new IllegalArgumentException("files.length == 0");
        }
        File file0 = files[0];
        String[] canons = new String[files.length];
        String canons0 = canons[0] = StringPaths.canonicalize((String)file0.getPath());
        int length = canons0.length();
        int i$ = files.length;
        for (i = 1; i < i$; ++i) {
            canons[i] = StringPaths.canonicalize((String)files[i].getPath());
            String canon = canons[i];
            int len = canon.length();
            if (len >= length) continue;
            length = len;
        }
        for (i = 0; i < length; ++i) {
            char ch = canons0.charAt(i);
            int j$ = files.length;
            for (int j = 1; j < j$; ++j) {
                if (ch == canons[j].charAt(i)) continue;
                return new File(canons0.substring(0, i));
            }
        }
        return file0;
    }

    public static String getShortName(File file) {
        String name = file.getName();
        int index = name.lastIndexOf(46);
        return index == -1 ? name : name.substring(0, index);
    }

    private FileUtil() {
    }

    static {
        deleteOnExitMutex = new AtomicBoolean();
        anyStreamFilter = p -> true;
    }
}

