/*
 * Decompiled with CFR 0.152.
 */
package org.libj.exec;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Predicate;
import org.libj.io.Streams;
import org.libj.io.TeeOutputStream;
import org.libj.util.ArrayUtil;

public final class Processes {
    private static final String JAVA = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    private static final Predicate<String> notNullPredicate = Objects::nonNull;

    public static int getPID() {
        String pidAtHost = ManagementFactory.getRuntimeMXBean().getName();
        if (pidAtHost == null) {
            return -1;
        }
        try {
            return Integer.parseInt(pidAtHost.substring(0, pidAtHost.indexOf(64)));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static Map<String, String> getSystemProperties() {
        Properties properties = System.getProperties();
        int size = properties.size();
        if (size == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> map = new HashMap<String, String>(size * 2 / 3);
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            String key = (String)property.getKey();
            String value = ((String)property.getValue()).trim();
            if (value.length() == 0 || value.indexOf(32) != -1 || key.indexOf(32) != -1) continue;
            map.put(key, value);
        }
        return map;
    }

    private static Map<String, String> combineProperties(Map<String, String> props) {
        if (props == null) {
            return Processes.getSystemProperties();
        }
        Map<String, String> all = Processes.getSystemProperties();
        all.putAll(props);
        return all;
    }

    static Process fork(InputStream stdin, OutputStream stdout, OutputStream stderr, boolean redirectErrorStream, boolean sync, Map<String, String> envp, File dir, String ... args) throws IOException {
        InputStream teeStdout;
        String[] env;
        int size;
        args = (String[])ArrayUtil.filter(notNullPredicate, (Object[])args);
        if (envp != null && (size = envp.size()) > 0) {
            env = new String[size];
            Iterator<Map.Entry<String, String>> iterator = envp.entrySet().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                env[i] = entry.getKey() + "=" + entry.getValue();
                ++i;
            }
        } else {
            env = null;
        }
        Process process = Runtime.getRuntime().exec(args, env, dir);
        OutputStream teeStdin = process.getOutputStream();
        if (stdin != null) {
            Streams.pipeAsync((InputStream)stdin, (OutputStream)teeStdin);
            teeStdin = new TeeOutputStream(new OutputStream[]{teeStdin, stdout});
        }
        InputStream teeStderr = process.getErrorStream();
        if (redirectErrorStream) {
            teeStdout = Streams.mergeAsync((InputStream[])new InputStream[]{process.getInputStream(), teeStderr});
        } else {
            teeStdout = process.getInputStream();
            if (stderr != null) {
                if (sync) {
                    Streams.pipeAsync((InputStream)teeStderr, (OutputStream)stderr);
                } else {
                    teeStderr = Streams.teeAsync((InputStream)teeStderr, (OutputStream)stderr);
                }
            }
        }
        if (stdout != null) {
            if (sync) {
                Streams.pipeAsync((InputStream)teeStdout, (OutputStream)stdout);
            } else {
                teeStdout = Streams.teeAsync((InputStream)teeStdout, (OutputStream)stdout);
            }
        }
        return new PipedProcess(process, teeStdin, teeStdout, teeStderr);
    }

    public static Process forkAsync(InputStream stdin, OutputStream stdout, OutputStream stderr, boolean redirectErrorStream, Map<String, String> envp, File dir, String ... args) throws IOException {
        return Processes.fork(stdin, stdout, stderr, redirectErrorStream, false, envp, dir, args);
    }

    public static Process forkAsync(InputStream stdin, OutputStream stdout, OutputStream stderr, boolean redirectErrorStream, Map<String, String> envp, File dir, File[] classpath, String[] vmArgs, Map<String, String> props, Class<?> mainClass, String ... args) throws IOException {
        return Processes.forkAsync(stdin, stdout, stderr, redirectErrorStream, envp, dir, Processes.createJavaCommand(classpath, vmArgs, Processes.combineProperties(props), mainClass, args));
    }

    public static int forkSync(InputStream stdin, OutputStream stdout, OutputStream stderr, boolean redirectErrorStream, Map<String, String> envp, File dir, String ... args) throws InterruptedException, IOException {
        return Processes.fork(stdin, stdout, stderr, redirectErrorStream, true, envp, dir, args).waitFor();
    }

    public static int forkSync(InputStream stdin, OutputStream stdout, OutputStream stderr, boolean redirectErrorStream, Map<String, String> envp, File dir, File[] classpath, String[] vmArgs, Map<String, String> props, Class<?> mainClass, String ... args) throws InterruptedException, IOException {
        return Processes.forkAsync(stdin, stdout, stderr, redirectErrorStream, envp, dir, Processes.createJavaCommand(classpath, vmArgs, Processes.combineProperties(props), mainClass, args)).waitFor();
    }

    private static String[] createJavaCommand(File[] classpath, String[] vmArgs, Map<String, String> props, Class<?> mainClass, String ... args) {
        StringBuilder cp = new StringBuilder();
        if (classpath != null && classpath.length != 0) {
            int i$ = classpath.length;
            for (int i = 0; i < i$; ++i) {
                if (i > 0) {
                    cp.append(File.pathSeparatorChar);
                }
                cp.append(classpath[i].getPath());
            }
        }
        String[] options = new String[(args != null ? args.length : 0) + (vmArgs != null ? vmArgs.length : 0) + (props != null ? props.size() : 0) + 4];
        int i = -1;
        options[++i] = JAVA;
        if (vmArgs != null && vmArgs.length != 0) {
            for (String vmArg : vmArgs) {
                options[++i] = vmArg;
            }
        }
        if (props != null && props.size() != 0) {
            for (Map.Entry entry : props.entrySet()) {
                options[++i] = "-D" + (String)entry.getKey() + "=" + (String)entry.getValue();
            }
        }
        options[++i] = "-cp";
        options[++i] = cp.toString();
        options[++i] = mainClass.getName();
        if (args != null) {
            System.arraycopy(args, 0, options, ++i, args.length);
        }
        return options;
    }

    private Processes() {
    }

    private static final class PipedProcess
    extends Process {
        private final Process process;
        private final OutputStream stdin;
        private final InputStream stdout;
        private final InputStream stderr;

        private PipedProcess(Process process, OutputStream stdin, InputStream stdout, InputStream stderr) {
            this.process = process;
            this.stdin = stdin;
            this.stdout = stdout;
            this.stderr = stderr;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.stdin;
        }

        @Override
        public InputStream getInputStream() {
            return this.stdout;
        }

        @Override
        public InputStream getErrorStream() {
            return this.stderr;
        }

        @Override
        public int waitFor() throws InterruptedException {
            return this.process.waitFor();
        }

        @Override
        public int exitValue() {
            return this.process.exitValue();
        }

        @Override
        public void destroy() {
            this.process.destroy();
        }
    }
}

