/*
 * Decompiled with CFR 0.152.
 */
package org.lesscss.mojo;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.StringUtils;
import org.lesscss.LessCompiler;
import org.lesscss.LessException;
import org.lesscss.LessSource;
import org.lesscss.mojo.AbstractLessCssMojo;
import org.lesscss.mojo.NodeJsLessCompiler;

public class CompileMojo
extends AbstractLessCssMojo {
    protected File outputDirectory;
    private boolean compress;
    protected boolean watch = false;
    private int watchInterval = 1000;
    private String encoding;
    private boolean force;
    private File lessJs;
    private String nodeExecutable;
    private String outputFileFormat;
    private static final String FILE_NAME_FORMAT_PARAMETER_REGEX = "\\{fileName\\}";

    public void execute() throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("sourceDirectory = " + this.sourceDirectory));
            this.getLog().debug((CharSequence)("outputDirectory = " + this.outputDirectory));
            this.getLog().debug((CharSequence)("includes = " + Arrays.toString(this.includes)));
            this.getLog().debug((CharSequence)("excludes = " + Arrays.toString(this.excludes)));
            this.getLog().debug((CharSequence)("force = " + this.force));
            this.getLog().debug((CharSequence)("lessJs = " + this.lessJs));
            this.getLog().debug((CharSequence)("skip = " + this.skip));
        }
        if (!this.skip) {
            this.executeInternal();
        } else {
            this.getLog().info((CharSequence)"Skipping plugin execution per configuration");
        }
    }

    private void executeInternal() throws MojoExecutionException {
        long start = System.currentTimeMillis();
        Object[] files = this.getIncludedFiles();
        if (files == null || files.length < 1) {
            this.getLog().info((CharSequence)"Nothing to compile - no LESS sources found");
        } else {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("included files = " + Arrays.toString(files)));
            }
            Object lessCompiler = this.initLessCompiler();
            if (this.watch) {
                this.getLog().info((CharSequence)("Watching " + this.sourceDirectory));
                if (this.force) {
                    this.force = false;
                    this.getLog().info((CharSequence)"Disabled the 'force' flag in watch mode.");
                }
                Thread.currentThread().setPriority(1);
                while (this.watch && !Thread.currentThread().isInterrupted()) {
                    this.compileIfChanged((String[])files, lessCompiler);
                    try {
                        Thread.sleep(this.watchInterval);
                    }
                    catch (InterruptedException e) {
                        System.out.println("interrupted");
                    }
                }
            } else {
                this.compileIfChanged((String[])files, lessCompiler);
            }
            this.getLog().info((CharSequence)("Complete Less compile job finished in " + (System.currentTimeMillis() - start) + " ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileIfChanged(String[] files, Object lessCompiler) throws MojoExecutionException {
        try {
            for (String file : files) {
                File output;
                File input = new File(this.sourceDirectory, file);
                this.buildContext.removeMessages(input);
                if (this.outputFileFormat != null) {
                    file = this.outputFileFormat.replaceAll(FILE_NAME_FORMAT_PARAMETER_REGEX, file.replace(".less", ""));
                }
                if (!(output = new File(this.outputDirectory, file.replace(".less", ".css"))).getParentFile().exists() && !output.getParentFile().mkdirs()) {
                    throw new MojoExecutionException("Cannot create output directory " + output.getParentFile());
                }
                try {
                    LessSource lessSource = new LessSource(input);
                    if (this.force || !output.exists() || output.lastModified() < lessSource.getLastModifiedIncludingImports()) {
                        long compilationStarted = System.currentTimeMillis();
                        this.getLog().info((CharSequence)("Compiling LESS source: " + file + "..."));
                        if (lessCompiler instanceof LessCompiler) {
                            ((LessCompiler)lessCompiler).compile(lessSource, output, this.force);
                        } else {
                            ((NodeJsLessCompiler)lessCompiler).compile(lessSource, output, this.force);
                        }
                        this.buildContext.refresh(output);
                        this.getLog().info((CharSequence)("Finished compilation to " + this.outputDirectory + " in " + (System.currentTimeMillis() - compilationStarted) + " ms"));
                        continue;
                    }
                    if (this.watch) continue;
                    this.getLog().info((CharSequence)("Bypassing LESS source: " + file + " (not modified)"));
                }
                catch (IOException e) {
                    this.buildContext.addMessage(input, 0, 0, "Error compiling LESS source", 2, (Throwable)e);
                    throw new MojoExecutionException("Error while compiling LESS source: " + file, (Exception)e);
                }
                catch (LessException e) {
                    String message = e.getMessage();
                    if (StringUtils.isEmpty((String)message)) {
                        message = "Error compiling LESS source";
                    }
                    this.buildContext.addMessage(input, 0, 0, "Error compiling LESS source", 2, (Throwable)e);
                    throw new MojoExecutionException("Error while compiling LESS source: " + file, (Exception)((Object)e));
                }
                catch (InterruptedException e) {
                    this.buildContext.addMessage(input, 0, 0, "Error compiling LESS source", 2, (Throwable)e);
                    throw new MojoExecutionException("Error while compiling LESS source: " + file, (Exception)e);
                }
            }
        }
        finally {
            if (lessCompiler instanceof NodeJsLessCompiler) {
                ((NodeJsLessCompiler)lessCompiler).close();
            }
        }
    }

    private Object initLessCompiler() throws MojoExecutionException {
        if (this.nodeExecutable != null) {
            NodeJsLessCompiler lessCompiler;
            try {
                lessCompiler = new NodeJsLessCompiler(this.nodeExecutable, this.compress, this.encoding, this.getLog());
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            if (this.lessJs != null) {
                throw new MojoExecutionException("Custom LESS JavaScript is not currently supported when using nodeExecutable");
            }
            return lessCompiler;
        }
        LessCompiler lessCompiler = new LessCompiler();
        lessCompiler.setCompress(this.compress);
        lessCompiler.setEncoding(this.encoding);
        if (this.lessJs != null) {
            try {
                lessCompiler.setLessJs(this.lessJs.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Error while loading LESS JavaScript: " + this.lessJs.getAbsolutePath(), (Exception)e);
            }
        }
        return lessCompiler;
    }
}

