/*
 * Decompiled with CFR 0.152.
 */
package org.LatencyUtils;

import java.lang.ref.WeakReference;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.AtomicHistogram;
import org.HdrHistogram.Histogram;
import org.LatencyUtils.IntervalEstimator;
import org.LatencyUtils.PauseDetector;
import org.LatencyUtils.PauseDetectorListener;
import org.LatencyUtils.TimeCappedMovingAverageIntervalEstimator;

public class LatencyStats {
    private static PauseDetector defaultPauseDetector;
    private static Builder defaultBuilder;
    private final long lowestTrackableLatency;
    private final long highestTrackableLatency;
    private final int numberOfSignificantValueDigits;
    private final long histogramUpdateInterval;
    private final int numberOfRecentHistogramIntervalsToTrack;
    private AtomicHistogram currentRecordingHistogram;
    private Histogram currentPauseCorrectionHistogram;
    private AtomicHistogram[] intervalRecordingHistograms;
    private Histogram[] intervalPauseCorrectingHistograms;
    private long[] intervalCaptureTimes;
    private volatile int latestIntervalHistogramIndex = 0;
    private Histogram uncorrectedAccumulatedHistogram;
    private Histogram accumulatedHistogram;
    private volatile long recordingStartEpoch = 0L;
    private volatile long recordingEndEpoch = 0L;
    private static final AtomicLongFieldUpdater<LatencyStats> recordingStartEpochUpdater;
    private static final AtomicLongFieldUpdater<LatencyStats> recordingEndEpochUpdater;
    private static final Timer latencyStatsTasksTimer;
    private final PeriodicHistogramUpdateTask updateTask;
    private final PauseTracker pauseTracker;
    private final IntervalEstimator intervalEstimator;
    private final PauseDetector pauseDetector;

    public static void setDefaultPauseDetector(PauseDetector pauseDetector) {
        defaultPauseDetector = pauseDetector;
    }

    public LatencyStats() {
        this(defaultBuilder.lowestTrackableLatency, defaultBuilder.highestTrackableLatency, defaultBuilder.numberOfSignificantValueDigits, defaultBuilder.histogramUpdateInterval, defaultBuilder.numberOfRecentHistogramIntervalsToTrack, defaultBuilder.intervalEstimatorWindowLength, defaultBuilder.intervalEstimatorTimeCap, defaultBuilder.pauseDetector);
    }

    public LatencyStats(long lowestTrackableLatency, long highestTrackableLatency, int numberOfSignificantValueDigits, long histogramUpdateInterval, int numberOfRecentHistogramIntervalsToTrack, int intervalEstimatorWindowLength, long intervalEstimatorTimeCap, PauseDetector pauseDetector) {
        int i;
        if (pauseDetector == null) {
            if (defaultPauseDetector == null) {
                throw new IllegalStateException("If a pause detector is not supplied, a default pause detector must first be set for LatencyStats.");
            }
            this.pauseDetector = defaultPauseDetector;
        } else {
            this.pauseDetector = pauseDetector;
        }
        this.lowestTrackableLatency = lowestTrackableLatency;
        this.highestTrackableLatency = highestTrackableLatency;
        this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
        this.histogramUpdateInterval = histogramUpdateInterval;
        this.numberOfRecentHistogramIntervalsToTrack = numberOfRecentHistogramIntervalsToTrack;
        this.currentRecordingHistogram = new AtomicHistogram(lowestTrackableLatency, highestTrackableLatency, numberOfSignificantValueDigits);
        this.intervalRecordingHistograms = new AtomicHistogram[numberOfRecentHistogramIntervalsToTrack];
        for (i = 0; i < numberOfRecentHistogramIntervalsToTrack; ++i) {
            this.intervalRecordingHistograms[i] = new AtomicHistogram(lowestTrackableLatency, highestTrackableLatency, numberOfSignificantValueDigits);
        }
        this.currentPauseCorrectionHistogram = new Histogram(lowestTrackableLatency, highestTrackableLatency, numberOfSignificantValueDigits);
        this.intervalPauseCorrectingHistograms = new Histogram[numberOfRecentHistogramIntervalsToTrack];
        for (i = 0; i < numberOfRecentHistogramIntervalsToTrack; ++i) {
            this.intervalPauseCorrectingHistograms[i] = new Histogram(lowestTrackableLatency, highestTrackableLatency, numberOfSignificantValueDigits);
        }
        this.accumulatedHistogram = new Histogram(lowestTrackableLatency, highestTrackableLatency, numberOfSignificantValueDigits);
        this.uncorrectedAccumulatedHistogram = new Histogram(lowestTrackableLatency, highestTrackableLatency, numberOfSignificantValueDigits);
        this.intervalCaptureTimes = new long[numberOfRecentHistogramIntervalsToTrack];
        this.intervalEstimator = new TimeCappedMovingAverageIntervalEstimator(intervalEstimatorWindowLength, intervalEstimatorTimeCap, this.pauseDetector);
        this.updateTask = new PeriodicHistogramUpdateTask(this.histogramUpdateInterval, this);
        this.pauseTracker = new PauseTracker(this.pauseDetector, this);
    }

    public void recordLatency(long latency) {
        recordingStartEpochUpdater.incrementAndGet(this);
        this.trackRecordingInterval();
        this.currentRecordingHistogram.recordValue(latency);
        recordingEndEpochUpdater.incrementAndGet(this);
    }

    public synchronized Histogram getAccumulatedHistogram() {
        return this.accumulatedHistogram.copy();
    }

    public synchronized void getAccumulatedHistogramInto(Histogram targetHistogram) {
        this.accumulatedHistogram.copyInto((AbstractHistogram)targetHistogram);
    }

    public synchronized void addAccumulatedHistogramTo(Histogram toHistogram) {
        toHistogram.add((AbstractHistogram)this.accumulatedHistogram);
    }

    public synchronized Histogram getUncorrectedAccumulatedHistogram() {
        return this.uncorrectedAccumulatedHistogram.copy();
    }

    public synchronized Histogram getIntervalHistogram() {
        Histogram intervalHistogram = new Histogram(this.lowestTrackableLatency, this.highestTrackableLatency, this.numberOfSignificantValueDigits);
        this.getIntervalHistogramInto(intervalHistogram);
        return intervalHistogram;
    }

    public synchronized void getIntervalHistogramInto(Histogram targetHistogram) {
        int index = this.latestIntervalHistogramIndex;
        this.intervalRecordingHistograms[index].copyInto((AbstractHistogram)targetHistogram);
        targetHistogram.add((AbstractHistogram)this.intervalPauseCorrectingHistograms[index]);
    }

    public synchronized void addIntervalHistogramTo(Histogram toHistogram) {
        int index = this.latestIntervalHistogramIndex;
        toHistogram.add((AbstractHistogram)this.intervalRecordingHistograms[index]);
        toHistogram.add((AbstractHistogram)this.intervalPauseCorrectingHistograms[index]);
    }

    public synchronized Histogram getUncorrectedIntervalHistogram() {
        int index = this.latestIntervalHistogramIndex;
        Histogram intervalHistogram = new Histogram(this.lowestTrackableLatency, this.highestTrackableLatency, this.numberOfSignificantValueDigits);
        this.intervalRecordingHistograms[index].copyInto((AbstractHistogram)intervalHistogram);
        return intervalHistogram;
    }

    public synchronized void forceIntervalUpdate() {
        this.updateHistograms();
    }

    public synchronized void resetAccumulatedHistogram() {
        this.accumulatedHistogram.reset();
        this.uncorrectedAccumulatedHistogram.reset();
    }

    public synchronized void stop() {
        this.updateTask.stop();
        this.pauseTracker.stop();
    }

    public IntervalEstimator getIntervalEstimator() {
        return this.intervalEstimator;
    }

    public PauseDetector getPauseDetector() {
        return this.pauseDetector;
    }

    synchronized void recordDetectedPause(long pauseLength, long pauseEndTime) {
        long estimatedInterval = this.intervalEstimator.getEstimatedInterval(pauseEndTime - pauseLength);
        if (pauseLength > estimatedInterval) {
            this.currentPauseCorrectionHistogram.recordValueWithExpectedInterval(pauseLength, estimatedInterval);
        }
    }

    void trackRecordingInterval() {
        long now = System.nanoTime();
        this.intervalEstimator.recordInterval(now);
    }

    void swapRecordingHistograms(int indexToSwap) {
        AtomicHistogram tempHistogram = this.intervalRecordingHistograms[indexToSwap];
        this.intervalRecordingHistograms[indexToSwap] = this.currentRecordingHistogram;
        this.currentRecordingHistogram = tempHistogram;
    }

    void swapPauseCorrectionHistograms(int indexToSwap) {
        Histogram tempHistogram = this.intervalPauseCorrectingHistograms[indexToSwap];
        this.intervalPauseCorrectingHistograms[indexToSwap] = this.currentPauseCorrectionHistogram;
        this.currentPauseCorrectionHistogram = tempHistogram;
    }

    synchronized void swapHistograms(int indexToSwap) {
        this.swapRecordingHistograms(indexToSwap);
        this.swapPauseCorrectionHistograms(indexToSwap);
    }

    synchronized void updateHistograms() {
        int indexToSwap = (this.latestIntervalHistogramIndex + 1) % this.numberOfRecentHistogramIntervalsToTrack;
        this.intervalRecordingHistograms[indexToSwap].reset();
        this.intervalPauseCorrectingHistograms[indexToSwap].reset();
        this.swapHistograms(indexToSwap);
        this.intervalCaptureTimes[indexToSwap] = System.nanoTime();
        this.latestIntervalHistogramIndex = indexToSwap;
        long startEpoch = recordingStartEpochUpdater.get(this);
        while (recordingEndEpochUpdater.get(this) < startEpoch) {
        }
        this.uncorrectedAccumulatedHistogram.add((AbstractHistogram)this.intervalRecordingHistograms[this.latestIntervalHistogramIndex]);
        this.accumulatedHistogram.add((AbstractHistogram)this.intervalRecordingHistograms[this.latestIntervalHistogramIndex]);
        this.accumulatedHistogram.add((AbstractHistogram)this.intervalPauseCorrectingHistograms[this.latestIntervalHistogramIndex]);
    }

    static {
        defaultBuilder = new Builder();
        recordingStartEpochUpdater = AtomicLongFieldUpdater.newUpdater(LatencyStats.class, "recordingStartEpoch");
        recordingEndEpochUpdater = AtomicLongFieldUpdater.newUpdater(LatencyStats.class, "recordingEndEpoch");
        latencyStatsTasksTimer = new Timer();
    }

    static class PeriodicHistogramUpdateTask
    extends TimerTask {
        final WeakReference<LatencyStats> latencyStatsRef;

        PeriodicHistogramUpdateTask(long histogramUpdateInterval, LatencyStats latencyStats) {
            this.latencyStatsRef = new WeakReference<LatencyStats>(latencyStats);
            if (histogramUpdateInterval != 0L) {
                latencyStatsTasksTimer.scheduleAtFixedRate((TimerTask)this, 0L, histogramUpdateInterval / 1000000L);
            }
        }

        public void stop() {
            this.cancel();
        }

        @Override
        public void run() {
            LatencyStats latencyStats = (LatencyStats)this.latencyStatsRef.get();
            if (latencyStats != null) {
                latencyStats.updateHistograms();
            } else {
                this.cancel();
            }
        }
    }

    static class PauseTracker
    extends WeakReference<LatencyStats>
    implements PauseDetectorListener {
        final PauseDetector pauseDetector;

        PauseTracker(PauseDetector pauseDetector, LatencyStats latencyStats) {
            super(latencyStats);
            this.pauseDetector = pauseDetector;
            pauseDetector.addListener(this);
        }

        public void stop() {
            this.pauseDetector.removeListener(this);
        }

        @Override
        public void handlePauseEvent(long pauseLength, long pauseEndTime) {
            LatencyStats latencyStats = (LatencyStats)this.get();
            if (latencyStats != null) {
                latencyStats.recordDetectedPause(pauseLength, pauseEndTime);
            } else {
                this.stop();
            }
        }
    }

    public static class Builder {
        private long lowestTrackableLatency = 1000L;
        private long highestTrackableLatency = 3600000000000L;
        private int numberOfSignificantValueDigits = 2;
        private long histogramUpdateInterval = 1000000000L;
        private int numberOfRecentHistogramIntervalsToTrack = 2;
        private int intervalEstimatorWindowLength = 1024;
        private long intervalEstimatorTimeCap = 10000000000L;
        private PauseDetector pauseDetector = null;

        public static Builder create() {
            return new Builder();
        }

        public Builder lowestTrackableLatency(long lowestTrackableLatency) {
            this.lowestTrackableLatency = lowestTrackableLatency;
            return this;
        }

        public Builder highestTrackableLatency(long highestTrackableLatency) {
            this.highestTrackableLatency = highestTrackableLatency;
            return this;
        }

        public Builder numberOfSignificantValueDigits(int numberOfSignificantValueDigits) {
            this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
            return this;
        }

        public Builder histogramUpdateInterval(long histogramUpdateInterval) {
            this.histogramUpdateInterval = histogramUpdateInterval;
            return this;
        }

        public Builder numberOfRecentHistogramIntervalsToTrack(int numberOfRecentHistogramIntervalsToTrack) {
            this.numberOfRecentHistogramIntervalsToTrack = numberOfRecentHistogramIntervalsToTrack;
            return this;
        }

        public Builder intervalEstimatorWindowLength(int intervalEstimatorWindowLength) {
            this.intervalEstimatorWindowLength = intervalEstimatorWindowLength;
            return this;
        }

        public Builder intervalEstimatorTimeCap(long intervalEstimatorTimeCap) {
            this.intervalEstimatorTimeCap = intervalEstimatorTimeCap;
            return this;
        }

        public Builder pauseDetector(PauseDetector pauseDetector) {
            this.pauseDetector = pauseDetector;
            return this;
        }

        public LatencyStats build() {
            return new LatencyStats(this.lowestTrackableLatency, this.highestTrackableLatency, this.numberOfSignificantValueDigits, this.histogramUpdateInterval, this.numberOfRecentHistogramIntervalsToTrack, this.intervalEstimatorWindowLength, this.intervalEstimatorTimeCap, this.pauseDetector);
        }
    }
}

