/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.simulation;

import java.util.List;
import java.util.Random;

class DocProvider {
    private static final int MAX_VAL = 20000;
    private final List<String> docs;
    private Random rnd;

    DocProvider(List<String> docs) {
        this.docs = docs;
        this.reset();
    }

    void reset() {
        this.rnd = new Random(120L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDoc() {
        int len = this.getWeightedRandomLength();
        List<String> list = this.docs;
        synchronized (list) {
            StringBuilder appended = new StringBuilder();
            int paraSize = 0;
            while (appended.length() < len) {
                if (this.docs.size() == 0) {
                    throw new RuntimeException("Not enough docs left to provide another document");
                }
                String doc = this.docs.get(0);
                appended.append(doc).append(" ");
                if ((paraSize += doc.length()) > 250 && appended.toString().endsWith(". ")) {
                    appended.append(doc).append("\n\n");
                    paraSize = 0;
                }
                this.docs.remove(0);
            }
            return appended.substring(0, len);
        }
    }

    int getWeightedRandomLength() {
        int max = this.getRandomMaxLength();
        int min = max == 20000 ? 550 : max - 49;
        return min + this.rnd.nextInt(max - min);
    }

    private int getRandomMaxLength() {
        double rnd = this.rnd.nextFloat() * 100.0f;
        float fix = 15.6f;
        if (rnd < 32.0) {
            return 49;
        }
        if (rnd < (double)(50.0f + fix)) {
            return 99;
        }
        if (rnd < (double)(60.0f + fix)) {
            return 149;
        }
        if (rnd < (double)(67.0f + fix)) {
            return 199;
        }
        if (rnd < (double)(72.0f + fix)) {
            return 249;
        }
        if (rnd < (double)(75.0f + fix)) {
            return 299;
        }
        if (rnd < (double)(78.0f + fix)) {
            return 349;
        }
        if (rnd < (double)(80.0f + fix)) {
            return 399;
        }
        if (rnd < (double)(82.0f + fix)) {
            return 449;
        }
        if (rnd < (double)(83.0f + fix)) {
            return 499;
        }
        if (rnd < (double)(84.0f + fix)) {
            return 549;
        }
        return 20000;
    }
}

