/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.eval;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public class MissingDiacriticsEvaluator {
    private static final String encoding = "UTF-8";
    static String[] words = new String[2];
    static String[] ruleIds = new String[2];
    static int[][] results = new int[2][4];
    static Language lang = null;
    static JLanguageTool lt = null;
    static List<String> classifyTypes = Arrays.asList("TP", "FP", "TN", "FN");

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            MissingDiacriticsEvaluator.help();
        }
        long start = System.currentTimeMillis();
        lang = Languages.getLanguageForShortCode((String)args[0]);
        lt = new JLanguageTool(lang);
        String filename = args[1];
        MissingDiacriticsEvaluator.words[0] = args[2];
        MissingDiacriticsEvaluator.words[1] = StringTools.removeDiacritics((String)words[0]);
        MissingDiacriticsEvaluator.ruleIds[0] = "Rules " + words[0] + " -> " + words[1];
        MissingDiacriticsEvaluator.ruleIds[1] = "Rules " + words[1] + " -> " + words[0];
        try (InputStreamReader isr = MissingDiacriticsEvaluator.getInputStreamReader(filename, encoding);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                List sentencesLine = lt.sentenceTokenize(line);
                for (String sentence : sentencesLine) {
                    List tokens = lang.getWordTokenizer().tokenize(sentence);
                    int pos = 0;
                    for (String token : tokens) {
                        if (token.equalsIgnoreCase(words[0])) {
                            MissingDiacriticsEvaluator.analyzeSentence(sentence, 0, pos);
                        }
                        if (token.equalsIgnoreCase(words[1])) {
                            MissingDiacriticsEvaluator.analyzeSentence(sentence, 1, pos);
                        }
                        pos += token.length();
                    }
                }
            }
        }
        for (int i = 0; i < 2; ++i) {
            System.out.println("Results for: " + ruleIds[i]);
            for (int j = 0; j < 4; ++j) {
                System.out.println(classifyTypes.get(j) + ": " + results[i][j]);
            }
            float precision = (float)results[i][classifyTypes.indexOf("TP")] / (float)(results[i][classifyTypes.indexOf("TP")] + results[i][classifyTypes.indexOf("FP")]);
            float recall = (float)results[i][classifyTypes.indexOf("TP")] / (float)(results[i][classifyTypes.indexOf("TP")] + results[i][classifyTypes.indexOf("FN")]);
            System.out.println("Precision: " + String.format("%.4f", Float.valueOf(precision)));
            System.out.println("Recall: " + String.format("%.4f", Float.valueOf(recall)));
        }
        float time = (float)((double)(System.currentTimeMillis() - start) / 1000.0);
        System.out.println("Total time: " + String.format("%.2f", Float.valueOf(time)) + " seconds");
    }

    private static void analyzeSentence(String correctSentence, int j, int fromPos) throws IOException {
        String wrongSentence;
        boolean isFP = false;
        boolean isFN = false;
        List matchesCorrect = lt.check(correctSentence);
        if (MissingDiacriticsEvaluator.isThereErrorAtPos(matchesCorrect, fromPos)) {
            int[] nArray = results[j];
            int n = classifyTypes.indexOf("FP");
            nArray[n] = nArray[n] + 1;
            System.out.println(ruleIds[j] + " FP: " + correctSentence);
            isFP = true;
        } else {
            int[] nArray = results[j];
            int n = classifyTypes.indexOf("TN");
            nArray[n] = nArray[n] + 1;
        }
        String replaceWith = words[1 - j];
        if (StringTools.isCapitalizedWord((String)words[j])) {
            replaceWith = StringTools.uppercaseFirstChar((String)replaceWith);
        }
        if (StringTools.isAllUppercase((String)replaceWith)) {
            replaceWith = replaceWith.toUpperCase();
        }
        if ((wrongSentence = correctSentence.substring(0, fromPos) + replaceWith + correctSentence.substring(fromPos + words[j].length(), correctSentence.length())).equals(correctSentence)) {
            System.out.println("Word cannot be replaced: " + wrongSentence);
            return;
        }
        List matchesWrong = lt.check(wrongSentence);
        if (MissingDiacriticsEvaluator.isThereErrorAtPos(matchesWrong, fromPos)) {
            int[] nArray = results[1 - j];
            int n = classifyTypes.indexOf("TP");
            nArray[n] = nArray[n] + 1;
        } else {
            int[] nArray = results[1 - j];
            int n = classifyTypes.indexOf("FN");
            nArray[n] = nArray[n] + 1;
            if (j == 0) {
                System.out.println(ruleIds[1 - j] + " FN: " + wrongSentence);
            }
            isFN = true;
        }
        if (isFP && isFN) {
            System.out.println("POSSIBLE ERROR IN CORPUS: " + correctSentence);
        }
    }

    private static boolean isThereErrorAtPos(List<RuleMatch> matches, int pos) {
        for (RuleMatch match : matches) {
            if (match.getFromPos() > pos || match.getToPos() <= pos) continue;
            return true;
        }
        return false;
    }

    private static InputStreamReader getInputStreamReader(String filename, String encoding) throws IOException {
        String charsetName = encoding != null ? encoding : Charset.defaultCharset().name();
        InputStream is = System.in;
        if (!MissingDiacriticsEvaluator.isStdIn(filename)) {
            is = new FileInputStream(new File(filename));
            BOMInputStream bomIn = new BOMInputStream(is, true, new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_32LE});
            if (bomIn.hasBOM() && encoding == null) {
                charsetName = bomIn.getBOMCharsetName();
            }
            is = bomIn;
        }
        return new InputStreamReader((InputStream)new BufferedInputStream(is), charsetName);
    }

    private static boolean isStdIn(String filename) {
        return "-".equals(filename);
    }

    private static void help() {
        System.out.println("Usage: " + MissingDiacriticsEvaluator.class.getSimpleName() + " <language code> <corpus file> <word with diacritics>");
        System.exit(1);
    }
}

