/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.eval;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.commandline.CommandLineTools;
import org.languagetool.language.English;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tools.StringTools;

public final class CheckBNC {
    private final JLanguageTool lt;
    private final BNCTextFilter textFilter = new BNCTextFilter();
    private static final boolean CHECK_BY_SENTENCE = true;

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: CheckBNC <directory>");
            System.exit(1);
        }
        CheckBNC prg = new CheckBNC();
        prg.run(new File(args[0]));
    }

    private CheckBNC() {
        this.lt = new JLanguageTool((Language)new English());
        String[] disRules = new String[]{"UPPERCASE_SENTENCE_START", "COMMA_PARENTHESIS_WHITESPACE", "WORD_REPEAT_RULE", "DOUBLE_PUNCTUATION"};
        System.err.println("Note: disabling the following rules:");
        for (String disRule : disRules) {
            this.lt.disableRule(disRule);
            System.err.println(" " + disRule);
        }
    }

    private void run(File file) throws IOException {
        if (file.isDirectory()) {
            File[] files;
            for (File file1 : files = file.listFiles()) {
                this.run(new File(file, file1.getName()));
            }
        } else {
            System.out.println("Checking " + file.getAbsolutePath());
            String text = StringTools.readStream((InputStream)new FileInputStream(file.getAbsolutePath()), (String)"utf-8");
            text = this.textFilter.filter(text);
            SentenceTokenizer sentenceTokenizer = this.lt.getLanguage().getSentenceTokenizer();
            List sentences = sentenceTokenizer.tokenize(text);
            for (String sentence : sentences) {
                CommandLineTools.checkText((String)sentence, (JLanguageTool)this.lt, (boolean)false, (int)1000);
            }
        }
    }

    static class BNCTextFilter {
        BNCTextFilter() {
        }

        public String filter(String text) {
            String fText = text.replaceAll("(?s)<header.*?>.*?</header>", "");
            fText = fText.replaceAll("<w.*?>", "");
            fText = fText.replaceAll("<c.*?>", "");
            fText = fText.replaceAll("<.*?>", "");
            fText = fText.replaceAll(" +", " ");
            fText = fText.replaceAll("&bquo|&equo", "\"");
            fText = fText.replaceAll("&mdash;?", "--");
            fText = fText.replaceAll("&amp;?", "&");
            return fText;
        }
    }
}

