/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.diff;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.dev.diff.LightRuleMatch;
import org.languagetool.dev.diff.LightRuleMatchParser;
import org.languagetool.rules.Rule;
import org.languagetool.tools.StringTools;

public class ResultToHtml {
    private static final int THRESHOLD = 0;
    private final Map<String, String> ruleIdToCategoryId = new HashMap<String, String>();
    private FileWriter fw;

    public ResultToHtml(Language lang) {
        JLanguageTool lt = new JLanguageTool(lang);
        for (Rule rule : lt.getAllRules()) {
            this.ruleIdToCategoryId.put(rule.getId(), rule.getCategory().getId().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String inputFile, String outputFile) throws IOException {
        try {
            this.fw = new FileWriter(outputFile);
            LightRuleMatchParser parser = new LightRuleMatchParser();
            List<LightRuleMatch> matches = parser.parseOutput((File)new File((String)inputFile)).result;
            matches.sort((k, v) -> {
                String catIdV;
                String catIdK = this.getCategoryId((LightRuleMatch)k);
                if (catIdK.equals(catIdV = this.getCategoryId((LightRuleMatch)v))) {
                    return k.getFullRuleId().compareTo(v.getFullRuleId());
                }
                return catIdK.compareTo(catIdV);
            });
            this.printHtml(inputFile, matches);
        }
        finally {
            this.fw.close();
        }
    }

    private void printHtml(String filename, List<LightRuleMatch> matches) throws IOException {
        this.print("<!doctype html>");
        this.print("<!-- generated by " + ResultToHtml.class.getSimpleName() + " on " + new Date() + " -->");
        this.print("<html>");
        this.print("<head>");
        this.print("  <title>Sorted " + filename + "</title>");
        this.print("  <meta http-equiv=\"content-type\" content=\"charset=utf-8\">");
        this.print("  <style>");
        this.print("    .sentence { color: #000; }");
        this.print("    .message { color: #777; }");
        this.print("    .marker { text-decoration: underline; background-color: #ffe8e8 }");
        this.print("    li { margin-bottom: 8px; }");
        this.print("  </style>");
        this.print("</head>");
        this.print("<body>");
        this.print(matches.size() + " total matches<br>");
        Map<String, Integer> matchToCount = this.getMatchToCount(matches);
        this.printToc(matches, matchToCount);
        String prevRuleId = "";
        String prevCategoryId = "";
        boolean listStarted = false;
        int skipped = 0;
        for (LightRuleMatch match : matches) {
            String categoryId = this.getCategoryId(match);
            if (!match.getFullRuleId().equals(prevRuleId)) {
                Integer count;
                if (listStarted) {
                    this.print("</ol>");
                }
                if (!categoryId.equals(prevCategoryId)) {
                    this.print("<h1>Category " + categoryId + "</h1>");
                }
                if ((count = matchToCount.get(match.getFullRuleId())) >= 0) {
                    String tempOff = match.getStatus() == LightRuleMatch.Status.temp_off ? "[temp_off]" : "";
                    this.print("<a name='" + match.getFullRuleId() + "'></a><h3>" + match.getFullRuleId() + " " + tempOff + " (" + count + " matches)</h3>");
                    this.print("Source: " + match.getRuleSource() + "<br><br>");
                    this.print("<ol>");
                    listStarted = true;
                } else {
                    ++skipped;
                }
            }
            this.print("<li>");
            this.print("  <span class='message'>" + match.getMessage() + "</span><br>");
            this.print("  <span class='sentence'>" + StringTools.escapeHTML((String)match.getContext()).replaceFirst("&lt;span class='marker'&gt;", "<span class='marker'>").replaceFirst("&lt;/span&gt;", "</span>") + "</span><br>");
            this.print("</li>");
            prevRuleId = match.getFullRuleId();
            prevCategoryId = categoryId;
        }
        this.print("</ol>");
        this.print("Note: " + skipped + " rules have been skipped because they matched fewer than 0 times");
        this.print("</body>");
        this.print("</html>");
    }

    @NotNull
    private String getCategoryId(LightRuleMatch match) {
        String categoryId = this.ruleIdToCategoryId.get(match.getRuleId());
        if (categoryId == null) {
            categoryId = "unknown";
        }
        return categoryId;
    }

    private void printToc(List<LightRuleMatch> matches, Map<String, Integer> matchToCount) throws IOException {
        String prevRuleId = "";
        String prevCategoryId = "";
        this.print("<h1>TOC</h1>");
        HashMap<String, Integer> rulesInCategory = new HashMap<String, Integer>();
        for (LightRuleMatch match : matches) {
            String ruleId = match.getFullRuleId();
            String categoryId = this.getCategoryId(match);
            if (!ruleId.equals(prevRuleId)) {
                Integer count;
                if (!categoryId.equals(prevCategoryId)) {
                    this.printRulesInCategory(rulesInCategory);
                    rulesInCategory.clear();
                    this.print("<h3>Category " + categoryId + "</h3>");
                }
                if ((count = matchToCount.get(ruleId)) >= 0) {
                    rulesInCategory.put(ruleId, count);
                }
            }
            prevRuleId = ruleId;
            prevCategoryId = categoryId;
        }
        this.printRulesInCategory(rulesInCategory);
        this.print("<br>");
    }

    private void printRulesInCategory(Map<String, Integer> rulesInCategory) throws IOException {
        if (rulesInCategory.size() > 0) {
            Map sorted = rulesInCategory.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
            for (Map.Entry entry : sorted.entrySet()) {
                this.print("<a href='#" + (String)entry.getKey() + "'>" + (String)entry.getKey() + " (" + entry.getValue() + ")</a><br>");
            }
        }
    }

    private Map<String, Integer> getMatchToCount(List<LightRuleMatch> matches) {
        HashMap<String, Integer> catToCount = new HashMap<String, Integer>();
        for (LightRuleMatch match : matches) {
            String id = match.getFullRuleId();
            if (catToCount.containsKey(id)) {
                catToCount.put(id, (Integer)catToCount.get(id) + 1);
                continue;
            }
            catToCount.put(id, 1);
        }
        return catToCount;
    }

    private void print(String s) throws IOException {
        this.fw.write(s);
        this.fw.write(10);
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.out.println("Usage: " + ResultToHtml.class.getSimpleName() + " <langCode> <plainTextResult> <outputFile>");
            System.out.println("  <plainTextResult> is the result of e.g. Main or SentenceSourceChecker");
            System.exit(1);
        }
        ResultToHtml prg = new ResultToHtml(Languages.getLanguageForShortCode((String)args[0]));
        prg.run(args[1], args[2]);
    }
}

