/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.bigdata;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.SimpleFSDirectory;

public class LuceneIndexExporter {
    private static final String FIELD_NAME = "fieldLowercase";

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Usage: " + LuceneIndexExporter.class.getSimpleName() + " <luceneIndexDir>");
            System.exit(1);
        }
        System.out.println("Using field: fieldLowercase");
        FSDirectory directory = SimpleFSDirectory.open((Path)Paths.get(args[0], new String[0]));
        try (DirectoryReader indexReader = DirectoryReader.open((Directory)directory);){
            for (int i = 0; i < indexReader.maxDoc(); ++i) {
                Document doc = indexReader.document(i);
                System.out.println(doc.get(FIELD_NAME));
            }
        }
    }
}

