/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.bigdata;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;

final class LargestNGramFinder {
    private LargestNGramFinder() {
    }

    public static void main(String[] args) throws IOException {
        BytesRef next;
        if (args.length != 1) {
            System.out.println("Usage: " + LargestNGramFinder.class.getSimpleName() + " <ngramIndexDir>");
            System.exit(1);
        }
        FSDirectory fsDir = FSDirectory.open((Path)new File(args[0]).toPath());
        DirectoryReader reader = DirectoryReader.open((Directory)fsDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        Fields fields = MultiFields.getFields((IndexReader)reader);
        long max = 0L;
        String maxTerm = "";
        Terms terms = fields.terms("ngram");
        TermsEnum termsEnum = terms.iterator();
        int count = 0;
        while ((next = termsEnum.next()) != null) {
            String term = next.utf8ToString();
            TopDocs topDocs = searcher.search((Query)new TermQuery(new Term("ngram", term)), 5);
            int docId = topDocs.scoreDocs[0].doc;
            Document document = reader.document(docId);
            long thisCount = Long.parseLong(document.get("count"));
            if (max < thisCount) {
                max = thisCount;
                maxTerm = term;
            }
            if (count % 10000 == 0) {
                System.out.println(count + " -> " + topDocs.totalHits + " for " + term + " -> " + thisCount + ", max so far: " + max + " for '" + maxTerm + "'");
            }
            ++count;
        }
        System.out.println("Max: " + max + " for " + maxTerm);
    }
}

