/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.bigdata;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Languages;
import org.languagetool.tools.StringTools;

final class GermanUppercasePhraseFinder {
    private static final long MIN_TERM_LEN = 4L;
    private static final long LIMIT = 500L;

    private GermanUppercasePhraseFinder() {
    }

    public static void main(String[] args) throws IOException {
        BytesRef next;
        if (args.length != 1) {
            System.out.println("Usage: " + GermanUppercasePhraseFinder.class.getSimpleName() + " <ngramIndexDir>");
            System.exit(1);
        }
        JLanguageTool lt = new JLanguageTool(Languages.getLanguageForShortCode((String)"de"));
        FSDirectory fsDir = FSDirectory.open((Path)new File(args[0]).toPath());
        DirectoryReader reader = DirectoryReader.open((Directory)fsDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        Fields fields = MultiFields.getFields((IndexReader)reader);
        Terms terms = fields.terms("ngram");
        TermsEnum termsEnum = terms.iterator();
        int count = 0;
        while ((next = termsEnum.next()) != null) {
            String uppercase;
            String term = next.utf8ToString();
            ++count;
            String[] parts = term.split(" ");
            boolean useful = true;
            int lcCount = 0;
            ArrayList<String> ucParts = new ArrayList<String>();
            for (String part : parts) {
                if ((long)part.length() < 4L) {
                    useful = false;
                    break;
                }
                String uc = StringTools.uppercaseFirstChar((String)part);
                if (!part.equals(uc)) {
                    ++lcCount;
                }
                ucParts.add(uc);
            }
            if (!useful || lcCount == 0 || lcCount == 2 || term.equals(uppercase = String.join((CharSequence)" ", ucParts))) continue;
            long thisCount = GermanUppercasePhraseFinder.getOccurrenceCount((IndexReader)reader, searcher, term);
            long thisUpperCount = GermanUppercasePhraseFinder.getOccurrenceCount((IndexReader)reader, searcher, uppercase);
            if (count % 10000 == 0) {
                System.err.println(count + " @ " + term);
            }
            if (thisCount <= 500L && thisUpperCount <= 500L || thisUpperCount <= thisCount || !GermanUppercasePhraseFinder.isRelevant(lt, term)) continue;
            float factor = (float)thisUpperCount / (float)thisCount;
            System.out.printf("%.2f " + thisUpperCount + " " + uppercase + " " + thisCount + " " + term + "\n", Float.valueOf(factor));
        }
    }

    private static boolean isRelevant(JLanguageTool lt, String term) throws IOException {
        AnalyzedSentence analyzedSentence = (AnalyzedSentence)lt.analyzeText(term).get(0);
        AnalyzedTokenReadings[] tokens = analyzedSentence.getTokensWithoutWhitespace();
        return tokens.length == 3 && tokens[1].hasPartialPosTag("ADJ:") && tokens[2].hasPartialPosTag("SUB:");
    }

    private static long getOccurrenceCount(IndexReader reader, IndexSearcher searcher, String term) throws IOException {
        TopDocs topDocs = searcher.search((Query)new TermQuery(new Term("ngram", term)), 5);
        if (topDocs.totalHits == 0) {
            return 0L;
        }
        int docId = topDocs.scoreDocs[0].doc;
        Document document = reader.document(docId);
        return Long.parseLong(document.get("count"));
    }
}

