/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.bigdata;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;

class GermanSpellingReformGuesser {
    GermanSpellingReformGuesser() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Usage: " + GermanSpellingReformGuesser.class.getSimpleName() + " <lemmaList>");
            System.exit(1);
        }
        new GermanSpellingReformGuesser().run(args[0]);
    }

    private void run(String lemmaFile) throws IOException {
        List<String> lines = Files.readAllLines(Paths.get(lemmaFile, new String[0]));
        HashSet<String> lemmas = new HashSet<String>(lines);
        HashSet<CallSite> result = new HashSet<CallSite>();
        for (String string : lines) {
            String newSpelling1;
            String oldSpelling1 = string.replace("ss", "\u00df");
            String oldSpelling2 = string.replace("f", "ph");
            if (!oldSpelling2.equals(string) && lemmas.contains(oldSpelling2)) {
                result.add((CallSite)((Object)(string + ";" + oldSpelling2)));
            }
            if ((newSpelling1 = string.replace("ph", "f")).equals(string) || !lemmas.contains(newSpelling1)) continue;
            result.add((CallSite)((Object)(newSpelling1 + ";" + string)));
        }
        for (String string : result) {
            System.out.println(string);
        }
        System.err.println(result.size() + " Paare gefunden");
    }
}

