/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.bigdata;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.languagetool.languagemodel.LuceneLanguageModel;

final class GermanAuxVerbGuesser2 {
    private GermanAuxVerbGuesser2() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Usage: " + GermanAuxVerbGuesser2.class.getName() + " <ngramDataIndex> <lemmaFile>");
            System.out.println("   <lemmaFile> is a text file with 'participle2 \\t lemma' per line, e.g. 'getrunken \t trinken'");
            System.exit(1);
        }
        String indexTopDir = args[0];
        List<String> lines = Files.readAllLines(Paths.get(args[1], new String[0]));
        System.out.println("# factor lemma Dativ/mir Akkusativ/mich");
        try (LuceneLanguageModel lm = new LuceneLanguageModel(new File(indexTopDir));){
            for (String line : lines) {
                String pa2 = line.split("\t")[0];
                String lemma = line.split("\t")[1];
                long mir = GermanAuxVerbGuesser2.count(lm, pa2, lemma, "mir");
                long mich = GermanAuxVerbGuesser2.count(lm, pa2, lemma, "mich");
                long dir = GermanAuxVerbGuesser2.count(lm, pa2, lemma, "dir");
                long dich = GermanAuxVerbGuesser2.count(lm, pa2, lemma, "dich");
                float factor = ((float)mir + (float)dir) / ((float)mich + (float)dich);
                System.out.println(factor + " " + lemma + " " + mir + " " + mich);
            }
        }
    }

    private static long count(LuceneLanguageModel lm, String pa2, String lemma, String reflexivePronoun) {
        return lm.getCount(Arrays.asList(reflexivePronoun, pa2)) + lm.getCount(Arrays.asList(reflexivePronoun, lemma));
    }
}

