/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.bigdata;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.languagetool.languagemodel.LuceneLanguageModel;

final class GermanAuxVerbGuesser {
    private GermanAuxVerbGuesser() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Usage: " + GermanAuxVerbGuesser.class.getName() + " <ngramDataIndex> <lemmaFile>");
            System.out.println("   <lemmaFile> is a text file with 'participle2 \\t lemma' per line, e.g. 'getrunken \t trinken'");
            System.exit(1);
        }
        String indexTopDir = args[0];
        List<String> lines = Files.readAllLines(Paths.get(args[1], new String[0]));
        int match = 0;
        int noMatch = 0;
        int unambiguous = 0;
        try (LuceneLanguageModel lm = new LuceneLanguageModel(new File(indexTopDir));){
            for (String line : lines) {
                if (line.startsWith("#")) continue;
                String pa2 = line.split("\t")[0];
                String lemma = line.split("\t")[1];
                long haben = GermanAuxVerbGuesser.countHaben(lm, pa2);
                long sein = GermanAuxVerbGuesser.countSein(lm, pa2);
                float ratio = (float)haben / (float)sein;
                System.out.printf(Locale.ENGLISH, "%.2f " + lemma + ": haben: " + haben + ", sein: " + sein + "\n", Float.valueOf(ratio));
                if (haben == 0L && sein == 0L) {
                    ++noMatch;
                    continue;
                }
                if (haben == 0L && sein > 0L || haben > 0L && sein == 0L) {
                    ++unambiguous;
                }
                ++match;
            }
        }
        System.out.println("match: " + match);
        System.out.println("noMatch: " + noMatch);
        System.out.println("----");
        System.out.println("unambiguous: " + unambiguous);
    }

    private static long countHaben(LuceneLanguageModel lm, String pa2) {
        return GermanAuxVerbGuesser.count(lm, pa2, "habe") + GermanAuxVerbGuesser.count(lm, pa2, "hast") + GermanAuxVerbGuesser.count(lm, pa2, "hat") + GermanAuxVerbGuesser.count(lm, pa2, "habt") + GermanAuxVerbGuesser.count(lm, pa2, "haben") + GermanAuxVerbGuesser.count(lm, pa2, "hatte") + GermanAuxVerbGuesser.count(lm, pa2, "hattest") + GermanAuxVerbGuesser.count(lm, pa2, "hatte") + GermanAuxVerbGuesser.count(lm, pa2, "hatten") + GermanAuxVerbGuesser.count(lm, pa2, "hattet") + GermanAuxVerbGuesser.count2(lm, pa2, "werde", "haben") + GermanAuxVerbGuesser.count2(lm, pa2, "wirst", "haben") + GermanAuxVerbGuesser.count2(lm, pa2, "wird", "haben") + GermanAuxVerbGuesser.count2(lm, pa2, "werden", "haben") + GermanAuxVerbGuesser.count2(lm, pa2, "werdet", "haben");
    }

    private static long countSein(LuceneLanguageModel lm, String pa2) {
        return GermanAuxVerbGuesser.count(lm, pa2, "bin") + GermanAuxVerbGuesser.count(lm, pa2, "bist") + GermanAuxVerbGuesser.count(lm, pa2, "ist") + GermanAuxVerbGuesser.count(lm, pa2, "sind") + GermanAuxVerbGuesser.count(lm, pa2, "seid") + GermanAuxVerbGuesser.count(lm, pa2, "war") + GermanAuxVerbGuesser.count(lm, pa2, "warst") + GermanAuxVerbGuesser.count(lm, pa2, "war") + GermanAuxVerbGuesser.count(lm, pa2, "waren") + GermanAuxVerbGuesser.count(lm, pa2, "wart") + GermanAuxVerbGuesser.count2(lm, pa2, "werde", "sein") + GermanAuxVerbGuesser.count2(lm, pa2, "wirst", "sein") + GermanAuxVerbGuesser.count2(lm, pa2, "wird", "sein") + GermanAuxVerbGuesser.count2(lm, pa2, "werden", "sein") + GermanAuxVerbGuesser.count2(lm, pa2, "werdet", "sein");
    }

    private static long count(LuceneLanguageModel lm, String pa2, String verb) {
        long count = lm.getCount(Arrays.asList(verb, pa2));
        if (count > 0L) {
            System.out.println(verb + " " + pa2 + ": " + count);
        }
        return count;
    }

    private static long count2(LuceneLanguageModel lm, String pa2, String werde, String sein) {
        long count = lm.getCount(Arrays.asList(werde, pa2, sein));
        if (count > 0L) {
            System.out.println(werde + " " + pa2 + " " + sein + ": " + count);
        }
        return count;
    }
}

