/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.bigdata;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ConfusionFileIndenter {
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Usage: " + ConfusionFileIndenter.class.getSimpleName() + " <file>");
            System.exit(1);
        }
        List<String> lines = Files.readAllLines(Paths.get(args[0], new String[0]));
        System.out.println(ConfusionFileIndenter.indent(lines));
    }

    static String indent(List<String> lines) {
        StringBuilder indentedLines = new StringBuilder();
        HashSet<CallSite> alreadyDone = new HashSet<CallSite>();
        for (String line : lines) {
            int commentPos;
            if (!line.startsWith("#") && !line.isEmpty()) {
                String[] parts = line.replaceFirst("\\s*#.*", "").split(";\\s*");
                String key = parts[0] + ";" + parts[1];
                if (alreadyDone.contains(key)) continue;
                alreadyDone.add((CallSite)((Object)key));
            }
            if ((commentPos = line.lastIndexOf(35)) <= 0) {
                indentedLines.append(line).append('\n');
                continue;
            }
            int endData = commentPos;
            while (Character.isWhitespace(line.charAt(endData - 1))) {
                --endData;
            }
            String spaces = StringUtils.repeat((String)" ", (int)Math.max(1, 82 - endData));
            indentedLines.append(line, 0, endData).append(spaces).append(line.substring(commentPos)).append('\n');
        }
        return indentedLines.toString();
    }
}

