/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.bigdata;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.dev.bigdata.ConfusionRuleEvaluator;
import org.languagetool.dev.bigdata.RuleEvalResult;
import org.languagetool.dev.eval.FMeasure;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.languagemodel.LuceneLanguageModel;
import org.languagetool.rules.ConfusionPair;
import org.languagetool.rules.ConfusionSetLoader;
import org.languagetool.rules.ConfusionString;

final class AllConfusionRulesEvaluator {
    private static final int MAX_SENTENCES = 1000;

    private AllConfusionRulesEvaluator() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 3 || args.length > 4) {
            System.err.println("Usage: " + AllConfusionRulesEvaluator.class.getSimpleName() + " <langCode> <languageModelTopDir> <wikipediaXml|tatoebaFile|dir>...");
            System.err.println("   <languageModelTopDir> is a directory with sub-directories '1grams', '2grams', and '3grams' with Lucene indexes");
            System.err.println("   <wikipediaXml|tatoebaFile|dir> either a Wikipedia XML dump, or a Tatoeba file or");
            System.err.println("                      a directory with example sentences (where <word>.txt contains only the sentences for <word>).");
            System.err.println("                      You can specify both a Wikipedia file and a Tatoeba file.");
            System.exit(1);
        }
        ConfusionRuleEvaluator.EnglishLight lang = "en".equals(args[0]) ? new ConfusionRuleEvaluator.EnglishLight() : Languages.getLanguageForShortCode((String)args[0]);
        LuceneLanguageModel languageModel = new LuceneLanguageModel(new File(args[1]));
        ArrayList<String> inputsFiles = new ArrayList<String>();
        inputsFiles.add(args[2]);
        if (args.length >= 4) {
            inputsFiles.add(args[3]);
        }
        ConfusionRuleEvaluator eval = new ConfusionRuleEvaluator((Language)lang, (LanguageModel)languageModel, false, true);
        eval.setVerboseMode(false);
        ConfusionSetLoader confusionSetLoader = new ConfusionSetLoader((Language)lang);
        InputStream inputStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream("/" + lang.getShortCode() + "/confusion_sets.txt");
        Map confusionSetMap = confusionSetLoader.loadConfusionPairs(inputStream);
        HashSet<CallSite> done = new HashSet<CallSite>();
        int fMeasureCount = 0;
        float fMeasureTotal = 0.0f;
        for (List entry : confusionSetMap.values()) {
            for (ConfusionPair confusionPair : entry) {
                String word2;
                List set = confusionPair.getTerms();
                if (set.size() != 2) {
                    System.out.println("Skipping confusion set with size != 2: " + confusionPair);
                    continue;
                }
                Iterator iterator = set.iterator();
                ConfusionString set1 = (ConfusionString)iterator.next();
                ConfusionString set2 = (ConfusionString)iterator.next();
                String word1 = set1.getString();
                String key = word1 + " " + (word2 = set2.getString());
                if (!done.contains(key)) {
                    Map<Long, RuleEvalResult> evalResults = eval.run(inputsFiles, word1, word2, 1000, Arrays.asList(confusionPair.getFactor()), Collections.emptyMap(), Collections.emptyMap());
                    RuleEvalResult evalResult = evalResults.values().iterator().next();
                    String summary1 = set1.getDescription() != null ? word1 + "|" + set1.getDescription() : word1;
                    String summary2 = set2.getDescription() != null ? word2 + "|" + set2.getDescription() : word2;
                    String start = summary1.compareTo(summary2) < 0 ? summary1 + "; " + summary2 + "; " + confusionPair.getFactor() : summary2 + "; " + summary1 + "; " + confusionPair.getFactor();
                    String spaces = StringUtils.repeat((String)" ", (int)(82 - start.length()));
                    System.out.println(start + spaces + "# " + evalResult.getSummary());
                    double fMeasure = FMeasure.getWeightedFMeasure(evalResult.getPrecision(), evalResult.getRecall());
                    ++fMeasureCount;
                    fMeasureTotal = (float)((double)fMeasureTotal + fMeasure);
                }
                done.add((CallSite)((Object)key));
            }
        }
        System.out.println("Average f-measure: " + fMeasureTotal / (float)fMeasureCount);
    }
}

