/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.archive;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;

public final class POSTagLanguageModel {
    public static void main(String[] args) throws IOException {
        if (args.length == 1) {
            Language language = POSTagLanguageModel.getLanguageOrExit(args[0]);
            JLanguageTool lt = new JLanguageTool(language, null);
            POSTagLanguageModel.runOnStdIn(lt);
        } else {
            POSTagLanguageModel.exitWithUsageMessage();
        }
    }

    private static Language getLanguageOrExit(String lang) {
        Language language = null;
        boolean foundLanguage = false;
        ArrayList<String> supportedLanguages = new ArrayList<String>();
        for (Language tmpLang : Languages.get()) {
            supportedLanguages.add(tmpLang.getShortCode());
            if (!lang.equals(tmpLang.getShortCode())) continue;
            language = tmpLang;
            foundLanguage = true;
            break;
        }
        if (!foundLanguage) {
            System.out.println("Unknown language '" + lang + "'. Supported languages are: " + supportedLanguages);
            POSTagLanguageModel.exitWithUsageMessage();
        }
        return language;
    }

    private static void exitWithUsageMessage() {
        System.out.println("Usage: java org.languagetool.dev.archive.POSTagLanguageModel <language>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runOnStdIn(JLanguageTool lt) throws IOException {
        int MAX_FILE_SIZE = 64000;
        InputStreamReader isr = null;
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            isr = new InputStreamReader(new BufferedInputStream(System.in));
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
                if (lt.getLanguage().getSentenceTokenizer().singleLineBreaksMarksPara()) {
                    POSTagLanguageModel.tagText(sb.toString(), lt);
                    sb = new StringBuilder();
                    continue;
                }
                if (!"".equals(line) && sb.length() < 64000) continue;
                POSTagLanguageModel.tagText(sb.toString(), lt);
                sb = new StringBuilder();
            }
        }
        finally {
            if (sb.length() > 0) {
                POSTagLanguageModel.tagText(sb.toString(), lt);
            }
        }
        br.close();
        isr.close();
    }

    private static void tagText(String contents, JLanguageTool lt) throws IOException {
        List sentences = lt.sentenceTokenize(contents);
        for (String sentence : sentences) {
            AnalyzedSentence analyzedText = lt.getAnalyzedSentence(sentence);
            System.out.println(POSTagLanguageModel.getSentence(analyzedText));
        }
    }

    private static String getSentence(AnalyzedSentence sent) {
        StringBuilder sb = new StringBuilder();
        sb.append("<S>");
        for (AnalyzedTokenReadings atr : sent.getTokensWithoutWhitespace()) {
            sb.append(POSTagLanguageModel.getPOS(atr));
            sb.append(' ');
        }
        sb.append("</S>");
        return sb.toString();
    }

    private static String getPOS(AnalyzedTokenReadings atr) {
        StringBuilder sb = new StringBuilder();
        int readNum = atr.getReadingsLength();
        for (int i = 0; i < readNum; ++i) {
            if (atr.isWhitespace()) continue;
            sb.append(atr.getAnalyzedToken(i).getPOSTag());
            if (i == readNum - 1) continue;
            sb.append('+');
        }
        return sb.toString();
    }
}

