/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.archive;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternRule;

final class ExampleSentenceCorrectionCreator {
    private int addedCorrectionsCount = 0;

    ExampleSentenceCorrectionCreator() {
    }

    private void run(Language lang) throws IOException {
        File basePath = new File("/lt/git/languagetool/languagetool-language-modules");
        if (!basePath.exists()) {
            throw new RuntimeException("basePath does not exist: " + basePath);
        }
        String langCode = lang.getShortCode();
        File xml = new File(basePath, "/" + langCode + "/src/main/resources/org/languagetool/rules/" + langCode + "/grammar.xml");
        List xmlLines = IOUtils.readLines((Reader)new FileReader(xml));
        JLanguageTool tool = new JLanguageTool(lang);
        for (Rule rule : tool.getAllRules()) {
            if (!(rule instanceof PatternRule)) continue;
            List incorrectExamples = rule.getIncorrectExamples();
            for (IncorrectExample incorrectExample : incorrectExamples) {
                this.checkCorrections(rule, incorrectExample, xmlLines, tool);
            }
        }
        System.err.println("Added corrections: " + this.addedCorrectionsCount);
        for (String xmlLine : xmlLines) {
            System.out.println(xmlLine);
        }
    }

    private void checkCorrections(Rule rule, IncorrectExample incorrectExample, List<String> xmlLines, JLanguageTool tool) throws IOException {
        List corrections = incorrectExample.getCorrections();
        if (corrections.isEmpty()) {
            for (Rule r : tool.getAllActiveRules()) {
                tool.disableRule(r.getId());
            }
            tool.enableRule(rule.getId());
            String incorrectSentence = incorrectExample.getExample().replaceAll("</?marker>", "");
            List matches = tool.check(incorrectSentence);
            System.err.println("no corrections: " + rule.getId() + ", " + matches.size() + " matches");
            if (matches.isEmpty()) {
                throw new RuntimeException("Got no rule match: " + incorrectSentence);
            }
            List suggestedReplacements = ((RuleMatch)matches.get(0)).getSuggestedReplacements();
            String newAttribute = "correction=\"" + String.join((CharSequence)"|", suggestedReplacements) + "\"";
            this.addAttribute(rule, newAttribute, xmlLines);
        }
    }

    private void addAttribute(Rule rule, String newAttribute, List<String> xmlLines) {
        ArrayList<Integer> linesToModify = new ArrayList<Integer>();
        String currentRuleId = null;
        Pattern pattern = Pattern.compile(".*id=[\"'](.*?)[\"'].*");
        String expectedSubId = ((AbstractPatternRule)rule).getSubId();
        int lineCount = 0;
        int subRuleCount = 0;
        int modifyCount = 0;
        boolean inRuleGroup = false;
        for (String xmlLine : xmlLines) {
            if (xmlLine.contains("<rulegroup")) {
                subRuleCount = 0;
                inRuleGroup = true;
            } else if (xmlLine.contains("</rulegroup>")) {
                subRuleCount = 0;
                inRuleGroup = false;
            } else if ((xmlLine.contains("<rule ") || xmlLine.contains("<rule>")) && inRuleGroup) {
                ++subRuleCount;
            }
            Matcher m = pattern.matcher(xmlLine);
            if (m.matches()) {
                currentRuleId = m.group(1);
            }
            if (xmlLine.contains("type=\"incorrect\"") || xmlLine.contains("type='incorrect'")) {
                if (currentRuleId != null && !currentRuleId.equals(rule.getId())) {
                    ++lineCount;
                    continue;
                }
                if (!inRuleGroup) {
                    subRuleCount = 1;
                }
                if (!expectedSubId.equals("0") && !expectedSubId.equals(String.valueOf(subRuleCount))) {
                    ++lineCount;
                    continue;
                }
                linesToModify.add(lineCount);
                break;
            }
            ++lineCount;
        }
        for (Integer s : linesToModify) {
            String newLine = xmlLines.get(s).replaceFirst("type=[\"']incorrect[\"']", newAttribute);
            xmlLines.set(s, newLine);
            ++this.addedCorrectionsCount;
            ++modifyCount;
        }
        if (modifyCount == 0) {
            System.err.println("No line modified: " + rule + "[" + expectedSubId + "]");
        }
    }

    public static void main(String[] args) throws IOException {
        ExampleSentenceCorrectionCreator prg = new ExampleSentenceCorrectionCreator();
        prg.run(Languages.getLanguageForShortCode((String)"de"));
    }
}

