/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.Rule;

public class RuleDetails {
    private final List<Rule> rules;

    public RuleDetails(Language lang, @Nullable String ngramPath) throws IOException {
        JLanguageTool lt = new JLanguageTool(lang);
        if (ngramPath != null) {
            lt.activateLanguageModelRules(new File(ngramPath));
        }
        this.rules = lt.getAllRules();
    }

    @Nullable
    private Rule getRuleById(String ruleId) {
        return this.rules.stream().filter(r -> r.getId().equals(ruleId)).findFirst().orElse(null);
    }

    public static void main(String[] args) throws ParseException, IOException {
        Options options = new Options();
        options.addRequiredOption("l", "language", true, "Language for rules");
        options.addRequiredOption("f", "file", true, "Input file");
        options.addRequiredOption("o", "output", true, "Output file");
        options.addRequiredOption("c", "column", true, "Column in input file");
        options.addOption("n", "ngramPath", true, "Ngram path to activate ngram rules");
        CommandLine cmd = new DefaultParser().parse(options, args);
        String langCode = cmd.getOptionValue('l');
        String inputFile = cmd.getOptionValue('f');
        String outputFile = cmd.getOptionValue('o');
        String column = cmd.getOptionValue('c');
        String ngramPath = cmd.hasOption('n') ? cmd.getOptionValue('n') : null;
        RuleDetails details = new RuleDetails(Languages.getLanguageForShortCode((String)langCode), ngramPath);
        CSVFormat format = CSVFormat.RFC4180.withFirstRecordAsHeader();
        try (CSVParser parser = CSVParser.parse((File)new File(inputFile), (Charset)Charset.defaultCharset(), (CSVFormat)format);
             CSVPrinter printer = new CSVPrinter((Appendable)new BufferedWriter(new FileWriter(outputFile)), format);){
            Map oldHeader = parser.getHeaderMap();
            ArrayList<Object> newHeader = new ArrayList<Object>(Collections.nCopies(oldHeader.size(), null));
            for (Map.Entry entry : oldHeader.entrySet()) {
                newHeader.set((Integer)entry.getValue(), ((String)entry.getKey()));
            }
            newHeader.add("description");
            newHeader.add("category");
            printer.printRecord(newHeader);
            if (!oldHeader.containsKey(column)) {
                throw new RuntimeException("Input file does not contain specified column " + column);
            }
            List records = parser.getRecords();
            ((Stream)records.stream().sequential()).map(record -> {
                String ruleId = record.get(column);
                Rule rule = details.getRuleById(ruleId);
                ArrayList<String> transformedValues = new ArrayList<String>();
                record.iterator().forEachRemaining(transformedValues::add);
                if (rule == null) {
                    transformedValues.add("");
                    transformedValues.add("");
                } else {
                    transformedValues.add(rule.getDescription());
                    transformedValues.add(rule.getCategory().getId().toString());
                }
                return transformedValues;
            }).forEachOrdered(values -> {
                try {
                    printer.printRecord((Iterable)values);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }
}

