/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Scanner;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.tools.StringTools;

final class RuleActivityOverview {
    private static final int PAST_DAYS = 182;

    RuleActivityOverview() {
    }

    private void run() {
        System.out.println("Commits per language in the last 182 days");
        System.out.println("Date: " + new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        ArrayList<String> sortedLanguages = new ArrayList<String>();
        for (Language element : Languages.get()) {
            sortedLanguages.add(element.getName());
        }
        Collections.sort(sortedLanguages);
        for (String langName : sortedLanguages) {
            Language lang = Languages.getLanguageForName((String)langName);
            int commits = this.getActivityFor(lang, 182);
            System.out.println(commits + "\t" + lang.getName() + (lang.isVariant() ? " (including the parent language)" : ""));
        }
    }

    int getActivityFor(Language lang, int pastDays) {
        try {
            Calendar past = GregorianCalendar.getInstance();
            past.add(5, -pastDays);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String pastString = dateFormat.format(past.getTime());
            String langCode = lang.getShortCode();
            List<File> xmlFiles = this.getAllXmlFiles(lang, langCode);
            int commits = 0;
            for (File file : xmlFiles) {
                if (!file.getName().contains("-test-") && !file.exists()) {
                    throw new RuntimeException("Not found: " + file);
                }
                String command = "git log --after=" + pastString + " " + file;
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec(command);
                InputStream inputStream = process.getInputStream();
                String output = StringTools.readStream((InputStream)inputStream, (String)"utf-8");
                process.waitFor();
                commits += this.getCommits(output);
            }
            return commits;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<File> getAllXmlFiles(Language lang, String langCode) {
        ArrayList<File> files = new ArrayList<File>();
        List ruleFileNames = lang.getRuleFileNames();
        for (String ruleFileName : ruleFileNames) {
            files.add(new File("../languagetool-language-modules/" + langCode + "/src/main/resources/" + ruleFileName));
        }
        File disambiguationFile = new File("../languagetool-language-modules/" + langCode + "/src/main/resources/org/languagetool/resource/" + langCode + "/disambiguation.xml");
        if (disambiguationFile.exists()) {
            files.add(disambiguationFile);
        }
        return files;
    }

    private int getCommits(String svnOutput) {
        int count = 0;
        try (Scanner scanner = new Scanner(svnOutput);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!line.startsWith("commit ")) continue;
                ++count;
            }
        }
        return count;
    }

    public static void main(String[] args) throws Exception {
        RuleActivityOverview prg = new RuleActivityOverview();
        prg.run();
    }
}

