/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.tools.StringTools;

public class RegexExpander {
    private static final List<String> entities = Arrays.asList("       <!ENTITY conjuncoes_coordenativas \"(?:e(?:nt\u00e3o|ntretanto)?|p(?:ois|or\u00e9m|or(?:t|qu)anto)|mas|ou|nem|contudo|logo|todavia)\">");
    private static final String wordListFile = "/home/dnaber/lt/pt-words.txt";
    private static final Set<String> printed = new HashSet<String>();

    public static void main(String[] args) throws IOException {
        List<String> lines = Files.readAllLines(Paths.get(wordListFile, new String[0]));
        for (String s : entities) {
            Matcher matcher = Pattern.compile("<!ENTITY (.*?) ").matcher(s);
            boolean found = matcher.find();
            if (!found) {
                System.out.println("Entity name not found: " + s);
            }
            String entityName = matcher.group(1);
            s = s.replaceFirst("<!ENTITY .*? \"(.*)\">", "$1").trim();
            System.out.print("<!ENTITY " + entityName + " \"");
            Pattern p = Pattern.compile(s);
            int i = 0;
            for (String line : lines) {
                line = line.trim();
                boolean lcMatch = false;
                boolean ucMatch = false;
                if (p.matcher(line).matches()) {
                    lcMatch = true;
                }
                if (StringTools.startsWithLowercase((String)line) && p.matcher(StringTools.uppercaseFirstChar((String)line)).matches()) {
                    ucMatch = true;
                }
                if (lcMatch && ucMatch) {
                    RegexExpander.printToken(i, "[" + StringTools.uppercaseFirstChar((String)line).charAt(0) + StringTools.lowercaseFirstChar((String)line).charAt(0) + "]" + line.substring(1));
                    ++i;
                    continue;
                }
                if (lcMatch && !printed.contains(line)) {
                    RegexExpander.printToken(i, line);
                    ++i;
                    continue;
                }
                if (!ucMatch || printed.contains(StringTools.uppercaseFirstChar((String)line))) continue;
                RegexExpander.printToken(i, StringTools.uppercaseFirstChar((String)line));
                ++i;
            }
            System.out.println("\">");
        }
    }

    private static void printToken(int i, String s) {
        if (i == 0) {
            System.out.print(s);
        } else {
            System.out.print("|" + s);
        }
        printed.add(s);
    }
}

