/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.ru.RussianTagger;

public class MissingRussianPosFinder {
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Usage: " + MissingRussianPosFinder.class.getSimpleName() + " <file> ");
            System.exit(1);
        }
        List<String> lines = Files.readAllLines(Paths.get(args[0], new String[0]));
        RussianTagger tagger = new RussianTagger();
        for (String word : lines) {
            int origCount = -1;
            if (word.matches("\\d+ .*")) {
                String[] parts = word.split(" ");
                origCount = Integer.parseInt(parts[0]);
                word = parts[1];
            }
            if ((word = word.trim()).endsWith(".")) {
                word = word.substring(0, word.length() - 1);
            }
            List matches = tagger.tag(Collections.singletonList(word));
            List lcMatches = tagger.tag(Collections.singletonList(word.toLowerCase()));
            if (matches.size() != 1 || !MissingRussianPosFinder.noTag((AnalyzedTokenReadings)matches.get(0)) || lcMatches.size() != 1 || !MissingRussianPosFinder.noTag((AnalyzedTokenReadings)lcMatches.get(0))) continue;
            System.out.println(word);
        }
    }

    private static boolean noTag(AnalyzedTokenReadings atr) {
        return !atr.isTagged();
    }
}

