/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

final class EmptyLuceneIndexCreator {
    private EmptyLuceneIndexCreator() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Usage: " + EmptyLuceneIndexCreator.class.getSimpleName() + " <indexPath>");
            System.exit(1);
        }
        StandardAnalyzer analyzer = new StandardAnalyzer();
        IndexWriterConfig config = new IndexWriterConfig((Analyzer)analyzer);
        FSDirectory directory = FSDirectory.open((Path)new File(args[0]).toPath());
        try (IndexWriter writer = new IndexWriter((Directory)directory, config);){
            FieldType fieldType = new FieldType();
            fieldType.setIndexOptions(IndexOptions.DOCS);
            fieldType.setStored(true);
            Field countField = new Field("totalTokenCount", String.valueOf(0), fieldType);
            Document doc = new Document();
            doc.add((IndexableField)countField);
            writer.addDocument((Iterable)doc);
        }
    }
}

