/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.uk.CaseGovernmentHelper;
import org.languagetool.rules.uk.InflectionHelper;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.rules.uk.TokenAgreementAdjNounRule;
import org.languagetool.rules.uk.TokenAgreementNounVerbExceptionHelper;
import org.languagetool.rules.uk.TokenAgreementPrepNounRule;
import org.languagetool.rules.uk.VerbInflectionHelper;
import org.languagetool.tagging.uk.IPOSTag;
import org.languagetool.tagging.uk.PosTagHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TokenAgreementAdjNounExceptionHelper {
    private static final Logger logger = LoggerFactory.getLogger(TokenAgreementAdjNounExceptionHelper.class);
    private static final Pattern NUMBER_V_NAZ = Pattern.compile("number|numr:p:v_naz|noun.*?:p:v_naz:&numr.*");
    static final List<String> CONJ_FOR_PLURAL_WITH_COMMA = Arrays.asList("\u0456", "\u0430", "\u0439", "\u0442\u0430", "\u0447\u0438", "\u0430\u0431\u043e", "\u0430\u043d\u0456", "\u0442\u0430\u043a\u043e\u0436", "\u043f\u043b\u044e\u0441", "\u0442\u043e", "a", "i", ",");
    static final List<String> CONJ_FOR_PLURAL = Arrays.asList("\u0456", "\u0430", "\u0439", "\u0442\u0430", "\u0447\u0438", "\u0430\u0431\u043e", "\u0430\u043d\u0456", "\u0442\u0430\u043a\u043e\u0436", "\u0442\u043e", "a", "i");
    static final Pattern CONJ_FOR_PLURAL_PATTERN = Pattern.compile(StringUtils.join(CONJ_FOR_PLURAL, (String)"|"));
    static final Pattern CONJ_FOR_PLURAL_WITH_COMMA_PATTERN = Pattern.compile(StringUtils.join(CONJ_FOR_PLURAL_WITH_COMMA, (String)"|"));
    private static final Pattern DOVYE_TROYE = Pattern.compile(".*[2-4]|.*[2-4][\u2013\u2014-].*[2-4]|\u0434\u0432\u0430|\u043e\u0431\u0438\u0434\u0432\u0430|\u0434\u0432\u043e\u0454|\u0442\u0440\u0438|\u0442\u0440\u043e\u0454|\u0447\u043e\u0442\u0438\u0440\u0438|\u043e\u0434\u0438\u043d[\u2013\u2014-]\u0434\u0432\u0430|\u0434\u0432\u0430[\u2013\u2014-]\u0442\u0440\u0438|\u0442\u0440\u0438[\u2013\u2014-]\u0447\u043e\u0442\u0438\u0440\u0438|\u0434\u0432\u043e\u0454[\u2013\u2014-]\u0442\u0440\u043e\u0454|\u0442\u0440\u043e\u0454[\u2013\u2014-]\u0447\u0435\u0442\u0432\u0435\u0440\u043e");
    private static final Pattern VERB_NOT_INSERT_PATTERN = Pattern.compile("verb(?!.*insert)");

    private TokenAgreementAdjNounExceptionHelper() {
    }

    public static boolean isException(AnalyzedTokenReadings[] tokens, int adjPos, int nounPos, List<InflectionHelper.Inflection> masterInflections, List<InflectionHelper.Inflection> slaveInflections, List<AnalyzedToken> adjTokenReadings, List<AnalyzedToken> slaveTokenReadings) {
        List<InflectionHelper.Inflection> preAdjInflections;
        Set<String> prepGovernedCases;
        List<InflectionHelper.Inflection> masterInflections_;
        Set<String> prepGovernedCases2;
        AnalyzedTokenReadings adjAnalyzedTokenReadings = tokens[adjPos];
        if (adjPos > 1 && LemmaHelper.isCapitalized(tokens[adjPos].getCleanToken()) && LemmaHelper.isCapitalized(tokens[adjPos - 1].getCleanToken()) && (LemmaHelper.hasLemma(tokens[adjPos], "\u0432\u0456\u0442\u0447\u0438\u0437\u043d\u044f\u043d\u0438\u0439") || LemmaHelper.hasLemma(tokens[adjPos], "\u0436\u0438\u0442\u043e\u043c\u0438\u0440\u0441\u044c\u043a\u0438\u0439")) && LemmaHelper.hasLemma(tokens[adjPos - 1], "\u0432\u0435\u043b\u0438\u043a\u0438\u0439") && !LemmaHelper.hasLemma(tokens[nounPos], "\u0432\u0456\u0439\u043d\u0430")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 1 && LemmaHelper.hasLemma(tokens[adjPos], "\u043d\u0430\u0446\u0456\u043e\u043d\u0430\u043b\u044c\u043d\u0438\u0439") && LemmaHelper.hasLemma(tokens[adjPos - 1], "\u043f\u0435\u0440\u0448\u0438\u0439") && Character.isUpperCase(tokens[adjPos].getToken().charAt(0)) && Character.isUpperCase(tokens[adjPos - 1].getToken().charAt(0))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[adjPos], "\u043f\u0456\u0432\u043d\u0456\u0447\u043d\u0438\u0439") && LemmaHelper.hasLemma(tokens[nounPos], "\u0420\u0435\u0439\u043d-\u0412\u0435\u0441\u0442\u0444\u0430\u043b\u0456\u044f")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[adjPos], Arrays.asList("\u0431\u043e\u0436\u0438\u0439", "\u0433\u043e\u0441\u043f\u043e\u0434\u043d\u0456\u0439", "\u0425\u0440\u0438\u0441\u0442\u043e\u0432\u0438\u0439")) && Character.isUpperCase(tokens[adjPos].getToken().charAt(0))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 1 && PosTagHelper.hasPosTagPart(tokens[adjPos - 1], "noun") && Character.isUpperCase(tokens[adjPos].getToken().charAt(0)) && !Collections.disjoint(masterInflections, InflectionHelper.getNounInflections(tokens[adjPos - 1].getReadings()))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (Pattern.compile("([1-9]|1[0-2])[\u2018-][\u0430-\u0434]").matcher(adjAnalyzedTokenReadings.getToken()).matches() && LemmaHelper.hasLemma(tokens[nounPos], "\u043a\u043b\u0430\u0441")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos > 1 && LemmaHelper.hasLemma(adjAnalyzedTokenReadings, Arrays.asList("\u043f\u0435\u0440\u0448\u0438\u0439")) && !LemmaHelper.hasLemma(tokens[nounPos], TokenAgreementAdjNounRule.FAKE_FEM_LIST, "noun:inanim:m:")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 1 && nounPos < tokens.length - 1 && PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, Pattern.compile("adj:[mf]:.*&numr.*|number.*")) && PosTagHelper.hasPosTag(slaveTokenReadings, Pattern.compile("noun:inanim:.:v_rod.*")) && LemmaHelper.hasLemma(tokens[adjPos - 1], Arrays.asList("\u0430\u0431\u0437\u0430\u0446", "\u0440\u043e\u0437\u0434\u0456\u043b", "\u043f\u0443\u043d\u043a\u0442", "\u043f\u0456\u0434\u043f\u0443\u043d\u043a\u0442", "\u0447\u0430\u0441\u0442\u0438\u043d\u0430", "\u0441\u0442\u0430\u0442\u0442\u044f"))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 1 && PosTagHelper.hasPosTagPart(adjAnalyzedTokenReadings, "num") && LemmaHelper.hasLemma(tokens[adjPos - 1], "\u0441\u0442\u0430\u0442\u0442\u044f") && !Collections.disjoint(masterInflections, InflectionHelper.getNounInflections(tokens[adjPos - 1].getReadings()))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 1 && tokens[adjPos].getToken().equals("\u0437\u0430\u043f\u0430\u0441\u043d\u0438\u0445") && LemmaHelper.hasLemma(tokens[adjPos - 1], "\u043b\u0430\u0432\u0430")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (Arrays.asList("\u0437\u043c\u0456\u043d\u0438", "\u0433\u0440\u0443\u043f\u0438").contains(tokens[nounPos].getCleanToken()) && LemmaHelper.hasLemma(tokens[adjPos], "\u0441\u0442\u0430\u0440\u0448\u0438\u0439")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 1 && tokens[adjPos].getToken().equals("\u043f\u043e\u0432\u043d\u0443") && tokens[adjPos - 1].getToken().equalsIgnoreCase("\u043d\u0430")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 1 && LemmaHelper.hasLemma(tokens[adjPos], Arrays.asList("\u0441\u0432\u0456\u0442\u043e\u0432\u0438\u0439"), ":f:") && LemmaHelper.hasLemma(tokens[adjPos - 1], Arrays.asList("\u0434\u0440\u0443\u0433\u0438\u0439", "\u043f\u0435\u0440\u0448\u0438\u0439"), ":f:")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos > 1 && LemmaHelper.hasLemma(tokens[nounPos - 1], Arrays.asList("\u0443\u0432\u0435\u0447\u0435\u0440\u0456", "\u0443\u0440\u0430\u043d\u0446\u0456", "\u0432\u0432\u0435\u0447\u0435\u0440\u0456", "\u0432\u0440\u0430\u043d\u0446\u0456")) && PosTagHelper.hasPosTag(tokens[nounPos], Pattern.compile("noun.*v_rod.*"))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos < tokens.length - 1 && Arrays.asList("\u043f\u043b\u043e\u0449\u0435\u044e", "\u043e\u0431'\u0454\u043c\u043e\u043c", "\u0434\u043e\u0432\u0436\u0438\u043d\u043e\u044e", "\u0432\u0438\u0441\u043e\u0442\u043e\u044e", "\u0437\u0440\u043e\u0441\u0442\u043e\u043c").contains(tokens[nounPos].getToken()) && PosTagHelper.hasPosTag(tokens[nounPos + 1], "prep.*|.*num.*")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 1 && LemmaHelper.hasLemma(tokens[adjPos - 1], Pattern.compile(".*\u043c\u0435\u0442\u0440.*")) && LemmaHelper.hasLemma(tokens[adjPos], Pattern.compile("\u043a\u0432\u0430\u0434\u0440\u0430\u0442\u043d\u0438\u0439|\u043a\u0443\u0431\u0456\u0447\u043d\u0438\u0439")) && PosTagHelper.hasPosTagPart(tokens[nounPos], "v_rod")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos < tokens.length - 1 && tokens[nounPos].getToken().equals("\u0433\u0432\u0430\u0440\u0434\u0456\u0457") && PosTagHelper.hasPosTag(tokens[nounPos + 1], "noun.*") && !Collections.disjoint(masterInflections, InflectionHelper.getNounInflections(tokens[nounPos + 1].getReadings()))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 1 && tokens[adjPos - 1].getToken().endsWith("%") && tokens[adjPos].getToken().equals("\u0440\u0456\u0447\u043d\u0438\u0445")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 1 && LemmaHelper.hasLemma(tokens[adjPos - 1], "\u043f\u0430\u0441\u0442\u0438") && tokens[adjPos].getToken().equals("\u0437\u0430\u0434\u043d\u0456\u0445")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 1 && LemmaHelper.hasLemma(tokens[adjPos - 1], "\u043c\u0430\u0442\u0438") && tokens[adjPos].getToken().equals("\u0440\u0456\u0432\u043d\u0438\u0445")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 1 && tokens[nounPos].getToken().equals("\u043c\u0430\u043d\u0435\u0440") && tokens[adjPos - 1].getToken().equalsIgnoreCase("\u043d\u0430")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 2 && tokens[adjPos].getToken().equals("\u0454\u0434\u0438\u043d\u043e\u0433\u043e") && tokens[adjPos - 1].getToken().equals("\u0434\u043e") && LemmaHelper.hasLemma(tokens[adjPos - 2], Arrays.asList("\u0432\u0435\u0441\u044c", "\u0443\u0432\u0435\u0441\u044c"), ":p:")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos < tokens.length - 1 && Arrays.asList("\u043c\u0438\u0440\u0443", "\u0441\u0432\u0456\u0442\u0443").contains(tokens[nounPos].getCleanToken()) && (LemmaHelper.hasLemma(adjAnalyzedTokenReadings, Arrays.asList("\u0441\u0438\u043b\u044c\u043d\u0438\u0439", "\u043c\u043e\u0433\u0443\u0442\u043d\u0456\u0439", "\u0432\u0435\u043b\u0438\u043a\u0438\u0439")) || LemmaHelper.hasLemma(tokens[nounPos + 1], Arrays.asList("\u0446\u0435\u0439", "\u0441\u0435\u0439"), ":m:v_rod"))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[adjPos], Arrays.asList("\u043a\u043e\u043b\u0438\u0448\u043d\u0456\u0439", "\u0442\u043e\u0434\u0456\u0448\u043d\u0456\u0439", "\u0442\u0435\u043f\u0435\u0440\u0456\u0448\u043d\u0456\u0439", "\u043d\u0438\u043d\u0456\u0448\u043d\u0456\u0439"), Pattern.compile("adj.*:f:.*")) && Character.isUpperCase(tokens[nounPos].getToken().charAt(0))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos < tokens.length - 1 && Arrays.asList("\u0456\u043c.", "\u0456\u043c\u0435\u043d\u0456", "\u043e\u0440\u0434\u0435\u043d\u0430").contains(tokens[nounPos].getToken())) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (Arrays.asList("\u0434\u0456\u0432\u043e\u0447\u0435").contains(tokens[adjPos].getToken()) && PosTagHelper.hasPosTagPart(tokens[nounPos], "name")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (Arrays.asList("\u0432\u043e\u043b\u044c\u043d\u043e\u043c\u0443", "\u0432\u0456\u043b\u044c\u043d\u043e\u043c\u0443").contains(adjAnalyzedTokenReadings.getToken().toLowerCase()) && tokens[nounPos].getToken().equals("\u0432\u043e\u043b\u044f")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 1 && LemmaHelper.hasLemma(adjAnalyzedTokenReadings, "\u0434\u0435\u043d\u043d\u0438\u0439") && LemmaHelper.hasLemma(tokens[adjPos - 1], "\u043f\u043e\u0440\u044f\u0434\u043e\u043a") && !Collections.disjoint(masterInflections, InflectionHelper.getNounInflections(tokens[adjPos - 1].getReadings()))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[adjPos], Arrays.asList("\u0437\u0434\u0430\u0442\u043d\u0438\u0439", "\u0437\u043c\u0443\u0448\u0435\u043d\u0438\u0439", "\u0432\u0438\u043d\u043d\u0438\u0439", "\u043f\u043e\u0432\u0438\u043d\u043d\u0438\u0439", "\u0433\u043e\u0442\u043e\u0432\u0438\u0439", "\u0441\u043f\u0440\u043e\u043c\u043e\u0436\u043d\u0438\u0439"))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos < tokens.length - 2 && PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj:p:.*") && tokens[nounPos + 1].getToken().matches("[\u2014\u2013-]") && PosTagHelper.hasPosTag(tokens[nounPos + 2], "(adj|noun).*") && TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(masterInflections, slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos < tokens.length - 2 && PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj:p:.*") && TokenAgreementAdjNounExceptionHelper.forwardConjFind(tokens, nounPos + 1, 2) && TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(masterInflections, slaveInflections, "p", null)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos < tokens.length - 2 && PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj:p:.*") && Arrays.asList("\u0437", "\u0456\u0437", "\u0437\u0456").contains(tokens[nounPos + 1].getToken()) && PosTagHelper.hasPosTag(tokens[nounPos + 2], "(noun|numr).*:v_oru.*") && TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(masterInflections, slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 2 && PosTagHelper.hasPosTag(tokens[nounPos], "noun:.*:p:.*") && (TokenAgreementAdjNounExceptionHelper.reverseConjFind(tokens, adjPos - 1, 3) || TokenAgreementAdjNounExceptionHelper.reverseConjAdvFind(tokens, adjPos - 1, 3)) && TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(masterInflections, slaveInflections, null, "p") && LemmaHelper.reverseSearch(tokens, adjPos - 2, 100, null, Pattern.compile("adj.*"))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 2 && PosTagHelper.hasPosTag(tokens[nounPos], "noun:.*:p:.*") && TokenAgreementAdjNounExceptionHelper.reverseConjFind2(tokens, adjPos - 1, 3) && TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(masterInflections, slaveInflections, null, "p")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 6 && PosTagHelper.hasPosTag(tokens[nounPos], "noun:.*:p:.*") && PosTagHelper.hasPosTag(tokens[adjPos], "adj:.*") && PosTagHelper.hasPosTag(tokens[adjPos - 1], "prep.*") && LemmaHelper.hasLemma(tokens[adjPos - 2], Arrays.asList("\u043d\u0456", "\u0430\u043d\u0456", "\u0445\u043e\u0447", "\u0449\u043e", "\u044f\u043a")) && tokens[adjPos - 3].getToken().equals(",") && TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(masterInflections, slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        Pattern afterPredicVerbTags = Pattern.compile(".*(inf|past:n|futr:s:3).*");
        if (nounPos < tokens.length - 1 && PosTagHelper.hasPosTagPart(tokens[nounPos], "predic") && (PosTagHelper.hasPosTag(tokens[nounPos + 1], afterPredicVerbTags) || nounPos < tokens.length - 2 && PosTagHelper.hasPosTagStart(tokens[nounPos + 1], "adv") && PosTagHelper.hasPosTag(tokens[nounPos + 2], afterPredicVerbTags))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 5 && PosTagHelper.hasPosTag(tokens[nounPos], "noun:.*:p:.*") && PosTagHelper.hasPosTag(tokens[adjPos], "adj:.*") && tokens[adjPos - 1].getToken().equals(",") && (tokens[adjPos - 3].getToken().equals(",") && CONJ_FOR_PLURAL_WITH_COMMA.contains(tokens[adjPos - 4].getToken().toLowerCase()) && !PosTagHelper.hasPosTag(tokens[adjPos - 2], VERB_NOT_INSERT_PATTERN) || tokens[adjPos - 4].getToken().equals(",") && CONJ_FOR_PLURAL_WITH_COMMA.contains(tokens[adjPos - 5].getToken().toLowerCase()) && !PosTagHelper.hasPosTag(tokens[adjPos - 2], VERB_NOT_INSERT_PATTERN) && !PosTagHelper.hasPosTag(tokens[adjPos - 3], VERB_NOT_INSERT_PATTERN)) && TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(masterInflections, slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 2 && PosTagHelper.hasPosTag(tokens[nounPos], "noun:.*:p:.*") && tokens[adjPos - 1].getToken().matches("\u0437|\u0456\u0437|\u0437\u0456") && PosTagHelper.hasPosTag(tokens[adjPos], "adj.*v_oru.*") && TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(InflectionHelper.getAdjInflections(tokens[adjPos - 2].getReadings()), slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj:p:v_rod.*") && tokens[nounPos].getToken().startsWith("\u043f\u0456\u0432") && PosTagHelper.hasPosTag(tokens[nounPos], "noun.*v_rod.*")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos < tokens.length - 1 && PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj:p:v_rod.*") && tokens[nounPos].getToken().equals("\u0447\u0432\u0435\u0440\u0442\u044c") && PosTagHelper.hasPosTag(tokens[nounPos + 1], "noun.*v_rod.*")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos < tokens.length - 1 && PosTagHelper.hasPosTagPart(adjAnalyzedTokenReadings, "adjp") && LemmaHelper.hasLemma(tokens[nounPos], Arrays.asList("\u0447\u0432\u0435\u0440\u0442\u044c", "\u0442\u0440\u0435\u0442\u0438\u043d\u0430")) && PosTagHelper.hasPosTag(tokens[nounPos + 1], "noun.*v_rod.*")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTagPart(adjAnalyzedTokenReadings, "adjp") && LemmaHelper.hasLemma(tokens[nounPos - 1], Arrays.asList("\u0447\u0438\u043c\u0430\u043b\u043e", "\u0431\u0430\u0433\u0430\u0442\u043e", "\u043d\u0435\u0431\u0430\u0433\u0430\u0442\u043e", "\u043d\u0435\u043c\u0430\u043b\u043e", "\u043e\u0431\u043c\u0430\u043b\u044c")) && PosTagHelper.hasPosTag(tokens[nounPos], "noun.*:p:v_rod.*")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (Arrays.asList("\u043f\u0435\u0440\u0435\u043a\u043e\u043d\u0430\u043d\u0430", "\u0432\u043f\u0435\u0432\u043d\u0435\u043d\u0430", "\u0443\u043f\u0435\u0432\u043d\u0435\u043d\u0430", "\u0433\u043e\u0434\u043d\u0430", "\u043b\u0430\u0434\u043d\u0430", "\u043f\u0435\u0432\u043d\u0430", "\u043f\u0440\u0438\u0447\u0435\u0442\u043d\u0430", "\u043e\u0431\u0440\u0430\u043d\u0430", "\u043f\u0440\u0438\u0437\u043d\u0430\u0447\u0435\u043d\u0430").contains(adjAnalyzedTokenReadings.getToken()) && PosTagHelper.hasPosTag(tokens[nounPos], "noun:anim:m:v_naz.*")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos < tokens.length - 1 && tokens[nounPos].getToken().equals("\u0441\u0442\u0430\u043d\u043e\u043c") && tokens[nounPos + 1].getToken().equals("\u043d\u0430")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 1 && tokens[adjPos].getToken().equals("\u0440\u0456\u0432\u043d\u0438\u0445") && tokens[adjPos - 1].getToken().equalsIgnoreCase("\u043d\u0430")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos < tokens.length - 1 && tokens[nounPos].getToken().equals("\u0437\u0440\u0430\u0437\u043a\u0430")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (Arrays.asList("\u043c\u0456\u043d\u0443\u0441", "\u043f\u043b\u044e\u0441").contains(tokens[nounPos].getToken())) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos < tokens.length - 1 && LemmaHelper.hasLemma(tokens[nounPos], Arrays.asList("\u043f\u0430\u0440\u0430", "\u043d\u0438\u0437\u043a\u0430", "\u0440\u044f\u0434", "\u043a\u0443\u043f\u0430", "\u0431\u0456\u043b\u044c\u0448\u0456\u0441\u0442\u044c", "\u0434\u0435\u0441\u044f\u0442\u043a\u0430", "\u0441\u043e\u0442\u043d\u044f", "\u0442\u0438\u0441\u044f\u0447\u0430", "\u043c\u0456\u043b\u044c\u0439\u043e\u043d")) && (PosTagHelper.hasPosTag(tokens[nounPos + 1], "noun.*?:p:v_rod.*") || nounPos < tokens.length - 2 && PosTagHelper.hasPosTag(tokens[nounPos + 1], "adj:p:v_rod.*") && PosTagHelper.hasPosTag(tokens[nounPos + 2], "noun.*?:p:v_rod.*"))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos < tokens.length - 1 && LemmaHelper.hasLemma(tokens[nounPos], Arrays.asList("\u0440\u0430\u0437"), Pattern.compile(".*p:v_(naz|rod).*")) && (PosTagHelper.hasPosTag(tokens[nounPos + 1], "number|numr:p:v_naz|noun.*?:p:v_naz:&numr.*") || PosTagHelper.hasPosTagPart(tokens[nounPos + 1], "prep"))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos < tokens.length - 1 && LemmaHelper.hasLemma(tokens[nounPos], LemmaHelper.TIME_PLUS_LEMMAS, Pattern.compile("noun.*?p:v_(naz|rod).*")) && (PosTagHelper.hasPosTag(tokens[nounPos + 1], NUMBER_V_NAZ) || nounPos < tokens.length - 2 && LemmaHelper.hasLemma(tokens[nounPos + 1], Arrays.asList("\u043d\u0430", "\u0437\u0430", "\u0437", "\u0456\u0437", "\u0437\u043e", "\u0447\u0435\u0440\u0435\u0437", "\u043f\u0456\u0434"), "prep") && PosTagHelper.hasPosTag(tokens[nounPos + 2], NUMBER_V_NAZ))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos < tokens.length - 2 && LemmaHelper.hasLemma(tokens[nounPos], Arrays.asList("\u043e\u0441\u043e\u0431\u0430"), Pattern.compile("noun.*?p:v_(naz|rod).*")) && LemmaHelper.hasLemma(tokens[nounPos + 1], Arrays.asList("\u043d\u0430", "\u0437", "\u0456\u0437", "\u0437\u043e", "\u043f\u0456\u0434"), "prep") && PosTagHelper.hasPosTag(tokens[nounPos + 2], NUMBER_V_NAZ)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 2 && LemmaHelper.hasLemma(tokens[adjPos - 2], LemmaHelper.TIME_LEMMAS_SHORT) && PosTagHelper.hasPosTagStart(tokens[adjPos - 1], "prep") && PosTagHelper.hasPosTagPart(tokens[adjPos], "num") && TokenAgreementPrepNounRule.hasVidmPosTag(prepGovernedCases2 = CaseGovernmentHelper.getCaseGovernments(tokens[adjPos - 1], IPOSTag.prep.name()), tokens[adjPos - 2]) && TokenAgreementPrepNounRule.hasVidmPosTag(prepGovernedCases2, tokens[adjPos])) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos < tokens.length - 1 && LemmaHelper.hasLemma(tokens[nounPos], LemmaHelper.TIME_LEMMAS) && LemmaHelper.hasLemma(tokens[nounPos + 1], "\u0442\u043e\u043c\u0443")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos < tokens.length - 1 && LemmaHelper.hasLemma(tokens[nounPos], LemmaHelper.TIME_PLUS_LEMMAS, Pattern.compile("noun:inanim:p:v_oru.*"))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[adjPos], Arrays.asList("\u0434\u0435\u0441\u044f\u0442\u0438\u0439", "\u0441\u043e\u0442\u0438\u0439", "\u0442\u0438\u0441\u044f\u0447\u043d\u0438\u0439", "\u0434\u0435\u0441\u044f\u0442\u0438\u0442\u0438\u0441\u044f\u0447\u043d\u0438\u0439", "\u0441\u0442\u043e\u0442\u0438\u0442\u0438\u0441\u044f\u0447\u043d\u0438\u0439", "\u043c\u0456\u043b\u044c\u0439\u043e\u043d\u043d\u0438\u0439", "\u043c\u0456\u043b\u044c\u044f\u0440\u0434\u043d\u0438\u0439")) && PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, ".*:[fp]:.*") && PosTagHelper.hasPosTag(tokens[nounPos], "noun.*v_rod.*")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 1 && nounPos < tokens.length && PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, ".*:p:v_(rod|naz).*") && LemmaHelper.reverseSearch(tokens, adjPos - 1, 5, DOVYE_TROYE, null) && (PosTagHelper.hasPosTag(tokens[nounPos], ".*(:p:v_naz|:n:v_rod).*") || Arrays.asList("\u0456\u043c\u0435\u043d\u0456", "\u043e\u043a\u0430").contains(tokens[nounPos].getToken()))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if ((adjAnalyzedTokenReadings.getCleanToken().matches("[0-9]+[\u2014\u2013-][0-9]+[\u2013-][\u0430-\u044f\u0456\u0457\u0454\u0491]{1,3}") || adjAnalyzedTokenReadings.getCleanToken().matches(".*[\u0430-\u044f\u0457\u0456\u0454\u0491][\u2014\u2013-].*") && PosTagHelper.hasPosTagPart(adjAnalyzedTokenReadings, "&numr")) && PosTagHelper.hasPosTagPart(slaveTokenReadings, ":p:") && TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(masterInflections, slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos > 2 && Arrays.asList("\u2013", "\u2014").contains(tokens[adjPos - 1].getToken()) && PosTagHelper.hasPosTagPart(adjAnalyzedTokenReadings, "num") && PosTagHelper.hasPosTagPart(tokens[adjPos - 2], "num") && PosTagHelper.hasPosTagPart(slaveTokenReadings, ":p:") && (PosTagHelper.hasPosTagStart(tokens[adjPos - 2], "number") || TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(InflectionHelper.getAdjInflections(tokens[adjPos - 2].getReadings()), slaveInflections)) && TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(masterInflections, slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj.*:p:.*") && tokens[nounPos].getToken().matches(".*[\u2014\u2013-].*") && (LemmaHelper.TIME_PLUS_LEMMAS.contains(tokens[nounPos].getAnalyzedToken(0).getLemma().split("[\u2014\u2013-]")[0]) || TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(masterInflections, slaveInflections))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos < tokens.length - 1 && LemmaHelper.hasLemma(tokens[nounPos], "\u043f\u0430\u0440\u0430") && PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj.*:p:.*") && PosTagHelper.hasPosTag(tokens[nounPos + 1], ".*:p:v_rod.*")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos > 1 && PosTagHelper.hasPosTagPart(tokens[adjPos - 1], "num") && PosTagHelper.hasPosTag(tokens[adjPos], "adj.*num.*")) {
            if (PosTagHelper.hasPosTag(tokens[adjPos - 1], "(noun|numr).*") && PosTagHelper.hasPosTag(tokens[adjPos], "adj:p:v_rod.*")) {
                if (LemmaHelper.hasLemma(tokens[adjPos], "\u0434\u0440\u0443\u0433\u0438\u0439") && !LemmaHelper.hasLemma(tokens[adjPos - 1], "\u043e\u0434\u0438\u043d")) {
                    return false;
                }
                TokenAgreementAdjNounExceptionHelper.logException();
                return true;
            }
            if (PosTagHelper.hasPosTag(tokens[adjPos - 1], "adj:f:.*pron.*") && LemmaHelper.hasLemma(tokens[adjPos - 1], "\u043e\u0434\u0438\u043d") && !Collections.disjoint(InflectionHelper.getAdjInflections(tokens[adjPos - 1].getReadings()), InflectionHelper.getAdjInflections(tokens[adjPos].getReadings()))) {
                TokenAgreementAdjNounExceptionHelper.logException();
                return true;
            }
        }
        if (nounPos > 3 && "/".equals(tokens[adjPos - 1].getToken()) && PosTagHelper.hasPosTagPart(tokens[adjPos - 2], "numb") && TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(masterInflections, slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTagPart(adjAnalyzedTokenReadings, ":&numr")) {
            String adjToken = adjAnalyzedTokenReadings.getToken();
            if (adjToken.matches("([12][0-9])?[0-9][0-9][\u2014\u2013-](\u0439|\u0433\u043e|\u043c|\u043c\u0443)") || adjToken.matches("([12][0-9])?[0-9]0[\u2014\u2013-](\u0442\u0456|\u0442\u0438\u0445|\u0438\u0445|\u0445)") || adjToken.matches("([12][0-9])?[0-9][0-9][\u2014\u2013-]([12][0-9])?[0-9][0-9][\u2014\u2013-](\u0439|\u0433\u043e|\u043c|\u043c\u0443|\u0442\u0456|\u0442\u0438\u0445|\u0438\u0445|\u0445)")) {
                TokenAgreementAdjNounExceptionHelper.logException();
                return true;
            }
            if (nounPos > 1 && PosTagHelper.hasPosTagPart(adjAnalyzedTokenReadings, ":f:") && LemmaHelper.hasLemma(tokens[adjPos - 1], Arrays.asList("\u043d\u0430", "\u0432", "\u0443", "\u0437\u0430", "\u043e", "\u0434\u043e", "\u043f\u0456\u0441\u043b\u044f", "\u0431\u043b\u0438\u0437\u044c\u043a\u043e", "\u0440\u0430\u043d\u0456\u0448\u0435")) && !LemmaHelper.hasLemma(tokens[nounPos], Arrays.asList("\u0445\u0432\u0438\u043b\u0438\u043d\u0430", "\u0433\u043e\u0434\u0438\u043d\u0430"))) {
                TokenAgreementAdjNounExceptionHelper.logException();
                return true;
            }
            if (PosTagHelper.hasPosTagPart(adjAnalyzedTokenReadings, ":f:") && tokens[nounPos].getToken().matches("\u0440\u0430\u043d\u043a\u0443|\u0434\u043d\u044f|\u0432\u0435\u0447\u043e\u0440\u0430|\u043d\u043e\u0447\u0456|\u043f\u043e\u043f\u043e\u043b\u0443\u0434\u043d\u044f")) {
                TokenAgreementAdjNounExceptionHelper.logException();
                return true;
            }
            if (PosTagHelper.hasPosTagPart(adjAnalyzedTokenReadings, ":n:") && LemmaHelper.hasLemma(tokens[nounPos], LemmaHelper.MONTH_LEMMAS, "v_rod")) {
                TokenAgreementAdjNounExceptionHelper.logException();
                return true;
            }
        }
        if (PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, ".*?adjp:actv.*:bad.*")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos > 2 && nounPos <= tokens.length - 1 && LemmaHelper.hasLemma(tokens[adjPos - 1], Arrays.asList("\u043d\u0456\u0449\u043e", "\u0449\u043e\u0441\u044c", "\u043d\u0456\u0445\u0442\u043e", "\u0445\u0442\u043e\u0441\u044c")) && !Collections.disjoint(InflectionHelper.getNounInflections(tokens[adjPos - 1].getReadings()), masterInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 1 && LemmaHelper.revSearch(tokens, adjPos - 1, Pattern.compile(".*(\u043d\u043d\u044f|\u0442\u0442\u044f)"), null) && PosTagHelper.hasPosTag(tokens[adjPos], "adj.*:v_oru.*") && PosTagHelper.hasPosTag(tokens[nounPos], "noun:.*:v_rod.*") && TokenAgreementAdjNounExceptionHelper.genderMatches(masterInflections, slaveInflections, "v_oru", "v_rod")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        int verbPos = LemmaHelper.revSearchIdx(tokens, adjPos - 1, Pattern.compile("\u0431\u0443\u0442\u0438|\u0441\u0442\u0430\u0432\u0430\u0442\u0438|\u0441\u0442\u0430\u0442\u0438|\u0437\u0430\u043b\u0438\u0448\u0430\u0442\u0438\u0441\u044f|\u0437\u0430\u043b\u0438\u0448\u0438\u0442\u0438\u0441\u044f"), null);
        if (verbPos != -1) {
            if (PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj.*v_naz.*adjp:pasv.*")) {
                if (TokenAgreementAdjNounExceptionHelper.genderMatches(masterInflections, slaveInflections, "v_naz", "v_naz")) {
                    TokenAgreementAdjNounExceptionHelper.logException();
                    return true;
                }
                if (TokenAgreementAdjNounExceptionHelper.genderMatches(masterInflections, slaveInflections, "v_naz", "v_naz")) {
                    TokenAgreementAdjNounExceptionHelper.logException();
                    return true;
                }
            } else if (PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj.*v_oru.*")) {
                if (PosTagHelper.hasPosTag(slaveTokenReadings, "noun.*v_naz.*")) {
                    if (TokenAgreementAdjNounExceptionHelper.genderMatches(masterInflections, slaveInflections, "v_oru", "v_naz")) {
                        if (PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") || VerbInflectionHelper.inflectionsOverlap(tokens[verbPos].getReadings(), tokens[nounPos].getReadings())) {
                            TokenAgreementAdjNounExceptionHelper.logException();
                            return true;
                        }
                    } else if (nounPos < tokens.length - 1 && PosTagHelper.hasPosTagPart(tokens[adjPos], "adj:p:") && CONJ_FOR_PLURAL_WITH_COMMA.contains(tokens[nounPos + 1].getToken().toLowerCase())) {
                        TokenAgreementAdjNounExceptionHelper.logException();
                        return true;
                    }
                } else if (PosTagHelper.hasPosTag(slaveTokenReadings, "noun.*v_dav.*") && TokenAgreementAdjNounExceptionHelper.genderMatches(masterInflections, slaveInflections, "v_oru", "v_dav")) {
                    TokenAgreementAdjNounExceptionHelper.logException();
                    return true;
                }
            }
        }
        if ((verbPos = LemmaHelper.revSearchIdx(tokens, adjPos - 1, null, "verb.*")) != -1 && PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj.*v_oru.*") && PosTagHelper.hasPosTag(slaveTokenReadings, "noun.*v_naz.*") && VerbInflectionHelper.inflectionsOverlap(tokens[verbPos].getReadings(), tokens[nounPos].getReadings())) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 2 && Arrays.asList("\u0431\u0456\u043b\u0435", "\u0447\u043e\u0440\u043d\u0435", "\u043e\u0440\u0430\u043d\u0436\u0435\u0432\u0435", "\u0447\u0435\u0440\u0432\u043e\u043d\u0435", "\u0436\u043e\u0432\u0442\u0435", "\u0441\u0438\u043d\u0454", "\u0437\u0435\u043b\u0435\u043d\u0435", "\u0444\u0456\u043e\u043b\u0435\u0442\u043e\u0432\u0435").contains(tokens[adjPos].getToken()) && Arrays.asList("\u0432", "\u0443").contains(tokens[adjPos - 1].getToken()) && PosTagHelper.hasPosTagPart(tokens[adjPos - 2], "adjp:pasv") && !Collections.disjoint(masterInflections_ = InflectionHelper.getAdjInflections(tokens[adjPos - 2].getReadings()), slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 3 && Arrays.asList("\u0431\u0456\u043b\u0435", "\u0447\u043e\u0440\u043d\u0435").contains(tokens[adjPos].getToken()) && Arrays.asList("\u0443\u0441\u0435", "\u0432\u0441\u0435").contains(tokens[adjPos - 1].getToken()) && Arrays.asList("\u0432", "\u0443").contains(tokens[adjPos - 2].getToken()) && PosTagHelper.hasPosTagPart(tokens[adjPos - 3], "adjp:pasv") && !Collections.disjoint(masterInflections_ = InflectionHelper.getAdjInflections(tokens[adjPos - 3].getReadings()), slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (nounPos < tokens.length - 1 && PosTagHelper.hasPosTagPart(adjAnalyzedTokenReadings, "adjp:pasv") && Arrays.asList("\u0442\u0438\u0441\u044f\u0447\u0443", "\u0441\u043e\u0442\u043d\u044e", "\u0434\u0435\u0441\u044f\u0442\u043a\u0438").contains(tokens[nounPos].getToken()) && Arrays.asList("\u0440\u0430\u0437\u0456\u0432", "\u0440\u0430\u0437", "\u0440\u043e\u043a\u0456\u0432").contains(tokens[nounPos + 1].getToken())) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (adjPos > 2 && PosTagHelper.hasPosTagPart(tokens[adjPos - 1], "prep") && PosTagHelper.hasPosTag(tokens[adjPos - 2], "(adj|verb|part|noun|adv).*") && TokenAgreementPrepNounRule.hasVidmPosTag(prepGovernedCases = CaseGovernmentHelper.getCaseGovernments(tokens[adjPos - 1], IPOSTag.prep.name()), tokens[adjPos])) {
            if ((PosTagHelper.hasPosTagStart(tokens[adjPos - 2], "verb") || LemmaHelper.hasLemma(tokens[adjPos - 2], Arrays.asList("\u0431\u0438", "\u0431")) || Arrays.asList("\u043f\u043e\u0440\u044f\u0434", "\u0432\u0456\u0434\u043c\u0456\u043d\u0443", "\u043f\u043e\u0440\u0456\u0432\u043d\u044f\u043d\u043d\u0456").contains(tokens[adjPos - 2].getToken().toLowerCase())) && PosTagHelper.hasPosTag(tokens[nounPos], "noun.*v_(naz|zna|oru).*")) {
                TokenAgreementAdjNounExceptionHelper.logException();
                return true;
            }
            List<InflectionHelper.Inflection> masterInflections_2 = InflectionHelper.getAdjInflections(tokens[adjPos - 2].getReadings());
            if (!Collections.disjoint(masterInflections_2, slaveInflections)) {
                TokenAgreementAdjNounExceptionHelper.logException();
                return true;
            }
            if (nounPos < tokens.length - 1 && PosTagHelper.hasPosTagPart(tokens[adjPos], "adj:p:") && CONJ_FOR_PLURAL_WITH_COMMA.contains(tokens[nounPos + 1].getToken().toLowerCase()) && PosTagHelper.hasPosTagPart(tokens[adjPos - 2], "adj:p:") && TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(InflectionHelper.getAdjInflections(tokens[adjPos - 2].getReadings()), slaveInflections, "p", null)) {
                TokenAgreementAdjNounExceptionHelper.logException();
                return true;
            }
        }
        if (adjPos > 1 && PosTagHelper.hasPosTagPart(tokens[adjPos - 1], "adjp:pasv") && PosTagHelper.hasPosTag(tokens[adjPos], "adj.*v_oru.*") && !Collections.disjoint(InflectionHelper.getAdjInflections(tokens[adjPos - 1].getReadings()), slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTagPart(adjAnalyzedTokenReadings, "adjp:pasv") && PosTagHelper.hasPosTagPart(tokens[nounPos], "v_oru")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (!PosTagHelper.hasPosTag(tokens[adjPos - 1], ".*adjp:pasv.*|prep.*") && PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj.*v_oru.*") && PosTagHelper.hasPosTag(slaveTokenReadings, "noun.*v_naz.*") && LemmaHelper.forwardPosTagSearch(tokens, nounPos + 1, "verb", 3)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if ((nounPos < 3 || !CaseGovernmentHelper.hasCaseGovernment(tokens[adjPos - 1], "v_oru")) && PosTagHelper.hasPosTagPart(adjAnalyzedTokenReadings, "v_oru") && PosTagHelper.hasPosTag(slaveTokenReadings, ".*v_zna.*") && TokenAgreementAdjNounExceptionHelper.genderMatches(masterInflections, slaveInflections, "v_oru", "v_zna")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (TokenAgreementAdjNounExceptionHelper.caseGovernmentMatches(adjTokenReadings, slaveInflections)) {
            if (nounPos < tokens.length - 1 && PosTagHelper.hasPosTagPart(tokens[nounPos + 1], "noun:")) {
                if (PosTagHelper.hasPosTag(tokens[nounPos + 1], "noun.*v_(rod|oru|naz|dav).*")) {
                    TokenAgreementAdjNounExceptionHelper.logException();
                    return true;
                }
                List<InflectionHelper.Inflection> slave2Inflections = InflectionHelper.getNounInflections(tokens[nounPos + 1].getReadings());
                if (!Collections.disjoint(masterInflections, slave2Inflections)) {
                    TokenAgreementAdjNounExceptionHelper.logException();
                    return true;
                }
            } else {
                TokenAgreementAdjNounExceptionHelper.logException();
                return true;
            }
        }
        if (adjPos > 1 && PosTagHelper.hasPosTagPart(tokens[adjPos - 1], "adj") && TokenAgreementAdjNounExceptionHelper.caseGovernmentMatches(tokens[adjPos - 1].getReadings(), masterInflections) && !Collections.disjoint(preAdjInflections = InflectionHelper.getAdjInflections(tokens[adjPos - 1].getReadings()), slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        return false;
    }

    private static boolean genderMatches(List<InflectionHelper.Inflection> masterInflections, List<InflectionHelper.Inflection> slaveInflections, String masterCaseFilter, String slaveCaseFilter) {
        for (InflectionHelper.Inflection masterInflection : masterInflections) {
            for (InflectionHelper.Inflection slaveInflection : slaveInflections) {
                if (masterCaseFilter != null && !masterInflection._case.equals(masterCaseFilter) || slaveCaseFilter != null && !slaveInflection._case.equals(slaveCaseFilter) || !slaveInflection.gender.equals(masterInflection.gender)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean reverseConjAdvFind(AnalyzedTokenReadings[] tokens, int pos, int depth) {
        for (int i = pos; i > pos - depth && i >= 2; --i) {
            if (CONJ_FOR_PLURAL_WITH_COMMA.contains(tokens[i].getToken().toLowerCase()) && (PosTagHelper.hasPosTag(tokens[i - 1], "adv(?!p).*") || PosTagHelper.hasPosTag(tokens[i + 1], "(adv(?!p)|part).*"))) {
                return true;
            }
            if (!PosTagHelper.hasPosTagPart(tokens[i], "verb")) continue;
            return false;
        }
        return false;
    }

    private static boolean reverseConjFind(AnalyzedTokenReadings[] tokens, int pos, int depth) {
        for (int i = pos; i > pos - depth && i >= 1; --i) {
            if (CONJ_FOR_PLURAL_WITH_COMMA.contains(tokens[i].getToken().toLowerCase())) {
                return i >= 2 && PosTagHelper.hasPosTag(tokens[i - 1], Pattern.compile("(adj|conj:coord).*"));
            }
            if (i < 1 || PosTagHelper.hasPosTag(tokens[i - 1], Pattern.compile("(adj|conj:coord|num|prep|adv(?!p)).*")) || tokens[i - 1].getToken().equals(",")) continue;
            return false;
        }
        return false;
    }

    private static boolean reverseConjFind2(AnalyzedTokenReadings[] tokens, int pos, int depth) {
        for (int i = pos; i > pos - depth && i >= 1; --i) {
            if (CONJ_FOR_PLURAL_WITH_COMMA.contains(tokens[i].getToken().toLowerCase())) {
                if (TokenAgreementNounVerbExceptionHelper.isNonPluralA(tokens, i)) {
                    return false;
                }
                return i >= 2 && (tokens[i - 1].hasPosTag("number") && PosTagHelper.hasPosTag(tokens[i + 1], Pattern.compile("adj.*?&numr.*")) || tokens[i - 1].getToken().equals(",") || tokens[i - 1].getToken().matches(".*[\u2013-]") || tokens[i - 1].getToken().matches("[)\u00bb\u201d]") || tokens[i - 1].getToken().equals("/") && tokens[i].getToken().equals("\u0430\u0431\u043e") || PosTagHelper.isUnknownWord(tokens[i - 1]));
            }
            if (i < 1 || PosTagHelper.hasPosTag(tokens[i - 1], Pattern.compile("(adj|conj:coord|num|prep|adv(?!p)).*")) || tokens[i - 1].getToken().equals(",")) continue;
            return false;
        }
        return false;
    }

    private static boolean checkTextInSent(AnalyzedTokenReadings[] tokens, int pos, String text) {
        String[] words = text.split(" ");
        for (int i = 0; i < words.length && i + pos < tokens.length; ++i) {
            if (tokens[i + pos].getToken().equalsIgnoreCase(words[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean forwardConjFind(AnalyzedTokenReadings[] tokens, int pos, int depth) {
        for (int i = pos; i < tokens.length && i <= pos + depth; ++i) {
            if (CONJ_FOR_PLURAL_WITH_COMMA.contains(tokens[i].getToken().toLowerCase())) {
                if (i < tokens.length - 3 && TokenAgreementAdjNounExceptionHelper.checkTextInSent(tokens, i + 1, "\u0430 \u0442\u0430\u043a\u043e\u0436") && PosTagHelper.hasPosTag(tokens[i + 3], Pattern.compile("(noun|adj|num|adv(?!p)).*"))) {
                    return true;
                }
                return i != tokens.length - 1 && (PosTagHelper.hasPosTag(tokens[i + 1], Pattern.compile("(noun|adj|num|adv(?!p)).*")) || LemmaHelper.isCapitalized(tokens[i + 1].getCleanToken()) || tokens[i + 1].getToken().matches("[\"\u00ab\u201c\u201e]"));
            }
            if (PosTagHelper.hasPosTag(tokens[i], Pattern.compile("(noun|adj|prep|adv(?!p)|number:latin).*")) || LemmaHelper.isCapitalized(tokens[i].getCleanToken())) continue;
            return false;
        }
        return false;
    }

    private static boolean caseGovernmentMatches(List<AnalyzedToken> adjTokenReadings, List<InflectionHelper.Inflection> slaveInflections) {
        return adjTokenReadings.stream().map(p -> p.getLemma()).distinct().anyMatch(item -> {
            Set<String> inflections = CaseGovernmentHelper.CASE_GOVERNMENT_MAP.get(item);
            if (inflections != null) {
                for (InflectionHelper.Inflection inflection : slaveInflections) {
                    if (!inflections.contains(inflection._case)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    private static boolean hasOverlapIgnoreGender(List<InflectionHelper.Inflection> masterInflections, List<InflectionHelper.Inflection> slaveInflections) {
        return TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(masterInflections, slaveInflections, null, null);
    }

    private static boolean hasOverlapIgnoreGender(List<InflectionHelper.Inflection> masterInflections, List<InflectionHelper.Inflection> slaveInflections, String masterGenderFilter, String slaveGenderFilter) {
        for (InflectionHelper.Inflection mInflection : masterInflections) {
            if (masterGenderFilter != null && !mInflection.gender.equalsIgnoreCase(masterGenderFilter)) continue;
            for (InflectionHelper.Inflection sInflection : slaveInflections) {
                if (slaveGenderFilter != null && !sInflection.gender.equalsIgnoreCase(slaveGenderFilter) || !mInflection.equalsIgnoreGender(sInflection)) continue;
                return true;
            }
        }
        return false;
    }

    private static void logException() {
        if (logger.isDebugEnabled()) {
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
            logger.debug("exception: " + stackTraceElement.getLineNumber());
        }
    }
}

